/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.binding;

import com.siggemannen.binding.ABeanTableModel;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenterListHolder;
import com.siggemannen.binding.APropertyListModel;
import com.siggemannen.binding.ChangeListener;
import com.siggemannen.binding.DocumentSizeFilter;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.IView;
import com.siggemannen.binding.NumberDocumentFilter;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.plaf.basic.SpinningCalendarHeaderHandler;

public abstract class APresenter<O, M extends AModel<O>, V extends IView> {
    protected final M model;
    protected final V view;
    boolean inited;

    protected APresenter(M model, V view) {
        this.model = model;
        this.view = view;
    }

    protected void init() {
        if (!this.inited) {
            this.initBindings();
            this.inited = true;
        }
    }

    public M getModel() {
        return this.model;
    }

    public V getView() {
        return this.view;
    }

    public void setObject(O object) {
        this.init();
        ((AModel)this.model).setObject(object);
        this.afterObjectSet();
    }

    protected void addListenersToProperties(ChangeListener listener, IProperty ... properties) {
        IProperty[] iPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty property = iPropertyArray[n2];
            property.addListener(listener);
            ++n2;
        }
    }

    protected void afterObjectSet() {
    }

    protected abstract void initBindings();

    protected boolean disabledNotifications() {
        return false;
    }

    protected void bindToSelection(JTextComponent ta, IProperty<String> property) {
        ta.addCaretListener(e -> {
            int end;
            int start = e.getMark();
            if (start > (end = e.getDot())) {
                int tmp = end;
                end = start;
                start = tmp;
            }
            if (start == end) {
                property.setValue("");
            } else {
                try {
                    String selectedText = ta.getText(start, end - start);
                    property.setValue(selectedText);
                }
                catch (Exception e1) {
                    throw new RuntimeException("Exception occured in listener", e1);
                }
            }
        });
    }

    protected TableBinder lateBind(JTable table) {
        return new TableBinder(table);
    }

    public DateFieldBinder bind(JXDatePicker datePicker) {
        return new DateFieldBinder(datePicker);
    }

    public JSpinnerBinder bind(JSpinner spinner) {
        return new JSpinnerBinder(spinner);
    }

    public TextFieldBinder bind(JTextComponent textField) {
        return new TextFieldBinder(textField);
    }

    protected ListBinder bind(JList list) {
        return new ListBinder(list);
    }

    protected CheckBoxBinder bind(List<JCheckBox> checkboxes) {
        return new CheckBoxBinder(checkboxes);
    }

    public ComboBinder bind(JComboBox component) {
        return new ComboBinder(component);
    }

    public BooleanBinder bind(AbstractButton button) {
        return new BooleanBinder(button);
    }

    protected RadioBinder bind(JRadioButton ... buttons) {
        return new RadioBinder(Arrays.asList(buttons));
    }

    protected RadioBinder bind(JRadioButton other, JTextComponent otherText, JRadioButton ... buttons) {
        return new RadioBinder(Arrays.asList(buttons), other, otherText);
    }

    public static class BooleanBinder<E> {
        private final AbstractButton component;
        private boolean disableNotification;

        BooleanBinder(AbstractButton component) {
            this.component = component;
        }

        public void to(IProperty<Boolean> property) {
            property.addListener(() -> {
                if (!this.disableNotification) {
                    Boolean value = (Boolean)property.getValue();
                    this.component.setSelected(value == null ? false : value);
                }
            });
            this.component.addItemListener(l -> {
                Boolean value = l.getStateChange() == 1;
                this.disableNotification = true;
                property.setValue(value);
                this.disableNotification = false;
            });
        }
    }

    public static class CheckBoxBinder {
        private final List<JCheckBox> checkboxes;
        private boolean isAdjusting;

        CheckBoxBinder(List<JCheckBox> checkboxes) {
            this.checkboxes = checkboxes;
        }

        public <E> void to(IListProperty<E> property, List<E> values) {
            if (this.checkboxes.size() != values.size()) {
                throw new RuntimeException("Different size of checkboxes " + this.checkboxes.size() + " vs list values: " + property.size() + " vs values: " + values.size());
            }
            ArrayList valuesCopy = new ArrayList(values);
            HashMap mapper = new HashMap();
            int i = 0;
            while (i < valuesCopy.size()) {
                Object val = valuesCopy.get(i);
                mapper.put(val, i);
                JCheckBox jc = this.checkboxes.get(i);
                jc.addActionListener(e -> {
                    if (!this.isAdjusting) {
                        this.isAdjusting = true;
                        if (jc.isSelected()) {
                            property.addIfNotExists(val);
                        } else {
                            property.removeObject(val);
                        }
                        this.isAdjusting = false;
                    }
                });
                ++i;
            }
            property.addListener(() -> {
                if (this.isAdjusting) {
                    return;
                }
                this.isAdjusting = true;
                List value = (List)property.getValue();
                if (value != null) {
                    HashSet s = new HashSet();
                    value.forEach(e -> {
                        Integer el = (Integer)mapper.get(e);
                        if (el != null) {
                            s.add(el);
                        }
                    });
                    int i = 0;
                    while (i < valuesCopy.size()) {
                        JCheckBox jcheck = this.checkboxes.get(i);
                        jcheck.setSelected(s.contains(i));
                        ++i;
                    }
                }
                this.isAdjusting = false;
            });
        }
    }

    public static class ComboBinder<E> {
        private final JComboBox<E> component;
        private boolean editable = false;

        ComboBinder(JComboBox component) {
            this.component = component;
        }

        public ComboBinder asEditable() {
            this.editable = true;
            return this;
        }

        public void to(APropertyListModel<E> property) {
            this.component.setModel(property);
        }

        public void to(List<E> list, IProperty<E> property) {
            this.to(list, property, false);
        }

        public void to(List<E> list, IProperty<E> property, boolean rebind) {
            if (rebind && this.component.getModel() instanceof APropertyListModel) {
                APropertyListModel model = (APropertyListModel)this.component.getModel();
                model.clearAndSetNew(list, true);
                return;
            }
            this.component.setEditable(this.editable);
            APresenterListHolder<E> holder = new APresenterListHolder<E>(list);
            AModel<APresenterListHolder> ap = new AModel<APresenterListHolder>(){

                @Override
                protected void copyObject(APresenterListHolder object) {
                    this.copy = object;
                }
            };
            AModel.BoundedListProperty bp = ap.getBoundListProperty("list", property::getValue, property::setValue);
            ap.setObject(holder);
            APropertyListModel apx = new APropertyListModel(bp);
            this.to(apx);
            property.addListener(() -> apx.setSelectedObject(property.getValue()));
        }
    }

    public static class DateFieldBinder {
        private final JXDatePicker comp;

        DateFieldBinder(JXDatePicker comp) {
            this.comp = comp;
        }

        public void to(IProperty<LocalDate> ld) {
            this.comp.setFormats(new DateFormat[]{DateFormat.getDateInstance()});
            this.comp.setDate(new Date());
            UIManager.put("CalendarHeaderHandler", SpinningCalendarHeaderHandler.class.getName());
            this.comp.getMonthView().setZoomable(true);
            ld.addListener(() -> this.comp.setDate(Date.from(((LocalDate)ld.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant())));
            PropertyChangeListener listener = e -> {
                if ("date".equals(e.getPropertyName())) {
                    ld.setValue(this.comp.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                }
            };
            this.comp.addPropertyChangeListener(listener);
        }
    }

    public static class JSpinnerBinder {
        private final JSpinner comp;

        JSpinnerBinder(JSpinner comp) {
            this.comp = comp;
        }

        public void to(IProperty<Integer> prop, Integer maxValue, Integer minValue, Integer stepSize) {
            SpinnerNumberModel model2 = new SpinnerNumberModel(minValue, minValue, maxValue, stepSize);
            this.comp.setModel(model2);
            prop.addListener(() -> model2.setValue(prop.getValue()));
            model2.addChangeListener(c -> prop.setValue((Integer)model2.getValue()));
        }

        public void to(IProperty<LocalTime> timeProp) {
            SpinnerDateModel spinnerModel = new SpinnerDateModel();
            spinnerModel.setValue(JSpinnerBinder.getZeroDate());
            this.comp.setModel(spinnerModel);
            JSpinner.DateEditor editor = new JSpinner.DateEditor(this.comp, "HH:mm:ss");
            DateFormatter formatter = (DateFormatter)editor.getTextField().getFormatter();
            formatter.setAllowsInvalid(false);
            formatter.setOverwriteMode(true);
            this.comp.setEditor(editor);
            timeProp.addListener(() -> {
                if (timeProp.getValue() == null) {
                    spinnerModel.setValue(JSpinnerBinder.getZeroDate());
                    return;
                }
                Instant timeOnEpochDayInDefaultTimeZone = LocalDate.ofEpochDay(0L).atTime((LocalTime)timeProp.getValue()).atZone(ZoneId.systemDefault()).toInstant();
                Date oldfashionedDateObject = Date.from(timeOnEpochDayInDefaultTimeZone);
                spinnerModel.setValue(oldfashionedDateObject);
            });
            spinnerModel.addChangeListener(c -> timeProp.setValue(new Timestamp(spinnerModel.getDate().getTime()).toLocalDateTime().toLocalTime()));
        }

        private static Date getZeroDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 24);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return calendar.getTime();
        }
    }

    public static class ListBinder<E> {
        private final JList component;
        private final boolean isJXList;
        private boolean isAdjusting;

        ListBinder(JList component) {
            this.component = component;
            this.isJXList = component instanceof JXList;
        }

        private int convertViewIndexToModel(int viewIndex) {
            if (viewIndex < 0) {
                return viewIndex;
            }
            if (!this.isJXList) {
                return viewIndex;
            }
            RowSorter r = ((JXList)this.component).getRowSorter();
            int index = r == null || r.getViewRowCount() == r.getModelRowCount() ? viewIndex : r.convertRowIndexToModel(viewIndex);
            return index;
        }

        private int convertModelIndexToView(int modelIndex) {
            if (modelIndex < 0) {
                return modelIndex;
            }
            if (!this.isJXList) {
                return modelIndex;
            }
            RowSorter r = ((JXList)this.component).getRowSorter();
            int index = r == null || r.getViewRowCount() == r.getModelRowCount() ? modelIndex : r.convertRowIndexToView(modelIndex);
            return index;
        }

        public void to(APropertyListModel<E> property) {
            this.component.setSelectionMode(0);
            DefaultListSelectionModel lsm = new DefaultListSelectionModel();
            lsm.setSelectionMode(0);
            this.component.setSelectionModel(lsm);
            lsm.addListSelectionListener(l -> {
                if (!l.getValueIsAdjusting()) {
                    property.valueChanged(this.convertViewIndexToModel(lsm.getMinSelectionIndex()));
                }
            });
            property.addSelectionChangeListener((l, i) -> lsm.setSelectionInterval(this.convertModelIndexToView(i), this.convertModelIndexToView(i)));
            this.component.setModel(property);
        }

        public void to(List<E> list, IProperty<E> property) {
            APresenterListHolder<E> holder = new APresenterListHolder<E>(list);
            AModel<APresenterListHolder> ap = new AModel<APresenterListHolder>(){};
            AModel.BoundedListProperty bp = ap.getBoundListProperty("list", property::getValue, property::setValue);
            ap.setObject(holder);
            APropertyListModel apx = new APropertyListModel(bp);
            this.to(apx);
        }

        public void toSelection(IListProperty<E> listProperty, List<E> listValues) {
            this.component.setSelectionMode(2);
            DefaultListSelectionModel lsm = new DefaultListSelectionModel();
            lsm.setSelectionMode(2);
            this.component.setSelectionModel(lsm);
            DefaultListModel lm = new DefaultListModel();
            listValues.stream().forEachOrdered(lm::addElement);
            this.component.setModel(lm);
            listProperty.addListener(() -> {
                if (this.isAdjusting) {
                    return;
                }
                this.isAdjusting = true;
                List value = (List)listProperty.getValue();
                if (value != null) {
                    int[] indices = value.stream().mapToInt(listValues::indexOf).toArray();
                    this.component.setSelectedIndices(indices);
                }
                this.isAdjusting = false;
            });
            lsm.addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting() && !this.isAdjusting) {
                    this.isAdjusting = true;
                    listProperty.setValue(this.component.getSelectedValuesList());
                    this.isAdjusting = false;
                }
            });
        }
    }

    public static class RadioBinder {
        private final List<JRadioButton> radios;
        private final JRadioButton other;
        private final JTextComponent otherText;

        RadioBinder(List<JRadioButton> radios) {
            this(radios, null, null);
        }

        RadioBinder(List<JRadioButton> radios, JRadioButton other, JTextComponent otherText) {
            this.radios = new ArrayList<JRadioButton>(radios);
            this.other = other;
            this.otherText = otherText;
        }

        public <E> RadioBinder to(IProperty<E> property, E ... values) {
            return this.to(property, Arrays.asList(values));
        }

        public <E> RadioBinder to(IProperty<E> property, List<E> values) {
            WeakHashMap map = new WeakHashMap();
            int i = 0;
            while (i < Math.min(this.radios.size(), values.size())) {
                JRadioButton button = this.radios.get(i);
                Object key = values.get(i);
                map.put(key, button);
                button.addActionListener(e -> {
                    property.setValue(key);
                    if (this.otherText != null) {
                        this.otherText.setEditable(false);
                    }
                });
                property.addListener(() -> {
                    Object current = property.getValue();
                    if (current != null) {
                        JRadioButton jb = (JRadioButton)map.get(current);
                        if (jb != null) {
                            jb.setSelected(true);
                            if (this.otherText != null) {
                                this.otherText.setEditable(false);
                            }
                        } else if (this.other != null) {
                            this.other.setSelected(true);
                            this.otherText.setEditable(true);
                        }
                    }
                });
                ++i;
            }
            if (this.other != null) {
                this.other.addActionListener(e -> {
                    property.setValue(this.otherText.getText());
                    this.otherText.setEditable(true);
                });
            }
            return this;
        }

        public RadioBinder withMaxLength(int maxLength) {
            if (maxLength > 0) {
                ((AbstractDocument)this.otherText.getDocument()).setDocumentFilter(new DocumentSizeFilter(maxLength));
            }
            return this;
        }
    }

    public static class TableBinder {
        JTable table;

        TableBinder(JTable table) {
            this.table = table;
        }

        public void to(ABeanTableModel tableModel) {
            this.table.setColumnModel((TableColumnModel)tableModel.tableColumnModel);
            this.table.setModel(tableModel);
            this.table.revalidate();
            this.table.getModel().addTableModelListener(l -> {
                if (this.table.getModel().getRowCount() > 0 && this.table instanceof JXTable) {
                    ((JXTable)this.table).packAll();
                }
            });
        }
    }

    public static class TextFieldBinder {
        private final JTextComponent component;
        private boolean disableNotification;

        TextFieldBinder(JTextComponent component) {
            this.component = component;
        }

        public void toNumber(final IProperty<Integer> property) {
            property.addListener(() -> {
                if (!this.disableNotification) {
                    this.component.setText(((Integer)property.getValue()).toString());
                }
            });
            ((AbstractDocument)this.component.getDocument()).setDocumentFilter(new NumberDocumentFilter());
            this.component.getDocument().addDocumentListener(new ADocumentAdapter(){

                @Override
                protected void setValueFromDocument(DocumentEvent e) {
                    String text = component.getText();
                    if (text.isEmpty()) {
                        return;
                    }
                    disableNotification = true;
                    property.setValue(Integer.parseInt(text));
                    disableNotification = false;
                }
            });
        }

        public TextFieldConfigurator to(final IProperty<String> property) {
            property.addListener(() -> {
                if (!this.disableNotification) {
                    this.component.setText((String)property.getValue());
                }
            });
            this.component.getDocument().addDocumentListener(new ADocumentAdapter(){

                @Override
                protected void setValueFromDocument(DocumentEvent e) {
                    disableNotification = true;
                    property.setValue(component.getText());
                    disableNotification = false;
                }
            });
            return new TextFieldConfigurator(this.component);
        }

        public <T> void to(IListProperty<T> listProp) {
            this.component.setEditable(false);
            listProp.addListener(() -> {
                if (!this.disableNotification) {
                    this.component.setText(((List)listProp.getValue()).toString());
                }
            });
        }

        public class TextFieldConfigurator {
            private final JTextComponent comp;

            public TextFieldConfigurator(JTextComponent comp) {
                this.comp = comp;
            }

            public TextFieldConfigurator setMaxLength(int length) {
                if (length > 0) {
                    ((AbstractDocument)this.comp.getDocument()).setDocumentFilter(new DocumentSizeFilter(length));
                }
                return this;
            }
        }
    }
}

