/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.binding;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.siggemannen.binding.ChangeListener;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.SoftCopy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import jodd.bean.BeanUtil;
import jodd.bean.exception.NullPropertyBeanException;

public abstract class AModel<O> {
    protected O object;
    protected O copy;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final Map<String, PropertyWrapper> properties = new HashMap<String, PropertyWrapper>();
    private final Gson gson;
    private static final AtomicInteger SYNT_COUNT = new AtomicInteger(0);
    private boolean suspendNotifications = false;

    protected AModel() {
        this.gson = new GsonBuilder().create();
    }

    protected AModel(Gson serializer) {
        this.gson = serializer;
    }

    public O getObject() {
        return this.object;
    }

    public void addModelChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        this.listeners.stream().forEach(listener -> listener.changed());
    }

    public void setObject(O object) {
        this.object = object;
        this.copyObject(object);
        this.notifyListeners();
        this.afterObjectSet();
    }

    protected void copyObject(O object) {
        if (object.getClass().isAnnotationPresent(SoftCopy.class)) {
            this.copy = object;
        } else {
            try {
                this.copy = this.gson.fromJson(this.gson.toJson(object), object.getClass());
            }
            catch (Throwable e) {
                throw new RuntimeException("Error while copying object", e);
            }
        }
    }

    public void revert() {
        this.setObject(this.copy);
    }

    public void revertWithoutNotify() {
        this.suspendNotifications = true;
        try {
            this.setObject(this.copy);
        }
        finally {
            this.suspendNotifications = false;
        }
    }

    public void apply() {
        this.copyObject(this.object);
    }

    protected void afterObjectSet() {
        this.notifyObjectChanged();
    }

    public void notifyObjectChanged() {
        if (this.isSuspendNotifications()) {
            return;
        }
        this.properties.values().forEach(wrapper -> ((PropertyWrapper)wrapper).p.notifyChanges());
    }

    protected boolean isSuspendNotifications() {
        return this.suspendNotifications;
    }

    public final <T> IProperty<T> getProperty(String propertyName) {
        return this.getProperty(this::getObject, propertyName);
    }

    public final <T> IProperty<T> getProperty(Supplier<O> supplier, String propertyName) {
        PropertyWrapper pw = this.properties.get(propertyName);
        if (pw != null) {
            return pw.p;
        }
        this.checkProperty(propertyName);
        Property iProperty = new Property(supplier, propertyName, null, null);
        this.properties.put(propertyName, new PropertyWrapper(iProperty));
        iProperty.addListener(() -> this.notifyListeners());
        return iProperty;
    }

    public final <T> IProperty<T> getProperty(final Function<O, T> resolver) {
        String propertyName = resolver.getClass().toGenericString();
        PropertyWrapper pw = this.properties.get(propertyName);
        if (pw != null) {
            return pw.p;
        }
        Property iProperty = new Property(this, this::getObject, propertyName){

            @Override
            public T getValue() {
                return resolver.apply(this.getObject());
            }

            @Override
            public void setValue(Object value) {
            }
        };
        this.properties.put(propertyName, new PropertyWrapper(iProperty));
        this.addModelChangeListener(() -> {
            if (!this.suspendNotifications) {
                iProperty.notifyChanges();
            }
        });
        return iProperty;
    }

    public final void removeProperty(String propertyName) {
        this.checkProperty(propertyName);
        PropertyWrapper pw = this.properties.remove(propertyName);
        if (pw != null) {
            Property ip = pw.p;
            ip.removeListeners(new ChangeListener[0]);
        }
    }

    public boolean isDirty() {
        return !AModel.equal(this.copy, this.object);
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private void checkProperty(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            throw new IllegalArgumentException("PropertyName cannot be null or empty");
        }
    }

    public final <T> BoundedListProperty<T> getBoundListProperty(String propertyName, String boundedName, IProperty ... iProperties) {
        return this.getBoundListProperty(this::getObject, propertyName, boundedName, iProperties);
    }

    public final <T> BoundedListProperty getBoundListProperty(String propertyName, Supplier<T> getter, Consumer<T> setter) {
        this.checkProperty(propertyName);
        BoundedListProperty<T> lProperty = new BoundedListProperty<T>(this::getObject, propertyName, new SyntheticProperty<T>(getter, setter));
        this.properties.put(propertyName, new PropertyWrapper(lProperty));
        ChangeListener listener = () -> this.notifyListeners();
        lProperty.addListener(listener);
        return lProperty;
    }

    public final <T> BoundedListProperty<T> getBoundListProperty(Supplier<O> supplier, String propertyName, String boundedName, IProperty ... iProperties) {
        this.checkProperty(propertyName);
        this.checkProperty(boundedName);
        BoundedListProperty lProperty = new BoundedListProperty(supplier, propertyName, boundedName);
        this.properties.put(propertyName, new PropertyWrapper(lProperty));
        ChangeListener listener = () -> {
            List<PropertyWrapper> pws = this.getMatchingProperties(iProperties);
            pws.stream().forEach(wrapper -> {
                if (!this.isSuspendNotifications()) {
                    ((PropertyWrapper)wrapper).p.notifyChanges();
                }
            });
            this.notifyListeners();
        };
        lProperty.addListener(listener);
        return lProperty;
    }

    private List<PropertyWrapper> getMatchingProperties(IProperty ... iProperties) {
        ArrayList<PropertyWrapper> pws = new ArrayList<PropertyWrapper>();
        block0: for (PropertyWrapper pw : this.properties.values()) {
            IProperty[] iPropertyArray = iProperties;
            int n = iProperties.length;
            int n2 = 0;
            while (n2 < n) {
                IProperty prop = iPropertyArray[n2];
                if (pw.p.equals(prop)) {
                    pws.add(pw);
                    continue block0;
                }
                ++n2;
            }
        }
        return pws;
    }

    public final <T> IListProperty<T> getListProperty(String propertyName) {
        return this.getListProperty(this::getObject, propertyName);
    }

    public final <T> IListProperty<T> getListProperty(Supplier<O> supplier, String propertyName) {
        this.checkProperty(propertyName);
        ListProperty lProperty = new ListProperty(supplier, propertyName);
        this.properties.put(propertyName, new PropertyWrapper(lProperty));
        lProperty.addListener(() -> this.notifyListeners());
        return lProperty;
    }

    public class BoundedListProperty<E>
    extends ListProperty<E> {
        private final Consumer<E> c;
        private final Supplier<E> s;

        BoundedListProperty(Supplier<O> supplier, String propertyName, String boundedProperty) {
            super(supplier, propertyName);
            this.c = item -> this.setBoundValue(item, boundedProperty);
            this.s = () -> this.getBoundValue(boundedProperty);
        }

        BoundedListProperty(Supplier<O> supplier, String propertyName, IProperty<E> boundProperty) {
            super(supplier, propertyName);
            this.c = boundProperty::setValue;
            this.s = boundProperty::getValue;
        }

        E getSelectedItem() {
            return this.s.get();
        }

        private E getBoundValue(String property) {
            if (this.objectSupplier.get() == null) {
                return null;
            }
            try {
                return (E)BeanUtil.declared.getProperty(this.objectSupplier.get(), property);
            }
            catch (Exception e) {
                System.out.println("Error trying to read value of" + AModel.this.object + " for bounded property:" + property);
                return null;
            }
        }

        private void setBoundValue(E value, String property) {
            try {
                BeanUtil.declared.setProperty(this.objectSupplier.get(), property, value);
                this.notifyChanges();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }

        void setSelectedItem(E item) {
            this.c.accept(item);
        }
    }

    static interface INotifyChanges {
        public void notifyChanges();
    }

    class ListProperty<T>
    extends Property<List<T>>
    implements IListProperty<T> {
        ListProperty(Supplier<O> supplier, String propertyName) {
            super(supplier, propertyName);
        }

        @Override
        public T getRowAt(int index) {
            return (T)((List)this.getValue()).get(index);
        }

        @Override
        public void addRow(T rowToAdd) {
            ((List)this.getValue()).add(rowToAdd);
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public void removeAt(int index) {
            ((List)this.getValue()).remove(index);
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public void replaceValue(int index, T newValue) {
            ((List)this.getValue()).set(index, newValue);
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public void clearAndSetNew(List<T> list) {
            ((List)this.getValue()).clear();
            ((List)this.getValue()).addAll(list);
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public void removeObject(T toRemove) {
            ((List)this.getValue()).remove(toRemove);
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public void insertRowAt(T rowToInsert, int index) {
            ((List)this.getValue()).add(index, rowToInsert);
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public int size() {
            return ((List)this.getValue()).size();
        }

        @Override
        public void clear() {
            ((List)this.getValue()).clear();
            AModel.this.notifyListeners();
            this.notifyChanges();
        }

        @Override
        public void addIfNotExists(T rowToAdd) {
            if (!((List)this.getValue()).contains(rowToAdd)) {
                this.addRow(rowToAdd);
            }
        }
    }

    class Property<T>
    implements IProperty<T>,
    INotifyChanges {
        private final String propertyName;
        private boolean disableNotification;
        private final List<ChangeListener> innerListener = new ArrayList<ChangeListener>();
        protected final Supplier<O> objectSupplier;

        private Property(Supplier<O> objectSupplier, String propertyName) {
            this.propertyName = propertyName;
            this.objectSupplier = objectSupplier;
        }

        @Override
        public T getValue() {
            try {
                return this.getPropertyValue();
            }
            catch (NullPropertyBeanException nestedNull) {
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't access property:" + this.propertyName, e);
            }
        }

        protected T getPropertyValue() {
            return (T)BeanUtil.declared.getProperty(this.objectSupplier.get(), this.propertyName);
        }

        @Override
        public void setValue(T value) {
            try {
                this.setPropertyValue(value);
            }
            catch (NullPropertyBeanException nullPropertyBeanException) {
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Exception when setting value to property: " + this.propertyName, e);
            }
            if (!this.disableNotification) {
                this.notifyChanges();
            }
        }

        protected void setPropertyValue(T value) {
            BeanUtil.declared.setProperty(this.objectSupplier.get(), this.propertyName, value);
        }

        @Override
        public void addListener(ChangeListener listener) {
            this.innerListener.add(listener);
        }

        void setDisableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
        }

        @Override
        public void notifyChanges() {
            int i = 0;
            while (i < this.innerListener.size()) {
                ChangeListener listener = this.innerListener.get(i);
                listener.changed();
                ++i;
            }
        }

        @Override
        public void removeListeners(ChangeListener ... listeners) {
            if (listeners.length == 0) {
                this.innerListener.clear();
            } else {
                this.innerListener.removeAll(Arrays.asList(listeners));
            }
        }

        /* synthetic */ Property(Supplier supplier, String string, Property property, Property property2) {
            this(supplier, string);
        }
    }

    class PropertyWrapper {
        private final Property p;

        PropertyWrapper(Property p) {
            this.p = p;
        }

        void notifyChanges() {
            this.p.notifyChanges();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof PropertyWrapper)) {
                return false;
            }
            PropertyWrapper that = (PropertyWrapper)other;
            return this.p.propertyName.equals(that.p.propertyName);
        }

        public int hashCode() {
            return this.p.propertyName.hashCode();
        }
    }

    class SyntheticProperty<T>
    extends Property<T> {
        private final Supplier<T> getter;
        private final Consumer<T> setter;

        SyntheticProperty(Supplier<T> getter, Consumer<T> setter) {
            super(null, "synthetic#" + SYNT_COUNT.getAndIncrement());
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        protected T getPropertyValue() {
            return this.getter.get();
        }

        @Override
        protected void setPropertyValue(T value) {
            this.setter.accept(value);
        }
    }
}

