/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.binding;

import com.siggemannen.binding.AGetterSetterPresenter;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.binding.OGSP;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class ABeanTableModel<O>
extends AbstractTableModel {
    protected final List<AGetterSetterPresenter> setters = new ArrayList<AGetterSetterPresenter>();
    protected IListProperty<O> objects = null;
    protected List<String> columnNames = new ArrayList<String>();
    private int size = 0;
    protected TableColumnModelExt tableColumnModel = new DefaultTableColumnModelExt();

    public ABeanTableModel(IListProperty<O> objects, List<Tuple<String, String>> cols) {
        List columns = cols.stream().map(t -> Tuple.of((Object)((String)t.first()), new OGSP((String)t.second()))).collect(Collectors.toList());
        this.objects = objects;
        try {
            this.size = objects.size();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 0;
        while (i < columns.size()) {
            Tuple column = (Tuple)columns.get(i);
            this.columnNames.add((String)column.first());
            this.setters.add((AGetterSetterPresenter)column.second());
            TableColumnExt col = new TableColumnExt(i, 300);
            col.setHeaderValue(column.first());
            this.tableColumnModel.addColumn((TableColumn)col);
            ++i;
        }
    }

    public TableColumnModel getTableColumnModel() {
        return this.tableColumnModel;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.setters.get(columnIndex).getValue(this.objects.getRowAt(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        O value = this.objects.getRowAt(rowIndex);
        this.setters.get(columnIndex).setValue(value, aValue);
        this.objects.replaceValue(rowIndex, value);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void setData(List<O> newData) {
        int sizeNew = newData.size();
        if (sizeNew < this.size) {
            this.size = sizeNew;
            this.fireTableDataChanged();
        }
        this.objects.clearAndSetNew(newData);
        this.size = sizeNew;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.size;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

