/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.parsql.sql.transform;

import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TokenType;
import com.siggemannen.core.ListUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TokenUtils {
    public static List<ISQLToken> getTokensUntilNewLine(String text, List<ISQLToken> tokens, int tokenAt) {
        LinkedList<ISQLToken> tokes = new LinkedList<ISQLToken>();
        int i = tokenAt + 1;
        while (i < tokens.size()) {
            ISQLToken t = tokens.get(i);
            TokenType tokenType = t.getTokenType();
            if (tokenType == TokenType.NEWLINE) {
                return tokes;
            }
            if (ListUtils.in((Object)((Object)tokenType), (Object[])new TokenType[]{TokenType.MULTICOMMENT, TokenType.NESTED_MULTICOMMENT, TokenType.NESTED_MULTICOMMENT, TokenType.DOUBLE_QUOTE_IDENTIFIER, TokenType.BRACES_IDENTIFIER, TokenType.STRING, TokenType.MULTILINE_STRING})) {
                int s = t.getStart();
                while (s <= t.getEnd()) {
                    char c = text.charAt(s);
                    if (c == '\r' || c == '\n') {
                        tokes.add(t);
                        return tokes;
                    }
                    ++s;
                }
            }
            tokes.add(t);
            ++i;
        }
        return tokes;
    }

    public static boolean tokenContainsNewLine(ISQLToken t, String text) {
        int s = t.getStart();
        while (s <= t.getEnd()) {
            char c = text.charAt(s);
            if (c == '\r' || c == '\n') {
                return true;
            }
            ++s;
        }
        return false;
    }

    public static List<ISQLToken> trimRight(List<ISQLToken> tokens) {
        int i = tokens.size() - 1;
        while (i >= 0) {
            if (!TokenUtils.tokenIsWhitespace(tokens.get(i))) {
                return tokens.subList(0, i + 1);
            }
            --i;
        }
        return new ArrayList<ISQLToken>();
    }

    public static List<ISQLToken> trimLeft(List<ISQLToken> tokens) {
        int i = 0;
        while (i < tokens.size()) {
            if (!TokenUtils.tokenIsWhitespace(tokens.get(i))) {
                return tokens.subList(i, tokens.size());
            }
            ++i;
        }
        return new ArrayList<ISQLToken>();
    }

    public static boolean tokenIsWhitespace(ISQLToken t) {
        return t.getTokenType() == TokenType.NEWLINE || t.getTokenType() == TokenType.TAB || t.getTokenType() == TokenType.WHITESPACE;
    }
}

