/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.parsql.sql.transform;

import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.ITokenState;
import com.sigge.parsql.sql.transform.Token;
import com.sigge.parsql.sql.transform.TokenFactory;
import com.sigge.parsql.sql.transform.TokenResult;
import com.sigge.parsql.sql.transform.TokenType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class TSQLLexer {
    private static final char COMMENT_STAR = '*';
    private static final char COMMENT_DASH = '-';
    private static final char COMMENT_SLASH = '/';
    public static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("ADD", "EXTERNAL", "PROCEDURE", "ALL", "FETCH", "PUBLIC", "ALTER", "FILE", "RAISERROR", "AND", "FILLFACTOR", "READ", "ANY", "FOR", "READTEXT", "AS", "FOREIGN", "RECONFIGURE", "ASC", "FREETEXT", "REFERENCES", "AUTHORIZATION", "FREETEXTTABLE", "REPLICATION", "BACKUP", "FROM", "RESTORE", "BEGIN", "FULL", "RESTRICT", "BETWEEN", "FUNCTION", "RETURN", "BREAK", "GOTO", "REVERT", "BROWSE", "GRANT", "REVOKE", "BULK", "GROUP", "RIGHT", "BY", "HAVING", "ROLLBACK", "CASCADE", "HOLDLOCK", "ROWCOUNT", "CASE", "IDENTITY", "ROWGUIDCOL", "CHECK", "IDENTITY_INSERT", "RULE", "CHECKPOINT", "IDENTITYCOL", "SAVE", "CLOSE", "IF", "SCHEMA", "CLUSTERED", "IN", "SECURITYAUDIT", "COALESCE", "INDEX", "SELECT", "COLLATE", "INNER", "SEMANTICKEYPHRASETABLE", "COLUMN", "INSERT", "SEMANTICSIMILARITYDETAILSTABLE", "COMMIT", "INTERSECT", "SEMANTICSIMILARITYTABLE", "COMPUTE", "INTO", "SESSION_USER", "CONSTRAINT", "IS", "SET", "CONTAINS", "JOIN", "SETUSER", "CONTAINSTABLE", "KEY", "SHUTDOWN", "CONTINUE", "KILL", "SOME", "CONVERT", "LEFT", "STATISTICS", "CREATE", "LIKE", "SYSTEM_USER", "CROSS", "LINENO", "TABLE", "CURRENT", "LOAD", "TABLESAMPLE", "CURRENT_DATE", "MERGE", "TEXTSIZE", "CURRENT_TIME", "NATIONAL", "THEN", "CURRENT_TIMESTAMP", "NOCHECK", "TO", "CURRENT_USER", "NONCLUSTERED", "TOP", "CURSOR", "NOT", "TRAN", "DATABASE", "NULL", "TRANSACTION", "DBCC", "NULLIF", "TRIGGER", "DEALLOCATE", "OF", "TRUNCATE", "DECLARE", "OFF", "TRY_CONVERT", "DEFAULT", "OFFSETS", "TSEQUAL", "DELETE", "ON", "UNION", "DENY", "OPEN", "UNIQUE", "DESC", "OPENDATASOURCE", "UNPIVOT", "DISK", "OPENQUERY", "UPDATE", "DISTINCT", "OPENROWSET", "UPDATETEXT", "DISTRIBUTED", "OPENXML", "USE", "DOUBLE", "OPTION", "USER", "DROP", "OR", "VALUES", "DUMP", "ORDER", "VARYING", "ELSE", "OUTER", "VIEW", "END", "OVER", "WAITFOR", "ERRLVL", "PERCENT", "WHEN", "ESCAPE", "PIVOT", "WHERE", "EXCEPT", "PLAN", "WHILE", "EXEC", "PRECISION", "WITH", "EXECUTE", "PRIMARY", "WITHIN GROUP", "EXISTS", "PRINT", "WRITETEXT", "EXIT", "PROC"));
    public static final Set<String> BUILD_INS = new HashSet<String>();

    public static List<ISQLToken> parse(String ios) {
        TokenResult parse = TSQLLexer.parse(ios.toCharArray(), 0, ios.length(), new TokenState());
        if (parse.getState().getUnfinishedToken().isPresent()) {
            Token t = new Token(parse.getState().getUnfinishedToken().get(), parse.getState().tokenStart(), ios.length() - 1);
            parse.getTokens().add(t);
        }
        return parse.getTokens();
    }

    public static TokenResult parse(char[] array, int start, int end, ITokenState tokenState) {
        ArrayList<ISQLToken> tokens = new ArrayList<ISQLToken>(20);
        int i = start - 1;
        int state = tokenState.getState();
        int token_start = tokenState.tokenStart();
        TokenType unfinishedToken = null;
        int nestedCommentLevel = tokenState.getNestedCommentLevel();
        int whitespaceType = -1;
        String currencyState = "";
        boolean thisIsTheEnd = false;
        while (true) {
            char c;
            if (++i + 1 == end) {
                thisIsTheEnd = true;
            }
            if (i == end) {
                if (state == 0 || state == 10 || state == 30) break;
                c = ' ';
            } else {
                if (i > end) break;
                c = array[i];
            }
            if (state == 0) {
                if (TSQLLexer.isWhitespace(c)) {
                    whitespaceType = TSQLLexer.getWhitespaceType(c);
                    token_start = i;
                    state = 10;
                    continue;
                }
                state = 11;
            }
            if (state == 10) {
                if (TSQLLexer.isWhitespace(c) && TSQLLexer.getWhitespaceType(c) == whitespaceType) continue;
                tokens.add(TokenFactory.createToken(TSQLLexer.getTokenTypeFromWhitespaceType(whitespaceType), token_start, i - 1));
                whitespaceType = -1;
                token_start = -1;
                if (TSQLLexer.isWhitespace(c)) {
                    --i;
                    state = 0;
                    continue;
                }
                state = 11;
            }
            if (state == 11) {
                if (c == '/' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '*')) {
                    token_start = i++;
                    state = 20;
                    unfinishedToken = TokenType.MULTICOMMENT;
                    ++nestedCommentLevel;
                    continue;
                }
                if (c == '-' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '-')) {
                    token_start = i++;
                    state = 30;
                    continue;
                }
                if (c == '\'') {
                    token_start = i;
                    unfinishedToken = TokenType.STRING;
                    state = 40;
                    continue;
                }
                if (c == 'N' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '\'')) {
                    token_start = i++;
                    unfinishedToken = TokenType.STRING;
                    state = 40;
                    continue;
                }
                if (c == '[') {
                    token_start = i;
                    unfinishedToken = TokenType.BRACES_IDENTIFIER;
                    state = 1500;
                    continue;
                }
                if (c == '\"') {
                    token_start = i;
                    unfinishedToken = TokenType.DOUBLE_QUOTE_IDENTIFIER;
                    state = 1501;
                    continue;
                }
                if (c == ';') {
                    ISQLToken t = TokenFactory.createToken(TokenType.STATEMENT_SPLITTER, i, i);
                    token_start = -1;
                    tokens.add(t);
                    state = 0;
                    continue;
                }
                if (c == '$' || c == '\ufffd' || c == '\ufffd' || TSQLLexer.isCurrencySymbol(c)) {
                    if (i == array.length - 1) {
                        tokens.add(TokenFactory.createToken(TokenType.CURRENCY_NUMBER, i, i));
                        token_start = -1;
                        state = 0;
                        currencyState = "";
                        continue;
                    }
                    currencyState = String.valueOf(c);
                    token_start = i;
                    state = 200;
                    continue;
                }
                if (c == '0' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, 'x')) {
                    token_start = i++;
                    state = 250;
                    continue;
                }
                if (c == ':' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, ':')) {
                    tokens.add(TokenFactory.createToken(TokenType.SCOPE_OR_SYSFUNCTION_OPERATOR, i, i + 1));
                    token_start = -1;
                    ++i;
                    state = 0;
                    continue;
                }
                if (c == ',') {
                    state = 260;
                } else {
                    if (TSQLLexer.isNumber(c)) {
                        token_start = i;
                        state = 200;
                        continue;
                    }
                    state = 12;
                }
            }
            if (state == 12) {
                if (c == '-' || c == '+' || c == '*' || c == '/' || c == '|' || c == '^' || c == '&' || c == '(' || c == ')' || c == '=' || c == '~' || c == '!' || c == '<' || c == '>') {
                    TokenType tp = TokenType.OPERATOR;
                    if (c == '(') {
                        tp = TokenType.START_BRACKET;
                    } else if (c == ')') {
                        tp = TokenType.END_BRACKET;
                    }
                    tokens.add(TokenFactory.createToken(tp, i, i));
                    token_start = -1;
                    state = 0;
                    continue;
                }
                if (c == '{' || c == '}' || c == '\ufffd' || c == '`') {
                    tokens.add(TokenFactory.createToken(TokenType.ILLEGAL_OPERATOR, i, i));
                    token_start = -1;
                    state = 0;
                    continue;
                }
                if (TSQLLexer.isAlpha(c)) {
                    token_start = i;
                    state = 100;
                    continue;
                }
                token_start = i;
                state = 500;
                continue;
            }
            if (state == 20) {
                if (c == '*' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '/')) {
                    if (--nestedCommentLevel == 0) {
                        tokens.add(TokenFactory.createToken(TokenType.MULTICOMMENT, token_start, i + 1));
                        state = 0;
                        token_start = -1;
                        unfinishedToken = null;
                    }
                    ++i;
                    continue;
                }
                if (c != 47 || thisIsTheEnd || !TSQLLexer.safePeek(array, i + 1, end, '*')) continue;
                ++nestedCommentLevel;
                ++i;
                continue;
            }
            if (state == 30) {
                i = TSQLLexer.consumeUntilNewLine(array, i, end);
                tokens.add(TokenFactory.createToken(TokenType.COMMENT, token_start, i - 1));
                --i;
                state = 0;
                continue;
            }
            if (state == 40) {
                if (c != 39) continue;
                if (!thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '\'')) {
                    ++i;
                    continue;
                }
                tokens.add(TokenFactory.createToken(TokenType.STRING, token_start, i));
                token_start = -1;
                state = 0;
                unfinishedToken = null;
                continue;
            }
            if (state == 100) {
                String str;
                if (TSQLLexer.isAlpha(c)) continue;
                if (TSQLLexer.isWhitespace(c) || c == ';' || c == ',' || c == '\'' || c == '\"' || c == '[') {
                    tokens.add(TokenFactory.createToken(KEYWORDS.contains(str = String.valueOf(array, token_start, --i + 1 - token_start).toUpperCase()) ? TokenType.KEYWORD : TokenType.IDENTIFIER, token_start, i));
                    token_start = -1;
                    state = 0;
                    continue;
                }
                if (c == '/' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '*')) {
                    str = String.valueOf(array, token_start, i - token_start).toUpperCase();
                    tokens.add(TokenFactory.createToken(KEYWORDS.contains(str) ? TokenType.KEYWORD : TokenType.IDENTIFIER, token_start, i - 1));
                    token_start = -1;
                    token_start = i;
                    unfinishedToken = TokenType.MULTICOMMENT;
                    ++nestedCommentLevel;
                    state = 20;
                    continue;
                }
                if (c == '-' && !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '-')) {
                    str = String.valueOf(array, token_start, i - token_start).toUpperCase();
                    tokens.add(TokenFactory.createToken(KEYWORDS.contains(str) ? TokenType.KEYWORD : TokenType.IDENTIFIER, token_start, i - 1));
                    token_start = i;
                    state = 30;
                    continue;
                }
                if (TSQLLexer.isOperator(c)) {
                    str = String.valueOf(array, token_start, i - token_start).toUpperCase();
                    tokens.add(TokenFactory.createToken(KEYWORDS.contains(str) ? TokenType.KEYWORD : TokenType.IDENTIFIER, token_start, i - 1));
                    token_start = -1;
                    --i;
                    state = 11;
                    continue;
                }
                --i;
                state = 500;
                continue;
            }
            if (state == 200) {
                if (TSQLLexer.isNumber(c)) continue;
                if (c == '.') {
                    state = 201;
                    continue;
                }
                if (c == 'e' || c == 'E') {
                    state = 202;
                    continue;
                }
                if ("$".equals(currencyState) && TSQLLexer.safePeekString(array, i + 1, end, "action")) {
                    currencyState = "";
                    state = 6000;
                    continue;
                }
                state = 204;
            }
            if (state == 201) {
                if (TSQLLexer.isNumber(c)) continue;
                if (c == 'e' || c == 'E') {
                    state = 202;
                    continue;
                }
                if (c == '.') {
                    state = 666;
                    continue;
                }
                state = 204;
            }
            if (state == 202) {
                if (TSQLLexer.isNumber(c)) continue;
                if (c == '-' || c == '+') {
                    state = 203;
                    continue;
                }
                state = 204;
            }
            if (state == 203) {
                if (TSQLLexer.isNumber(c)) continue;
                state = 204;
            }
            if (state == 204) {
                tokens.add(TokenFactory.createToken(!currencyState.isEmpty() ? TokenType.CURRENCY_NUMBER : TokenType.NUMBER, token_start, i - 1));
                --i;
                token_start = -1;
                state = 0;
                currencyState = "";
                continue;
            }
            if (state == 250) {
                if (TSQLLexer.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                tokens.add(TokenFactory.createToken(TokenType.HEX_NUMBER, token_start, i - 1));
                --i;
                token_start = -1;
                state = 0;
                continue;
            }
            if (state == 259) {
                tokens.add(TokenFactory.createToken(TokenType.DOT, i, i));
                state = 0;
                token_start = -1;
                continue;
            }
            if (state == 260) {
                tokens.add(TokenFactory.createToken(TokenType.COMMA, i, i));
                state = 0;
                token_start = -1;
                continue;
            }
            if (state == 500) {
                TokenType tt;
                if (TSQLLexer.isWhitespace(c) || c == ',' || c == '\'' || c == '\"' || c == ';') {
                    tt = array[token_start] == '@' ? TokenType.VARIABLE : TokenType.IDENTIFIER;
                    tokens.add(TokenFactory.createToken(tt, token_start, i - 1));
                    --i;
                    token_start = -1;
                    state = 0;
                    continue;
                }
                if (!TSQLLexer.isOperator(c)) continue;
                tt = array[token_start] == '@' ? TokenType.VARIABLE : TokenType.IDENTIFIER;
                tokens.add(TokenFactory.createToken(tt, token_start, i - 1));
                --i;
                state = 11;
                token_start = -1;
                continue;
            }
            if (state == 666) {
                if (!TSQLLexer.isWhitespace(c)) continue;
                tokens.add(TokenFactory.createToken(TokenType.ILLEGAL_IDENTIFIER, token_start, i - 1));
                --i;
                state = 0;
                token_start = -1;
                continue;
            }
            if (state == 1500) {
                if (c != ']' || !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, ']')) continue;
                tokens.add(TokenFactory.createToken(TokenType.BRACES_IDENTIFIER, token_start, i));
                token_start = -1;
                state = 0;
                unfinishedToken = null;
                continue;
            }
            if (state != 1501 || c != '\"' || !thisIsTheEnd && TSQLLexer.safePeek(array, i + 1, end, '\"')) continue;
            tokens.add(TokenFactory.createToken(TokenType.DOUBLE_QUOTE_IDENTIFIER, token_start, i));
            token_start = -1;
            state = 0;
            unfinishedToken = null;
        }
        if (state == 10) {
            tokens.add(TokenFactory.createToken(TSQLLexer.getTokenTypeFromWhitespaceType(whitespaceType), token_start, i - 1));
            token_start = -1;
            state = 0;
            unfinishedToken = null;
        } else if (state == 30) {
            tokens.add(TokenFactory.createToken(TokenType.COMMENT, token_start, i - 1));
            token_start = -1;
            state = 0;
            unfinishedToken = null;
        }
        TokenState ts = new TokenState(state, token_start, unfinishedToken, nestedCommentLevel);
        TokenResult tr = new TokenResult(tokens, ts);
        return tr;
    }

    private static int consumeUntilNewLine(char[] array, int current, int end) {
        int i = current;
        while (i < end) {
            if (array[i] == '\r' || array[i] == '\n') {
                return i;
            }
            ++i;
        }
        return end;
    }

    private static boolean safePeekString(char[] array, int i, int end, String string) {
        StringBuilder peek = new StringBuilder();
        int z = i;
        int counter = string.length();
        while (z < end && counter >= z - i) {
            int codePoint = Character.codePointAt(array, z);
            peek.append(Character.toChars(codePoint));
            z += Character.charCount(codePoint);
        }
        return peek.toString().equalsIgnoreCase(string);
    }

    private static TokenType getTokenTypeFromWhitespaceType(int whitespaceType) {
        return whitespaceType == 0 ? TokenType.NEWLINE : (whitespaceType == 1 ? TokenType.TAB : TokenType.WHITESPACE);
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean safePeek(char[] arr, int i, int end, char c) {
        return c == arr[i];
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private static int getWhitespaceType(char c) {
        if (c == '\r' || c == '\n') {
            return 0;
        }
        if (c == '\t') {
            return 1;
        }
        return 2;
    }

    private static boolean isOperator(char c) {
        return c == '%' || c == '&' || c == '/' || c == '*' || c == '=' || c == '+' || c == '-' || c == '(' || c == ')' || c == '^' || c == '|' || c == '<' || c == '>';
    }

    private static boolean isCurrencySymbol(char c) {
        return Character.getType(c) == 26;
    }

    static class TokenState
    implements ITokenState {
        private final int state;
        private final int tokenStart;
        private final Optional<TokenType> unfinishedToken;
        private final int nestedCommentLevel;

        TokenState() {
            this.state = 0;
            this.tokenStart = -1;
            this.unfinishedToken = Optional.empty();
            this.nestedCommentLevel = 0;
        }

        TokenState(int state, int tokenStart, TokenType unfinishedToken, int nestedCommentLevel) {
            this.state = state;
            this.tokenStart = tokenStart;
            this.unfinishedToken = Optional.ofNullable(unfinishedToken);
            this.nestedCommentLevel = nestedCommentLevel;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public int tokenStart() {
            return this.tokenStart;
        }

        @Override
        public Optional<TokenType> getUnfinishedToken() {
            return this.unfinishedToken;
        }

        @Override
        public int getNestedCommentLevel() {
            return this.nestedCommentLevel;
        }

        public String toString() {
            return "State=" + this.state + ", tokenStart =" + this.tokenStart + ", nestedLevel=" + this.nestedCommentLevel;
        }
    }
}

