/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.sqlserver.table;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkData;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.dbrunner.sqlserver.table.SQLServerBulk;
import com.sigge.dbrunner.table.ATableOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ManualBulker;
import com.sigge.dbrunner.table.ScriptOptions;
import com.sigge.dbrunner.table.Table;
import com.sigge.dbrunner.table.TableException;
import com.sigge.dbrunner.table.TableNotExistsException;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import microsoft.sql.DateTimeOffset;

public class SQLTableOperator
extends ATableOperator {
    private static final byte[] LEFT_BRACKET = "(".getBytes();
    private static final byte[] NEWLINE = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
    private static final byte[] SEMICOLOR = ";".getBytes(StandardCharsets.UTF_8);
    public static final DateFormat FORMAT_YYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat FORMAT_WITH_TIME_AND_MS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final byte[] NULL_BYTES = "NULL".getBytes(StandardCharsets.UTF_8);
    private static final byte[] QUOTE_BYTES = "'".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMA_BYTES = ",".getBytes(StandardCharsets.UTF_8);
    private final int major;
    private final int minor;

    public SQLTableOperator(IDatabaseOperator operator) {
        super(operator);
        this.major = ((SQLServerDatabase)operator.getDatabase()).getMajor();
        this.minor = ((SQLServerDatabase)operator.getDatabase()).getMinor();
    }

    @Override
    protected String getNativeColumnDefinition(Column column) throws TableException {
        ColumnType cp = column.getStandardType().get();
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.getQuotedIdentifier(column.getName())).append(" ");
        switch (cp.getType()) {
            case DATETIME: {
                sb.append("DATETIME");
                break;
            }
            case FLOAT: {
                sb.append("FLOAT");
                break;
            }
            case LONG: {
                sb.append("BIGINT");
                break;
            }
            case TEXT: {
                if (this.major >= 9) {
                    sb.append("NVARCHAR(MAX)");
                    break;
                }
                sb.append("NTEXT");
                break;
            }
            case INT: {
                sb.append("INT");
                break;
            }
            case NUMERIC: {
                sb.append("NUMERIC");
                cp.getLength().ifPresent(e -> {
                    StringBuilder stringBuilder2 = sb.append("(").append(e);
                });
                cp.getPrecision().ifPresent(e -> {
                    StringBuilder stringBuilder2 = sb.append(",").append(e);
                });
                if (!cp.getLength().isPresent()) break;
                sb.append(")");
                break;
            }
            case VARCHAR: {
                sb.append("NVARCHAR(");
                sb.append(cp.getLength());
                sb.append(")");
                break;
            }
            case VARBINARY: {
                sb.append("VARBINARY(MAX)");
                break;
            }
            default: {
                throw new TableException("Unsupported column type: " + (Object)((Object)cp.getType()));
            }
        }
        if (cp.isIdentity()) {
            sb.append(" IDENTITY ");
        } else {
            sb.append(" NULL ");
        }
        return sb.toString();
    }

    @Override
    public ITable open(String databaseName, String name, String schema) throws TableException, SQLException {
        StringBuilder sb;
        IScriptRunner runner = this.getOrCreateRunnerFromPool(databaseName);
        if (this.major > 8) {
            sb = new StringBuilder("SELECT sc.name as colname, sc.max_length AS length, sc.[precision], st.name AS typeName FROM sys.objects so (NOLOCK) INNER JOIN sys.columns sc (NOLOCK) ON sc.object_id = so.object_id ");
            sb.append("INNER JOIN systypes st (NOLOCK) ON  st.xusertype = sc.user_type_id ");
            sb.append(" WHERE so.type = 'U' AND so.object_id = OBJECT_ID('").append(name.replace("'", "''")).append("')");
            if (schema != null && schema.length() > 0) {
                sb.append(" AND schema_id = SCHEMA_ID('").append(schema.replace("'", "''")).append("')");
            }
        } else {
            sb = new StringBuilder("SELECT sc.name as colname, sc.length AS length, sc.xprec as [precision], st.name AS typeName\nFROM sysobjects so (NOLOCK)\nINNER JOIN sysusers su (NOLOCK)\n  ON  su.uid = so.uid\nINNER JOIN syscolumns sc (NOLOCK) ON sc.id = so.id\nINNER JOIN systypes st (NOLOCK) ON  st.xusertype = sc.xusertype\nWHERE so.type = 'U' AND so.id = OBJECT_ID('").append(name.replace("'", "''")).append("')");
            if (schema != null && schema.length() > 0) {
                sb.append(" AND su.name = '").append(schema.replace("'", "''")).append("'");
            }
        }
        ArrayList<Column> cols = new ArrayList<Column>();
        Table t = new Table(databaseName, name, schema, cols, this);
        Throwable throwable = null;
        Object var9_10 = null;
        try (ResultSet rs = runner.getConnection().createStatement().executeQuery(sb.toString());){
            while (rs.next()) {
                ColumnType ct;
                String columnname = rs.getString("colname");
                String type = rs.getString("typeName").toUpperCase();
                Optional<Integer> length = Optional.empty();
                Optional<Integer> precision = Optional.empty();
                int len = rs.getInt("length");
                if (!rs.wasNull()) {
                    length = Optional.of(len);
                }
                int prec = rs.getInt("precision");
                if (!rs.wasNull()) {
                    precision = Optional.of(prec);
                }
                switch (type) {
                    case "TINYINT": 
                    case "BIT": 
                    case "INT": 
                    case "SMALLINT": {
                        ct = new ColumnType(DataType.INT);
                        break;
                    }
                    case "BIGINT": {
                        ct = new ColumnType(DataType.LONG);
                        break;
                    }
                    case "REAL": 
                    case "FLOAT": 
                    case "MONEY": {
                        ct = new ColumnType(DataType.FLOAT);
                        break;
                    }
                    case "DECIMAL": 
                    case "NUMERIC": {
                        ct = new ColumnType(DataType.NUMERIC, length, precision);
                        break;
                    }
                    case "DATETIME2": 
                    case "DATETIME": 
                    case "DATE": 
                    case "TIME": {
                        ct = new ColumnType(DataType.DATETIME);
                        break;
                    }
                    case "XML": 
                    case "TEXT": 
                    case "NTEXT": {
                        ct = new ColumnType(DataType.TEXT);
                        break;
                    }
                    case "VARCHAR": {
                        if (len == -1) {
                            ct = new ColumnType(DataType.TEXT);
                            break;
                        }
                        ct = new ColumnType(DataType.VARCHAR, len, 0);
                        break;
                    }
                    case "NVARCHAR": {
                        if (len == -1) {
                            ct = new ColumnType(DataType.TEXT);
                            break;
                        }
                        ct = new ColumnType(DataType.VARCHAR, len / 2, 0);
                        break;
                    }
                    default: {
                        ct = new ColumnType(DataType.UNSUPPORTED);
                    }
                }
                cols.add(new Column(columnname, ct));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (cols.size() == 0) {
            throw new TableNotExistsException("Table " + name + " doesn't exist");
        }
        return t;
    }

    @Override
    public void insert(ITable table, List<ColumnMapping> mapping, IBulk bulker) throws TableException, SQLException {
        block20: {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());){
                String finalName = this.getSafeTableName(table);
                if (this.major > 8) {
                    Throwable throwable2 = null;
                    Object var9_12 = null;
                    try (SQLServerBulkCopy bc = new SQLServerBulkCopy(c);){
                        bc.setDestinationTableName(finalName);
                        SQLServerBulkCopyOptions sqlc = new SQLServerBulkCopyOptions();
                        sqlc.setBulkCopyTimeout(60000);
                        sqlc.setTableLock(true);
                        int i = 0;
                        while (i < mapping.size()) {
                            bc.addColumnMapping(mapping.get(i).getFrom().getName(), mapping.get(i).getTo() + 1);
                            ++i;
                        }
                        bc.setBulkCopyOptions(sqlc);
                        bc.writeToServer((ISQLServerBulkData)new SQLServerBulk(mapping, bulker));
                        break block20;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                new ManualBulker(200, ManualBulker.Style.PREPARED_STATEMENTS){

                    @Override
                    protected void appendStringValue(StringBuilder sb, String s) {
                        if (s == null) {
                            sb.append("NULL");
                        } else {
                            sb.append("N'").append(s.replace("'", "'")).append("'");
                        }
                    }
                }.insert(this.operator, c, finalName, mapping, bulker);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    private String getSafeTableName(ITable table) {
        return this.getNameFrom(table.getSchema(), table.getName());
    }

    private String getNameFrom(String schema, String table) {
        String finalName = "";
        if (schema != null && schema.length() > 0) {
            finalName = String.valueOf(finalName) + this.operator.getQuotedIdentifier(schema) + ".";
        }
        finalName = String.valueOf(finalName) + this.operator.getQuotedIdentifier(table);
        return finalName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void script(ITable table, OutputStream os, ScriptOptions options) throws TableException, SQLException {
        if (options.getTableName() == null) {
            options.setTableName(this.getSafeTableName(table));
        }
        if (options.getCancelled().get().booleanValue()) {
            return;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());
            try {
                try (Statement s = c.createStatement();){
                    this.script(s.executeQuery("select * from " + options.getTableName()), os, options);
                }
                if (c == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (c == null) throw throwable;
                c.close();
                throw throwable;
            }
            c.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public long script(ResultSet rs, OutputStream os, ScriptOptions options) throws SQLException {
        AtomicLong bytes = new AtomicLong(0L);
        ArrayList<String> natives = new ArrayList<String>();
        ResultSetMetaData md = rs.getMetaData();
        String tableName = "YourTableName";
        int i = 0;
        while (i < md.getColumnCount()) {
            natives.add(md.getColumnTypeName(i + 1).toUpperCase());
            if (md.getTableName(i + 1).length() > 0) {
                tableName = this.getNameFrom(md.getSchemaName(i + 1), md.getTableName(i + 1));
            }
            ++i;
        }
        if (options.getTableName() != null && options.getTableName().length() > 0) {
            tableName = options.getTableName();
        }
        long count = 0L;
        BiConsumer<Long, Long> rowCounterCallback = options.getRowCounterCallback();
        try {
            while (rs.next()) {
                if (count % 500L == 0L) {
                    rowCounterCallback.accept(count, null);
                    if (options.getCancelled().get().booleanValue()) {
                        return bytes.get();
                    }
                    if (count > 0L) {
                        this.write(os, SEMICOLOR, bytes);
                        this.write(os, NEWLINE, bytes);
                    }
                    this.write(os, ("INSERT INTO " + tableName + " VALUES").getBytes(StandardCharsets.UTF_8), bytes);
                } else {
                    this.write(os, COMMA_BYTES, bytes);
                }
                ++count;
                os.write(NEWLINE);
                os.write(LEFT_BRACKET);
                int i2 = 0;
                while (i2 < md.getColumnCount()) {
                    if (i2 > 0) {
                        this.write(os, COMMA_BYTES, bytes);
                    }
                    switch ((String)natives.get(i2)) {
                        case "TINYINT": 
                        case "BIT": 
                        case "INT": 
                        case "SMALLINT": 
                        case "BIGINT": {
                            long l = rs.getLong(i2 + 1);
                            if (rs.wasNull()) {
                                this.writeNull(os, bytes);
                                break;
                            }
                            this.write(os, String.valueOf(l).getBytes(StandardCharsets.UTF_8), bytes);
                            break;
                        }
                        case "SMALLDATETIME": 
                        case "DATETIME2": 
                        case "DATETIME": 
                        case "DATE": 
                        case "TIME": {
                            Timestamp ts = rs.getTimestamp(i2 + 1);
                            this.writeSafeString(os, ts == null ? null : SQLTableOperator.getTimestampValue(ts), bytes);
                            break;
                        }
                        case "DATETIMEOFFSET": {
                            DateTimeOffset dts = ((SQLServerResultSet)rs).getDateTimeOffset(i2 + 1);
                            this.writeSafeString(os, dts == null ? null : dts.toString(), bytes);
                            break;
                        }
                        case "VARBINARY": 
                        case "GEOMETRY": 
                        case "TIMESTAMP": 
                        case "HIERARCHYID": 
                        case "GEOGRAPHY": 
                        case "IMAGE": 
                        case "SQL_VARIANT": 
                        case "BINARY": {
                            String s = rs.getString(i2 + 1);
                            this.write(os, (s == null ? "NULL" : "0x").getBytes(StandardCharsets.UTF_8), bytes);
                            if (s == null) break;
                            this.write(os, s.getBytes(StandardCharsets.UTF_8), bytes);
                            break;
                        }
                        case "REAL": 
                        case "FLOAT": 
                        case "MONEY": 
                        case "SMALLMONEY": {
                            float f = rs.getFloat(i2 + 1);
                            this.write(os, rs.wasNull() ? NULL_BYTES : String.valueOf(f).getBytes(StandardCharsets.UTF_8), bytes);
                            break;
                        }
                        case "DECIMAL": 
                        case "NUMERIC": {
                            BigDecimal bd = rs.getBigDecimal(i2 + 1);
                            this.write(os, bd == null ? NULL_BYTES : bd.toPlainString().getBytes(StandardCharsets.UTF_8), bytes);
                            break;
                        }
                        default: {
                            this.writeString(os, rs.getString(i2 + 1), bytes);
                        }
                    }
                    ++i2;
                }
                os.write(")".getBytes());
            }
            if (count % 500L > 0L) {
                os.write(SEMICOLOR);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error occured while writing to output", ex);
        }
        return bytes.get();
    }

    private void write(OutputStream stream, byte[] bytes, AtomicLong l) throws IOException {
        l.addAndGet(bytes.length);
        stream.write(bytes);
    }

    private void writeNull(OutputStream stream, AtomicLong l) throws IOException {
        this.write(stream, NULL_BYTES, l);
    }

    private void writeSafeString(OutputStream stream, String s, AtomicLong l) throws IOException {
        if (s == null) {
            this.write(stream, NULL_BYTES, l);
        } else {
            this.write(stream, QUOTE_BYTES, l);
            this.write(stream, s.getBytes(StandardCharsets.UTF_8), l);
            this.write(stream, QUOTE_BYTES, l);
        }
    }

    private void writeString(OutputStream stream, String s, AtomicLong l) throws IOException {
        if (s == null) {
            this.writeNull(stream, l);
        } else {
            this.write(stream, "N".getBytes(StandardCharsets.UTF_8), l);
            this.write(stream, QUOTE_BYTES, l);
            this.write(stream, s.replace("'", "''").getBytes(StandardCharsets.UTF_8), l);
            this.write(stream, QUOTE_BYTES, l);
        }
    }

    public static String getTimestampValue(Timestamp ts) {
        if (ts.getNanos() == 0 && ts.getSeconds() == 0 && ts.getMinutes() == 0 && ts.getHours() == 0) {
            String format = FORMAT_YYYYMMDD.format(ts.getTime());
            return format;
        }
        return FORMAT_WITH_TIME_AND_MS.format(ts);
    }
}

