/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.sqlserver;

import com.sigge.dbrunner.AScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.dbrunner.SQLPlanType;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

class SQLServerScriptRunner
extends AScriptRunner<SQLServerDatabase> {
    private String sessionId;
    private int productVersion = 0;
    private Integer trancount;
    private boolean executing = false;

    public SQLServerScriptRunner(Connection connection, SQLServerDatabase database) {
        super(connection, database);
        SQLServerScriptRunner.fixLogging();
    }

    private static void fixLogging() {
        Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Channel").setLevel(Level.OFF);
        Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.TOKEN").setLevel(Level.OFF);
    }

    /*
     * Loose catch block
     */
    @Override
    public int openTransactions() {
        if (this.trancount != null) {
            return this.trancount;
        }
        if (this.executing) {
            return 0;
        }
        try {
            String sql = "SELECT @@TRANCOUNT";
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                int n;
                ResultSet rs;
                Statement statement;
                block20: {
                    block19: {
                        statement = this.connection.createStatement();
                        rs = statement.executeQuery(sql);
                        rs.next();
                        this.trancount = rs.getInt(1);
                        n = this.trancount;
                        if (rs == null) break block19;
                        rs.close();
                    }
                    if (statement == null) break block20;
                    statement.close();
                }
                return n;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (statement != null) {
                                statement.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.trancount = null;
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized String getSessionId() throws SQLException {
        if (this.sessionId != null) {
            return this.sessionId;
        }
        String sql = "SELECT @@SPID, CONVERT (varchar(256), SERVERPROPERTY ('productversion'))";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Statement statement = this.connection.createStatement();
                try {
                    try (ResultSet rs = statement.executeQuery(sql);){
                        rs.next();
                        String sessionId = String.valueOf(rs.getInt(1));
                        String version = String.valueOf(rs.getString(2));
                        String[] v = version.split("\\.");
                        if (v.length >= 0) {
                            this.productVersion = Integer.valueOf(v[0]);
                        }
                        this.sessionId = sessionId;
                    }
                    if (statement == null) return this.sessionId;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return this.sessionId;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.sessionId;
    }

    @Override
    public boolean runCommand(String command, SQLOptions options, Statement statement) throws SQLException {
        try {
            if (this.sessionId == null) {
                this.getSessionId();
            }
            this.currentDatabase = null;
            this.trancount = null;
            this.executing = true;
            PreparedStatement realStatement = null;
            if (options.getStatementConsumer() != null) {
                realStatement = (PreparedStatement)statement;
                statement = statement.getConnection().createStatement(1003, 1007);
            }
            if (this.productVersion > 8) {
                statement.execute(options.isParseOnly() ? "SET PARSEONLY ON;\n" : "SET PARSEONLY OFF;\n");
                statement.execute(options.isGenerateQueryPlan() ? "SET STATISTICS XML ON;\n" : "SET STATISTICS XML OFF;\n");
                statement.execute(options.getSQLPlanType() == SQLPlanType.ESTIMATED ? "SET SHOWPLAN_XML ON;\n" : "SET SHOWPLAN_XML OFF;\n");
            } else if (this.productVersion >= 7) {
                statement.execute(options.isParseOnly() ? "SET PARSEONLY ON;\n" : "SET PARSEONLY OFF;\n");
                statement.execute(options.isGenerateQueryPlan() ? "SET STATISTICS PROFILE ON;\n" : "SET STATISTICS PROFILE OFF;\n");
                statement.execute(options.getSQLPlanType() == SQLPlanType.ESTIMATED ? "SET SHOWPLAN_ALL ON;\n" : "SET SHOWPLAN_ALL OFF;\n");
            } else {
                statement.execute(options.isParseOnly() ? "SET PARSEONLY ON\n" : "SET PARSEONLY OFF\n");
                statement.execute(options.isGenerateQueryPlan() ? "SET SHOWPLAN ON\n" : "SET SHOWPLAN OFF\n");
                statement.execute(options.getSQLPlanType() == SQLPlanType.ESTIMATED ? "SET NOEXEC ON\n" : "SET NOEXEC OFF\n");
            }
            if (options.getStatementConsumer() != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                options.getStatementConsumer().consume(realStatement);
                boolean bl = realStatement.execute();
                return bl;
            }
            boolean bl = statement.execute(command);
            return bl;
        }
        finally {
            this.executing = false;
        }
    }
}

