/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.mysql;

import com.sigge.dbrunner.ADatabaseOperator;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.ATableOperator;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.dbrunner.table.TableException;
import java.sql.SQLException;

public class MySQLDatabaseOperator
extends ADatabaseOperator
implements IDatabaseOperator {
    public MySQLDatabaseOperator(Database d) {
        super(d);
    }

    @Override
    public String getQuotedIdentifier(String identifier) {
        return "`" + identifier.replace("`", "``") + "`";
    }

    @Override
    public ITableOperator getTableOperator() {
        return new ATableOperator(this){

            @Override
            public ITable open(String database, String name, String schema) throws TableException, SQLException {
                return super.open(database, name, schema);
            }

            @Override
            protected String getNativeColumnDefinition(Column column) throws TableException {
                StringBuilder sb = new StringBuilder();
                sb.append(this.operator.getQuotedIdentifier(column.getName())).append(" ");
                switch (column.getStandardType().get().getType()) {
                    case VARBINARY: {
                        return sb.append("LONGBLOB").toString();
                    }
                    case TEXT: {
                        return sb.append("LONGTEXT").toString();
                    }
                }
                return super.getNativeColumnDefinition(column);
            }
        };
    }
}

