/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner;

import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public interface Database {
    public String getDatabaseProvider();

    public String getServer();

    public String getUser();

    public String getPassword();

    public String getUrl();

    public boolean isUseAD();

    public String getServerLabel();

    default public String getLabel() {
        String dbLabel = this.getServerLabel();
        if (dbLabel != null && dbLabel.length() > 0) {
            return dbLabel;
        }
        String user = this.getUser();
        String label = String.valueOf(user != null ? String.valueOf(user) + "@" : "") + (this.getServer() != null ? this.getServer() : "");
        if (label.length() <= 1) {
            return this.toString();
        }
        return label;
    }

    public String getUniqueProviderName();

    public Connection createConnection(String var1, Object var2) throws SQLException;

    public void executeScript(Reader var1, String var2, SQLOptions var3) throws SQLException, Exception;

    public void executeScript(Reader var1, String var2, List<IProgressReporter> var3, SQLOptions var4) throws SQLException, Exception;

    public IScriptRunner createRunner(String var1, Object var2) throws SQLException;

    public boolean checkConnection();

    public List<String> getDatabases() throws SQLException;

    public void closeAllSessions();

    public void executeScript(Reader var1, IScriptRunner var2, String var3, List<IProgressReporter> var4, SQLOptions var5) throws SQLException, Exception;

    public IDatabaseOperator getDatabaseOperator();

    public String getConnectionUrl();
}

