/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner;

import com.sigge.dbrunner.ADatabase;
import com.sigge.dbrunner.AScriptRunner;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.jdbc.JDBCDatabaseOperator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public abstract class AJDBCDatabase<E extends AScriptRunner>
extends ADatabase<E> {
    protected final DatabaseServerConfig config;
    protected final String label;

    public AJDBCDatabase(DatabaseServerConfig config) {
        this.config = config;
        this.label = config.getServerLabel();
    }

    @Override
    public String getServer() {
        return this.config.getServer();
    }

    @Override
    public String getConnectionUrl() {
        return this.getUrl();
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    @Override
    public boolean isUseAD() {
        return false;
    }

    @Override
    public String getUniqueProviderName() {
        return String.valueOf(this.config.getUrl()) + "/" + (this.label != null ? this.label : "");
    }

    public String toString() {
        return this.config.getUrl();
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        Connection c = DriverManager.getConnection(this.config.getUrl());
        if (database != null && database.length() > 0) {
            c.setCatalog(database);
        }
        return c;
    }

    @Override
    public String getServerLabel() {
        return this.label;
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return new JDBCDatabaseOperator(this);
    }
}

