/*
 * Decompiled with CFR 0.152.
 */
package com.alluretechnology.noheapdb;

import com.alluretechnology.noheapdb.DataStore;
import com.alluretechnology.noheapdb.FixedHash;
import com.alluretechnology.noheapdb.HashBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NoHeapDBStore
implements DataStore {
    protected static final int MEGABYTE = 0x100000;
    protected static final int JOURNAL_SIZE_FACTOR = 100;
    protected static final int DEFAULT_JOURNAL_SIZE = 0x6400000;
    private static final Logger logger = Logger.getLogger("NoHeapDBStore");
    public static String JOURNAL_VERSION = "JAVAOFFHEAPVERSION_1";
    boolean debugLogging = false;
    protected RandomAccessFile journal = null;
    protected FileChannel channel = null;
    protected int numBuffers = 1;
    protected ByteBuffer buffer = null;
    protected int bufferSize = 0x6400000;
    protected int recordCount;
    protected long currentEnd = 0L;
    protected HashBase index = null;
    public TreeMap<Integer, LinkedList<Long>> emptyIdx = new TreeMap();
    public static byte[] clearBytes = null;
    protected String journalFolder = "";
    protected String journalName = "";
    protected boolean inMemory = true;
    protected boolean reuseExisting = true;
    protected long iterateNext = 0L;
    private final boolean trackPerformance = false;
    private final int persistCount = 0;
    private final long worstPersistTime = 0L;
    private final int deleteCount = 0;
    private final long worstDeleteTime = 0L;
    private long objectGetTime = 0L;
    private long objectPutTime = 0L;

    private NoHeapDBStore() {
    }

    public NoHeapDBStore(String folder, String name) {
        this(folder, name, DataStore.Storage.IN_MEMORY, 0x6400000, true);
    }

    public NoHeapDBStore(String folder, String name, DataStore.Storage type) {
        this(folder, name, type, 0x6400000, true);
    }

    public NoHeapDBStore(String folder, String name, DataStore.Storage type, int sizeInBytes) {
        this(folder, name, type, sizeInBytes, true);
    }

    public NoHeapDBStore(String folder, String name, DataStore.Storage type, int sizeInBytes, boolean reuseExisting) {
        this.reuseExisting = reuseExisting;
        this.journalFolder = folder;
        this.journalName = name;
        this.inMemory = type == DataStore.Storage.IN_MEMORY;
        this.bufferSize = sizeInBytes;
        String journalPath = this.createJournalFolderName(this.journalFolder, this.journalName);
        this.createIndexJournal(journalPath, this.inMemory, reuseExisting);
        this.createMessageJournal(journalPath, this.inMemory, reuseExisting);
    }

    protected final boolean createMessageJournal(String journalPath, boolean inMemory, boolean reuseExisting) {
        if (inMemory) {
            return this.createMessageJournalBB();
        }
        return this.createMessageJournalMBB(journalPath, reuseExisting);
    }

    protected final boolean createMessageJournalBB() {
        try {
            this.buffer = ByteBuffer.allocateDirect(this.bufferSize);
            this.currentEnd = this.buffer.position();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
            return false;
        }
    }

    protected final String createJournalFolderName(String folder, String name) {
        StringBuffer filename = new StringBuffer(this.journalFolder);
        filename.append(File.separator);
        filename.append(this.journalName);
        filename.append("journal");
        return filename.toString();
    }

    protected final boolean createMessageJournalMBB(String journalPath, boolean reuseExisting) {
        block12: {
            try {
                File filePath = new File(this.journalFolder);
                boolean created = filePath.mkdir();
                if (created || filePath.exists()) break block12;
                logger.severe("Directory creation failed: " + this.journalFolder);
                return false;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception", e);
                return false;
            }
        }
        boolean fileExists = false;
        try {
            File file = new File(journalPath);
            fileExists = file.exists();
            if (fileExists && !reuseExisting) {
                File newFile = new File(String.valueOf(journalPath) + "_prev");
                logger.info("Moving journal " + journalPath + " to " + newFile.getName());
                file.renameTo(newFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.journal = new RandomAccessFile(journalPath, "rw");
        if (fileExists && reuseExisting) {
            this.bufferSize = (int)this.journal.length();
        } else {
            this.journal.setLength(this.bufferSize);
        }
        this.channel = this.journal.getChannel();
        this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.bufferSize);
        if (fileExists && reuseExisting) {
            this.currentEnd = this.scanJournal();
            if (this.debugLogging) {
                logger.info("Initializized journal '" + this.journalName + "', existing filename=" + journalPath);
            }
        } else {
            this.writeJournalHeader(this.journal);
            this.currentEnd = this.journal.getFilePointer();
            if (this.debugLogging) {
                logger.info("Created journal '" + this.journalName + "', filename=" + journalPath);
            }
        }
        return true;
    }

    private long scanJournal() {
        for (LinkedList<Long> val : this.emptyIdx.values()) {
            val.clear();
        }
        this.emptyIdx.clear();
        int recordSize = 0;
        try {
            long filesize = this.journal.length();
            String version = this.journal.readUTF();
            String name = this.journal.readUTF();
            Long createTime = this.journal.readLong();
            this.currentEnd = this.journal.getFilePointer();
            ByteBuffer bb = this.buffer;
            bb.position((int)this.currentEnd);
            while (this.currentEnd < filesize - 6L) {
                byte type;
                boolean active = true;
                if (bb.get() == 0) {
                    active = false;
                }
                if ((type = bb.get()) == 0) {
                    bb.position((int)this.currentEnd);
                    break;
                }
                int datalen = bb.getInt();
                recordSize = 6 + datalen;
                if (!active) {
                    this.storeEmptyRecord(this.currentEnd, datalen);
                }
                this.currentEnd += (long)recordSize;
                bb.position((int)this.currentEnd);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
            try {
                StringBuffer sb = new StringBuffer("Persist data: ");
                sb.append(" Journal: " + this.journalName);
                sb.append(", length: " + this.channel.size());
                sb.append(", currentEnd: " + this.currentEnd);
                sb.append(", recordSize: " + recordSize);
                logger.info(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.currentEnd;
    }

    private void writeJournalHeader(RandomAccessFile journal) throws IOException {
        journal.writeUTF(JOURNAL_VERSION);
        journal.writeUTF(this.journalName);
        journal.writeLong(System.currentTimeMillis());
    }

    protected boolean createIndexJournal(String journalPath, boolean inMemory, boolean reuseExisting) {
        try {
            int size = this.bufferSize / 4;
            this.index = new FixedHash(size, journalPath, inMemory, reuseExisting);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private JournalLocationData getStorageLocation(int recordLength) {
        JournalLocationData location = new JournalLocationData();
        location.offset = -1L;
        location.newEmptyRecordSize = -1;
        if (this.emptyIdx == null || this.emptyIdx.isEmpty()) {
            return location;
        }
        try {
            LinkedList<Long> records = this.emptyIdx.get(recordLength);
            if (records != null && !records.isEmpty()) {
                location.offset = records.remove();
                location.newEmptyRecordSize = -1;
                return location;
            }
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer size : this.emptyIdx.keySet()) {
                if (size < recordLength + 6 + 1) continue;
                records = this.emptyIdx.get(size);
                if (records == null || records.size() == 0) {
                    toRemove.add(size);
                    continue;
                }
                location.offset = records.remove();
                location.newEmptyRecordSize = size - recordLength - 6;
                int newOffset = (int)location.offset + recordLength + 6;
                this.storeEmptyRecord(newOffset, location.newEmptyRecordSize);
                break;
            }
            for (Integer offset : toRemove) {
                this.emptyIdx.remove(offset);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
        }
        return location;
    }

    private JournalLocationData setNewRecordLocation(int datalen) {
        int recordSize = 6 + datalen;
        try {
            JournalLocationData location = this.getStorageLocation(datalen);
            if (location.offset == -1L) {
                long journalLen;
                long currentPos = this.buffer.position();
                if (currentPos != this.currentEnd) {
                    currentPos = this.buffer.position((int)this.currentEnd).position();
                }
                if (currentPos + (long)recordSize >= (journalLen = !this.inMemory ? this.channel.size() : (long)this.buffer.capacity())) {
                    currentPos = this.expandJournal(journalLen, currentPos);
                }
                location.offset = this.currentEnd;
                this.currentEnd += (long)recordSize;
            } else {
                this.buffer.position((int)location.offset);
            }
            return location;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    protected long expandJournal(long journalLen, long currentPos) throws IOException {
        if (this.debugLogging) {
            logger.info("Expanding journal size");
        }
        if (this.inMemory) {
            long newLength = journalLen + 0x6400000L;
            System.out.print("Expanding ByteBuffer size to " + newLength + "...");
            ByteBuffer newBuffer = ByteBuffer.allocateDirect((int)newLength);
            if (this.buffer.hasArray()) {
                byte[] array = this.buffer.array();
                newBuffer.put(array);
            } else {
                this.buffer.position(0);
                newBuffer.put(this.buffer);
            }
            this.buffer = newBuffer;
            journalLen = this.buffer.capacity();
        } else {
            System.out.print("Expanding RandomAccessFile journal size to " + (journalLen + 0x6400000L) + "...");
            ((MappedByteBuffer)this.buffer).force();
            this.journal.setLength(journalLen + 0x6400000L);
            this.channel = this.journal.getChannel();
            journalLen = this.channel.size();
            this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, journalLen);
        }
        System.out.println("done");
        currentPos = this.buffer.position();
        if (currentPos != this.currentEnd) {
            this.buffer.position((int)this.currentEnd);
        }
        return currentPos;
    }

    protected void storeEmptyRecord(long offset, int length) {
        LinkedList<Long> emptyRecs = this.emptyIdx.get(length);
        if (emptyRecs == null) {
            emptyRecs = new LinkedList();
            this.emptyIdx.put(length, emptyRecs);
        }
        emptyRecs.add(offset);
    }

    public int getIndexLoad() {
        return this.index.getLoad();
    }

    @Override
    public void delete() {
        try {
            this.index.reset();
            this.emptyIdx.clear();
            if (this.inMemory) {
                this.buffer.clear();
                this.buffer.limit(0);
                this.buffer = ByteBuffer.allocateDirect(0);
            } else {
                this.journal.seek(0L);
                this.channel.truncate(0L);
                this.channel.close();
                this.journal.close();
                File f = new File(this.createJournalFolderName(this.journalFolder, this.journalName));
                f.delete();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized long getRecordCount() {
        return this.recordCount;
    }

    @Override
    public synchronized long getEmptyCount() {
        return this.emptyIdx.size();
    }

    @Override
    public String getName() {
        return this.journalName;
    }

    @Override
    public String getFolder() {
        return this.journalFolder;
    }

    @Override
    public synchronized long getFilesize() {
        try {
            return this.channel.size();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public boolean putLong(String key, Long val) {
        return this.putVal(key, val, (byte)3);
    }

    @Override
    public boolean putInteger(String key, Integer val) {
        return this.putVal(key, val, (byte)4);
    }

    @Override
    public boolean putShort(String key, Short val) {
        return this.putVal(key, val, (byte)7);
    }

    @Override
    public boolean putChar(String key, char val) {
        return this.putVal(key, Character.valueOf(val), (byte)8);
    }

    @Override
    public boolean putFloat(String key, Float val) {
        return this.putVal(key, val, (byte)6);
    }

    @Override
    public boolean putDouble(String key, Double val) {
        return this.putVal(key, val, (byte)5);
    }

    @Override
    public boolean putString(String key, String val) {
        return this.putVal(key, val, (byte)2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putObject(String key, Object obj) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                try {
                    boolean bl;
                    block16: {
                        ObjectOutputStream ostream = new ObjectOutputStream(bstream);
                        try {
                            ostream.writeObject(obj);
                            byte[] bytes = bstream.toByteArray();
                            ostream.close();
                            bl = this.putVal(key, bytes, (byte)9);
                            return bl;
                        }
                        finally {
                            if (ostream == null) break block16;
                            ostream.close();
                        }
                    }
                    if (bstream != null) {
                        bstream.close();
                    }
                    return bl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bstream == null) throw throwable;
                    bstream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.severe("Exception: " + e.toString());
            return false;
        }
    }

    @Override
    public Long getLong(String key) {
        return (Long)this.getValue(key, (byte)3);
    }

    @Override
    public Integer getInteger(String key) {
        return (Integer)this.getValue(key, (byte)4);
    }

    @Override
    public Short getShort(String key) {
        return (Short)this.getValue(key, (byte)7);
    }

    @Override
    public Float getFloat(String key) {
        return (Float)this.getValue(key, (byte)6);
    }

    @Override
    public Double getDouble(String key) {
        return (Double)this.getValue(key, (byte)5);
    }

    @Override
    public char getChar(String key) {
        Object obj = this.getValue(key, (byte)8);
        if (obj != null) {
            return ((Character)obj).charValue();
        }
        return '\u0000';
    }

    @Override
    public String getString(String key) {
        return (String)this.getValue(key, (byte)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(String key) {
        Object object = null;
        Object obj = this.getValue(key, (byte)9);
        if (obj == null) {
            return null;
        }
        byte[] bytes = (byte[])obj;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                try {
                    try (ObjectInputStream ostream = new ObjectInputStream(bis);){
                        object = ostream.readObject();
                    }
                    if (bis == null) return object;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bis == null) throw throwable;
                    bis.close();
                    throw throwable;
                }
                bis.close();
                return object;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(String key) {
        Long offset = -1L;
        int datalength = -1;
        try {
            NoHeapDBStore noHeapDBStore = this;
            synchronized (noHeapDBStore) {
                offset = this.getRecordOffset(key);
                if (offset == -1L) {
                    return false;
                }
                this.buffer.position(offset.intValue());
                this.buffer.put((byte)0);
                this.buffer.put((byte)-1);
                datalength = this.buffer.getInt();
                this.storeEmptyRecord(offset, datalength);
                this.index.remove(key);
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
            logger.severe("deleteMessage data, offset=" + offset + ", length=" + datalength + ", bufferSize=" + this.bufferSize);
            try {
                logger.severe("current journal data, filePointer=" + this.journal.getFilePointer() + ", filesize=" + this.journal.length());
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean putVal(String key, Object val, byte type) {
        try {
            long start = System.currentTimeMillis();
            NoHeapDBStore noHeapDBStore = this;
            synchronized (noHeapDBStore) {
                int datalen;
                switch (type) {
                    case 3: {
                        datalen = 8;
                        break;
                    }
                    case 4: {
                        datalen = 4;
                        break;
                    }
                    case 5: {
                        datalen = 8;
                        break;
                    }
                    case 6: {
                        datalen = 4;
                        break;
                    }
                    case 7: {
                        datalen = 2;
                        break;
                    }
                    case 8: {
                        datalen = 2;
                        break;
                    }
                    case 2: {
                        datalen = ((String)val).getBytes().length;
                        break;
                    }
                    case 9: {
                        datalen = ((byte[])val).length;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                JournalLocationData location = this.setNewRecordLocation(datalen);
                this.buffer.put((byte)1);
                this.buffer.put(type);
                this.buffer.putInt(datalen);
                switch (type) {
                    case 3: {
                        this.buffer.putLong((Long)val);
                        break;
                    }
                    case 4: {
                        this.buffer.putInt((Integer)val);
                        break;
                    }
                    case 5: {
                        this.buffer.putDouble((Double)val);
                        break;
                    }
                    case 6: {
                        this.buffer.putFloat(((Float)val).floatValue());
                        break;
                    }
                    case 7: {
                        this.buffer.putShort((Short)val);
                        break;
                    }
                    case 8: {
                        this.buffer.putChar(((Character)val).charValue());
                        break;
                    }
                    case 2: {
                        this.buffer.put(((String)val).getBytes());
                        break;
                    }
                    case 9: {
                        this.buffer.put((byte[])val);
                        break;
                    }
                }
                if (location.newEmptyRecordSize != -1) {
                    this.buffer.put((byte)0);
                    this.buffer.put((byte)-1);
                    this.buffer.putInt(location.newEmptyRecordSize);
                    if ((long)this.buffer.position() > this.currentEnd) {
                        this.currentEnd = this.buffer.position();
                    }
                }
                this.indexRecord(key, location.offset);
                ++this.recordCount;
                long end = System.currentTimeMillis();
                this.objectPutTime += end - start;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Object getValue(String key, byte type) {
        Long offset = this.getRecordOffset(key);
        if (offset != null && offset > -1L) {
            return this.getValue(offset, type);
        }
        return null;
    }

    protected Object getValue(Long offset, byte type) {
        Object val;
        block14: {
            long start;
            block16: {
                block15: {
                    val = null;
                    if (offset == null || offset <= -1L) break block14;
                    start = System.currentTimeMillis();
                    this.buffer.position(offset.intValue());
                    byte active = this.buffer.get();
                    if (active == 1) break block15;
                    return null;
                }
                byte typeStored = this.buffer.get();
                if (type == typeStored) break block16;
                return null;
            }
            try {
                int dataLength = this.buffer.getInt();
                switch (type) {
                    case 3: {
                        val = this.buffer.getLong();
                        break;
                    }
                    case 4: {
                        val = this.buffer.getInt();
                        break;
                    }
                    case 5: {
                        val = this.buffer.getDouble();
                        break;
                    }
                    case 6: {
                        val = Float.valueOf(this.buffer.getFloat());
                        break;
                    }
                    case 7: {
                        val = this.buffer.getShort();
                        break;
                    }
                    case 8: {
                        val = Character.valueOf(this.buffer.getChar());
                        break;
                    }
                    case 9: {
                        byte[] bytes = new byte[dataLength];
                        this.buffer.get(bytes);
                        val = bytes;
                        break;
                    }
                    case 2: {
                        byte[] bytes = new byte[dataLength];
                        this.buffer.get(bytes);
                        val = new String(bytes);
                    }
                }
                long end = System.currentTimeMillis();
                this.objectGetTime += end - start;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception", e);
            }
        }
        return val;
    }

    @Override
    public Object iterateStart() {
        try {
            long current = 0L;
            if (this.journal != null) {
                this.journal.seek(0L);
                long filesize = this.journal.length();
                String version = this.journal.readUTF();
                String name = this.journal.readUTF();
                Long createTime = this.journal.readLong();
                current = this.journal.getFilePointer();
            }
            return this.getNextRecord(current);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object iterateNext() {
        return this.getNextRecord(this.iterateNext);
    }

    protected Object getNextRecord(long current) {
        int recordSize = 0;
        try {
            ByteBuffer bb = this.buffer;
            if ((long)bb.position() != current) {
                bb.position((int)current);
            }
            boolean found = false;
            byte type = -1;
            while (!found && current < (long)(this.bufferSize - 6)) {
                boolean active = true;
                if (bb.get() == 0) {
                    active = false;
                }
                if ((type = bb.get()) == 0) {
                    bb.position((int)this.currentEnd);
                    break;
                }
                int datalen = bb.getInt();
                recordSize = 6 + datalen;
                if (active) {
                    found = true;
                    this.iterateNext = current + (long)recordSize;
                    continue;
                }
                bb.position((int)(current += (long)recordSize));
            }
            if (found) {
                return this.getValue(current, type);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
        }
        return null;
    }

    protected Long getRecordOffset(String key) {
        Long location = this.index.get(key);
        return location;
    }

    protected boolean indexRecord(String key, long recordLocation) {
        return this.index.put(key, recordLocation);
    }

    public int getCollisions() {
        return this.index.getCollisions();
    }

    public long getObjectRetrievalTime() {
        return this.objectGetTime;
    }

    public long getObjectStorageTime() {
        return this.objectPutTime;
    }

    public void outputStats() {
        System.out.println("Data Store:");
        System.out.println(" -size: " + this.buffer.capacity());
        this.index.outputStats();
    }

    @Override
    public boolean putBytes(String key, byte[] bytes) {
        return this.putVal(key, bytes, (byte)9);
    }

    @Override
    public byte[] getBytes(String key) {
        return (byte[])this.getValue(key, (byte)9);
    }

    public static class Header
    implements Serializable {
        byte active;
        byte type;
        int size;
        public static final int HEADER_SIZE = 6;
    }

    class JournalLocationData {
        long offset;
        int newEmptyRecordSize;

        JournalLocationData() {
        }
    }
}

