/*
 * Decompiled with CFR 0.152.
 */
package com.alluretechnology.noheapdb;

import com.alluretechnology.noheapdb.HashBase;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixedHash
implements HashBase {
    protected static final Logger logger = Logger.getLogger("NIOPersistence");
    protected boolean debugLogging = false;
    protected static int LOAD_THRESHOLD = 70;
    protected static final int PAGE_SIZE = 0x100000;
    protected static final int SIZE_FACTOR = 100;
    protected static final int DEFAULT_INDEX_JOURNAL_SIZE = 0x6400000;
    protected static final int KEY_SIZE = 0;
    protected static final int INDEX_ENTRY_SIZE_BYTES = 13;
    protected long sizeInBytes = 0x6400000L;
    protected int previousOffset = 0;
    protected int bucketsFree = 0;
    protected int bucketsUsed = 0;
    protected int totalBuckets = 0;
    protected int collisions = 0;
    protected String journalPath = "";
    protected boolean inMemory = true;
    protected RandomAccessFile indexFile = null;
    protected FileChannel indexChannel = null;
    protected ByteBuffer indexBuffer = null;
    protected byte keyLength = (byte)16;
    protected long indexCurrentEnd = 0L;
    protected int indexRecordReadCount = 1;
    protected int iterateNext = 0;

    public FixedHash(String journalPath, boolean inMemory, boolean reuseExisting) {
        this(0x6400000, journalPath, inMemory, reuseExisting);
    }

    public FixedHash(int size, String journalPath, boolean inMemory, boolean reuseExisting) {
        boolean success = false;
        this.sizeInBytes = size;
        this.inMemory = inMemory;
        this.journalPath = journalPath;
        success = inMemory ? this.createIndexJournalBB() : this.createIndexJournalMBB(reuseExisting);
        if (success) {
            this.totalBuckets = (int)(this.sizeInBytes / 13L);
            this.bucketsFree = (int)(this.sizeInBytes / 13L);
            this.bucketsUsed = 0;
        }
    }

    protected boolean createIndexJournalBB() {
        try {
            this.indexBuffer = ByteBuffer.allocateDirect((int)this.sizeInBytes);
            this.indexCurrentEnd = this.indexBuffer.position();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
            return false;
        }
    }

    protected boolean createIndexJournalMBB(boolean reuseExisting) {
        try {
            this.journalPath = String.valueOf(this.journalPath) + "Index";
            boolean fileExists = false;
            try {
                File file = new File(this.journalPath);
                fileExists = file.exists();
                if (fileExists && !reuseExisting) {
                    File newFile = new File(String.valueOf(this.journalPath) + "_prev");
                    logger.info("Moving journal " + this.journalPath + " to " + newFile.getName());
                    file.renameTo(newFile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.indexFile = new RandomAccessFile(this.journalPath, "rw");
            if (fileExists && reuseExisting) {
                this.sizeInBytes = this.indexFile.length();
            } else {
                this.indexFile.setLength(this.sizeInBytes);
            }
            this.indexChannel = this.indexFile.getChannel();
            this.indexBuffer = this.indexChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.sizeInBytes);
            this.indexCurrentEnd = this.indexBuffer.position();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception", e);
            return false;
        }
    }

    @Override
    public void reset() {
        try {
            this.indexBuffer.clear();
            this.indexBuffer.limit(0);
            if (this.inMemory) {
                this.indexBuffer = ByteBuffer.allocateDirect(0);
            } else {
                this.indexChannel.truncate(0L);
                this.indexChannel.close();
                this.indexFile.close();
                File f = new File(this.journalPath);
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getHashBucket(int hash) {
        return this._getHashBucket(hash);
    }

    protected int getHashBucket(String key) {
        int hash = key.hashCode();
        return this._getHashBucket(hash);
    }

    protected int _getHashBucket(int hash) {
        hash ^= hash >>> 16;
        int buckets = (int)(this.sizeInBytes / 13L);
        int bucket = Math.max(1, Math.abs(hash) % (buckets - 1));
        return bucket * 13;
    }

    protected boolean enlargeIndex() {
        try {
            ByteBuffer oldBuffer = this.indexBuffer;
            if (this.inMemory) {
                logger.log(Level.INFO, "Expanding in-memory index...");
                this.sizeInBytes += 0x6400000L;
                this.createIndexJournalBB();
            } else {
                logger.log(Level.INFO, "Expanding persisted index...");
                ((MappedByteBuffer)this.indexBuffer).force();
                this.indexFile.setLength(this.sizeInBytes + 0x6400000L);
                this.indexChannel = this.indexFile.getChannel();
                this.sizeInBytes = this.indexChannel.size();
                this.indexBuffer = this.indexChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.sizeInBytes);
            }
            this.collisions = 0;
            this.bucketsUsed = 0;
            oldBuffer.position(13);
            int buckets = oldBuffer.capacity() / 13;
            int i = 1;
            while (i <= buckets) {
                byte occupied = oldBuffer.get();
                if (occupied > 0) {
                    int keyHash = oldBuffer.getInt();
                    byte[] fixedKeyBytes = null;
                    Long location = oldBuffer.getLong();
                    this.putInternal(fixedKeyBytes, keyHash, occupied, location);
                } else {
                    oldBuffer.position(i * 13);
                }
                ++i;
            }
            this.totalBuckets = (int)(this.sizeInBytes / 13L);
            this.bucketsFree = this.totalBuckets - this.bucketsUsed;
            logger.log(Level.INFO, "Done!");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected int findBucket(Integer hashcode, int offset, boolean mustFind) {
        boolean found = false;
        int occupied = 1;
        while (occupied > 0 && !found) {
            int keyHash = this.indexBuffer.getInt();
            if (keyHash == hashcode) {
                found = true;
                break;
            }
            if ((long)(offset += 13) >= this.sizeInBytes - 13L) {
                offset = 13;
            }
            this.indexBuffer.position(offset);
            occupied = this.indexBuffer.get();
        }
        if (!found && mustFind) {
            return -1;
        }
        return offset;
    }

    protected boolean putInternal(byte[] fixedKeyBytes, Integer hashcode, byte keyLength, Long value) {
        int offset = this.getHashBucket(hashcode);
        this.indexBuffer.position(offset);
        this.indexBuffer.mark();
        byte occupied = this.indexBuffer.get();
        if (occupied == 0) {
            this.indexBuffer.reset();
        } else {
            ++this.collisions;
            offset = this.findBucket(hashcode, offset, false);
            this.indexBuffer.position(offset);
        }
        this.indexBuffer.put(keyLength);
        this.indexBuffer.putInt(hashcode);
        this.indexBuffer.putLong(value);
        ++this.bucketsUsed;
        return true;
    }

    @Override
    public boolean put(String key, Long value) {
        try {
            if (this.getLoad() > LOAD_THRESHOLD) {
                this.enlargeIndex();
            }
            byte keylen = (byte)key.length();
            byte[] fixedKeyBytes = null;
            return this.putInternal(fixedKeyBytes, key.hashCode(), keylen, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected int getHashBucketOffset(String key) {
        int offset;
        block3: {
            offset = -1;
            try {
                offset = this.getHashBucket(key.hashCode());
                this.indexBuffer.position(offset);
                byte occupied = this.indexBuffer.get();
                if (occupied > 0) {
                    offset = this.findBucket(key.hashCode(), offset, true);
                    break block3;
                }
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return offset;
    }

    @Override
    public Long get(String key) {
        int offset = this.getHashBucketOffset(key);
        if (offset == -1) {
            return -1L;
        }
        return this.indexBuffer.getLong();
    }

    @Override
    public void remove(String key) {
        int offset = this.getHashBucketOffset(key);
        if (offset == -1) {
            return;
        }
        offset = this.findBucket(key.hashCode(), offset, true);
        if (offset != -1) {
            int currPos = this.indexBuffer.position();
            this.indexBuffer.position(currPos -= 5);
            this.indexBuffer.put((byte)0);
        }
    }

    @Override
    public int getCollisions() {
        return this.collisions;
    }

    @Override
    public void outputStats() {
        System.out.println("Index " + this.journalPath + " Stats:");
        System.out.println(" -size: " + this.size());
        System.out.println(" -load: " + this.getLoad());
        System.out.println(" -entries: " + this.entries());
        System.out.println(" -capacity: " + this.capacity());
        System.out.println(" -available: " + this.available());
        System.out.println(" -collisions: " + this.getCollisions());
    }

    public long size() {
        return this.sizeInBytes;
    }

    public int entries() {
        return this.bucketsUsed;
    }

    public int capacity() {
        return this.totalBuckets;
    }

    public int available() {
        return this.capacity() - this.entries();
    }

    @Override
    public int getLoad() {
        int used = this.entries();
        int capac = this.capacity();
        float f = (float)used / (float)capac;
        int load = (int)(f * 100.0f);
        return load;
    }

    public static enum Storage {
        IN_MEMORY,
        PERSISTED;

    }
}

