/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ListTableModel<E, C>
extends AbstractTableModel
implements Serializable {
    protected List<List<E>> dataVector;
    protected List<C> columnIdentifiers;

    public ListTableModel() {
        this(new ArrayList<List<E>>(), new ArrayList());
    }

    public ListTableModel(List<C> columnNames) {
        this.setDataVector(new ArrayList<List<E>>(), columnNames);
    }

    public ListTableModel(List<List<E>> rows, List<C> columns) {
        this.dataVector = rows;
        this.columnIdentifiers = columns;
    }

    public void setColumns(List<C> columns) {
        this.columnIdentifiers = columns;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void setRows(List<List<E>> rows) {
        this.dataVector = rows;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public List<List<E>> getDataVector() {
        return this.dataVector;
    }

    private static <E> List<List<E>> nonNullVector(List<List<E>> v) {
        return v != null ? v : new ArrayList();
    }

    public void setDataVector(List<List<E>> dataVector, List<C> columnIdentifiers) {
        this.dataVector = ListTableModel.nonNullVector(dataVector);
        this.columnIdentifiers = columnIdentifiers == null ? new ArrayList() : columnIdentifiers;
        this.fireTableStructureChanged();
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent e) {
        this.fireTableChanged(e);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void insertRow(int row, List<E> rowData) {
        this.dataVector.add(row, rowData);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRows(int row, Collection<List<E>> rowData) {
        this.dataVector.addAll(row, rowData);
        this.fireTableRowsInserted(row, row + rowData.size());
    }

    public void addRow(List<E> rowData) {
        this.insertRow(this.dataVector.size(), rowData);
    }

    public void insertRow(int row, E[] rowData) {
        this.insertRow(row, Arrays.asList(rowData));
    }

    public void removeRow(int row) {
        this.dataVector.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void setColumnIdentifiers(C[] newIdentifiers) {
        this.setColumns(Arrays.asList(newIdentifiers));
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int column) {
        Object id = null;
        if (column < this.columnIdentifiers.size() && column >= 0) {
            id = this.columnIdentifiers.get(column);
        }
        return id == null ? super.getColumnName(column) : id.toString();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        List<E> rowVector = this.dataVector.get(row);
        return rowVector.get(column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        List<Object> rowVector = this.dataVector.get(row);
        rowVector.set(column, aValue);
        this.fireTableCellUpdated(row, column);
    }
}

