/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.IFilterChangeListener;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.TableFilterState;
import org.oxbow.swingbits.util.CollectionUtils;

public abstract class AbstractTableFilter<T extends JTable>
implements ITableFilter<T> {
    private final Set<IFilterChangeListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Map<Integer, Collection<DistinctColumnItem>> distinctItemCache = Collections.synchronizedMap(new HashMap());
    private final T table;
    private final TableFilterState filterState = new TableFilterState();

    public AbstractTableFilter(T table) {
        this.table = table;
        this.setupDistinctItemCacheRefresh();
    }

    private void setupDistinctItemCacheRefresh() {
        this.clearDistinctItemCache();
        this.listenForDataChange(((JTable)this.table).getModel());
        this.listenForModelChange();
    }

    private void listenForModelChange() {
        ((Container)this.table).addPropertyChangeListener("model", e -> {
            this.clearDistinctItemCache();
            this.listenForDataChange((TableModel)e.getNewValue());
        });
    }

    private void listenForDataChange(TableModel model) {
        if (model != null) {
            model.addTableModelListener(e -> this.clearDistinctItemCache());
        }
    }

    private void clearDistinctItemCache() {
        this.distinctItemCache.clear();
    }

    @Override
    public T getTable() {
        return this.table;
    }

    protected abstract boolean execute(int var1, Collection<DistinctColumnItem> var2);

    @Override
    public boolean apply(int col, Collection<DistinctColumnItem> items) {
        this.setFilterState(col, items);
        boolean result = false;
        result = this.execute(col, items);
        if (result) {
            this.fireFilterChange();
        }
        return result;
    }

    @Override
    public final void addChangeListener(IFilterChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public final void removeChangeListener(IFilterChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public final void fireFilterChange() {
        for (IFilterChangeListener l : this.listeners) {
            l.filterChanged(this);
        }
    }

    @Override
    public Collection<DistinctColumnItem> getDistinctColumnItems(int column) {
        return this.distinctItemCache.computeIfAbsent(column, this::collectDistinctColumnItems);
    }

    private Collection<DistinctColumnItem> collectDistinctColumnItems(int column) {
        TreeSet<DistinctColumnItem> result = new TreeSet<DistinctColumnItem>();
        RowSorter<? extends TableModel> rowSorter = ((JTable)this.table).getRowSorter();
        TableModel model = rowSorter != null ? rowSorter.getModel() : ((JTable)this.table).getModel();
        int row = 0;
        while (row < model.getRowCount()) {
            result.add(new DistinctColumnItem(model.getValueAt(row, column), row));
            ++row;
        }
        return result;
    }

    @Override
    public Collection<DistinctColumnItem> getFilterState(int column) {
        return this.filterState.getValues(column);
    }

    @Override
    public boolean isFiltered(int column) {
        Collection<DistinctColumnItem> checks = this.getFilterState(column);
        return !CollectionUtils.isEmpty(checks) && this.getDistinctColumnItems(column).size() != checks.size();
    }

    @Override
    public boolean includeRow(ITableFilter.Row row) {
        return this.filterState.include(row);
    }

    public void setFilterState(int column, Collection<DistinctColumnItem> values) {
        this.filterState.setValues(column, values);
    }

    @Override
    public void clear() {
        this.filterState.clear();
        List<DistinctColumnItem> items = Collections.emptyList();
        if (((JTable)this.table).getModel().getColumnCount() > 0) {
            this.execute(0, items);
        }
        this.fireFilterChange();
    }
}

