/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.fileutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SkipBOMReader
extends Reader {
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final byte[] BOM2 = new byte[]{-1, -2};
    private static final byte[] BOM3 = new byte[]{-2, -1};
    private final InputStreamReader reader;

    public SkipBOMReader(InputStream in, String encoding) throws IOException {
        byte[] bom;
        boolean streamHasNoBOM;
        PushbackInputStream pushbackStream = new PushbackInputStream(in, BOM.length);
        if (Arrays.asList(StandardCharsets.UTF_8.name(), StandardCharsets.UTF_16LE.name(), StandardCharsets.UTF_16BE.name(), StandardCharsets.UTF_16).contains(encoding) && (streamHasNoBOM = this.streamHasNoBOM(pushbackStream, bom = new byte[BOM.length], BOM))) {
            pushbackStream.unread(bom, 0, BOM.length);
            byte[] bom2 = new byte[BOM2.length];
            boolean streamHasNoBOM2 = this.streamHasNoBOM(pushbackStream, bom2, BOM2);
            if (streamHasNoBOM2) {
                pushbackStream.unread(bom2, 0, BOM2.length);
                streamHasNoBOM2 = this.streamHasNoBOM(pushbackStream, bom2, BOM3);
                if (streamHasNoBOM2) {
                    pushbackStream.unread(bom2, 0, BOM3.length);
                }
            }
        }
        this.reader = new InputStreamReader((InputStream)pushbackStream, encoding);
    }

    private boolean streamHasNoBOM(PushbackInputStream pushbackStream, byte[] bom, byte[] expected) throws IOException {
        return pushbackStream.read(bom, 0, expected.length) != expected.length || !Arrays.equals(bom, expected);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

