/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.fileutils;

import com.ibm.icu.text.CharsetDetector;
import com.siggemannen.core.Tuple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EncodingDetector {
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int BUFFER_SIZE = 8192;
    private static final String CP1252FIX = "cp1252fix";
    private static final String DEFAULT_ENCODING = "Cp1252";
    private static final Map<String, String> CHARSET_MAPPING = EncodingDetector.initCharsetMapping();
    private final CharsetDetector charsetDetector = new CharsetDetector();

    private static Map<String, String> initCharsetMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(StandardCharsets.UTF_16BE.name(), StandardCharsets.UTF_16BE.name());
        map.put(StandardCharsets.UTF_16LE.name(), StandardCharsets.UTF_16LE.name());
        map.put(StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8.name());
        map.put(DEFAULT_ENCODING, CP1252FIX);
        map.put("windows-1252", CP1252FIX);
        return map;
    }

    public String detectFileEncoding(File script) {
        return (String)this.detectFileEncodingAndGetContent(script).second();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String detectFileEncodingFast(File script) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                SeekableByteChannel sbc = Files.newByteChannel(script.toPath(), new OpenOption[0]);
                try {
                    String string;
                    block18: {
                        InputStream in = Channels.newInputStream(sbc);
                        try {
                            long size = Math.min(0x1800000L, sbc.size());
                            if (size > 0x7FFFFFF7L) {
                                throw new OutOfMemoryError("Required array size too large");
                            }
                            Tuple<byte[], String> x = this.detectArray(EncodingDetector.read(in, (int)size, (int)size));
                            if (x.second() == null) {
                                string = DEFAULT_ENCODING;
                            }
                            string = (String)x.second();
                            return string;
                        }
                        finally {
                            if (in == null) break block18;
                            in.close();
                        }
                    }
                    if (sbc != null) {
                        sbc.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (sbc == null) throw throwable;
                    sbc.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible to read script file: " + script.getAbsolutePath(), e);
        }
    }

    private static byte[] read(InputStream source, int initialSize, int maxSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || nread >= maxSize || (n = source.read()) < 0) break;
            if (capacity <= maxSize - capacity) {
                capacity = Math.max(capacity << 1, maxSize);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    public Tuple<byte[], String> detectFileEncodingAndGetContent(File script) {
        try {
            Tuple<byte[], String> detectedCharset = this.detect(script);
            return Tuple.of((Object)((byte[])detectedCharset.first()), (Object)(detectedCharset.second() == null ? DEFAULT_ENCODING : (String)detectedCharset.second()));
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible to read script file: " + script.getAbsolutePath(), e);
        }
    }

    private synchronized Tuple<byte[], String> detect(File script) throws IOException {
        byte[] array = Files.readAllBytes(script.toPath());
        return this.detectArray(array);
    }

    public Tuple<byte[], String> detectArray(byte[] array) {
        this.charsetDetector.setText(array);
        String name = this.charsetDetector.detect().getName();
        String detectedCharset = CHARSET_MAPPING.get(name);
        this.charsetDetector.setText(new byte[0]);
        return Tuple.of((Object)array, (Object)(detectedCharset == null ? name : detectedCharset));
    }
}

