/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.files.FileWriter;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public final class StorageFile
implements Comparable<StorageFile>,
FileWriter {
    static final Logger LOGGER = Logging.getLogger(StorageFile.class);
    private final ShpFiles shpFiles;
    private final File tempFile;
    private final ShpFileType type;

    public StorageFile(ShpFiles shpFiles, File tempFile, ShpFileType type) {
        this.shpFiles = shpFiles;
        this.tempFile = tempFile;
        this.type = type;
    }

    public File getFile() {
        return this.tempFile;
    }

    public FileChannel getWriteChannel() throws IOException {
        return new RandomAccessFile(this.tempFile, "rw").getChannel();
    }

    public void replaceOriginal() throws IOException {
        StorageFile.replaceOriginals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceOriginals(StorageFile ... storageFiles) throws IOException {
        TreeSet<StorageFile> files = new TreeSet<StorageFile>(Arrays.asList(storageFiles));
        ShpFiles currentShpFiles = null;
        URL shpURL = null;
        StorageFile locker = null;
        LinkedList<String> exceptionMessages = new LinkedList<String>();
        {
            for (StorageFile storageFile : files) {
                File dest;
                URL url;
                File storage;
                block15: {
                    if (currentShpFiles != storageFile.shpFiles) {
                        if (currentShpFiles != null) {
                            currentShpFiles.unlockWrite(shpURL, (FileWriter)locker);
                        }
                        locker = storageFile;
                        currentShpFiles = storageFile.shpFiles;
                        shpURL = currentShpFiles.acquireWrite(ShpFileType.SHP, storageFile);
                    }
                    storage = storageFile.getFile();
                    url = currentShpFiles.acquireWrite(storageFile.type, storageFile);
                    dest = URLs.urlToFile((URL)url);
                    if (!storage.equals(dest)) break block15;
                }
                try {
                    if (dest.exists() && !dest.delete()) {
                        LOGGER.severe("Unable to delete the file: " + dest + " when attempting to replace with temporary copy.");
                    }
                    if (storage.exists() && !storage.renameTo(dest)) {
                        LOGGER.fine("Unable to rename temporary file to the file: " + dest + " when attempting to replace with temporary copy");
                        StorageFile.copyFile(storage, url, dest);
                    }
                    storageFile.unlockWriteURL(url);
                    if (!storage.exists()) continue;
                    storage.delete();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Unable to replace original file with temporary.", e);
                    exceptionMessages.add(e.getMessage());
                }
                finally {
                    storageFile.unlockWriteURL(url);
                    if (!storage.exists()) continue;
                    storage.delete();
                }
            }
        }
    }

    private static void copyFile(File storage, URL url, File dest) throws FileNotFoundException, IOException {
        try (FileChannel in = new FileInputStream(storage).getChannel();
             FileChannel out = new FileOutputStream(dest).getChannel();){
            int maxCount = 67076096;
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, maxCount, out)) {
            }
        }
    }

    private void unlockWriteURL(URL url) {
        this.shpFiles.unlockWrite(url, (FileWriter)this);
    }

    @Override
    public int compareTo(StorageFile o) {
        if (this == o) {
            return 0;
        }
        return this.getFile().compareTo(o.getFile());
    }

    public String toString() {
        return this.id();
    }

    @Override
    public String id() {
        return this.getClass().getSimpleName() + ": " + this.tempFile.getName();
    }

    private static /* synthetic */ void lambda$replaceOriginals$0(StringBuilder sb, String s) {
        sb.append("    ").append(s).append("\n");
    }
}

