/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.composite;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.geotools.renderer.composite.RgbaAccessor;

class ByteRgbAccessor
implements RgbaAccessor {
    final Raster raster;
    final byte[] pixels;
    final boolean hasAlpha;
    final int pixelSize;

    public ByteRgbAccessor(Raster raster, boolean hasAlpha) {
        this.raster = raster;
        this.pixelSize = hasAlpha ? 4 : 3;
        this.pixels = new byte[raster.getWidth() * this.pixelSize];
        this.hasAlpha = hasAlpha;
    }

    @Override
    public void readRow(int y) {
        this.raster.getDataElements(0, y, this.raster.getWidth(), 1, this.pixels);
    }

    @Override
    public void getColor(int x, int[] rgba) {
        int base = x * this.pixelSize;
        rgba[0] = this.pixels[base] & 0xFF;
        rgba[1] = this.pixels[base + 1] & 0xFF;
        rgba[2] = this.pixels[base + 2] & 0xFF;
        rgba[3] = this.hasAlpha ? this.pixels[base + 3] & 0xFF : 255;
    }

    @Override
    public void setColor(int x, int r, int g, int b, int a) {
        int base = x * this.pixelSize;
        this.pixels[base] = (byte)(r & 0xFF);
        this.pixels[base + 1] = (byte)(g & 0xFF);
        this.pixels[base + 2] = (byte)(b & 0xFF);
        if (this.hasAlpha) {
            this.pixels[base + 3] = (byte)(a & 0xFF);
        }
    }

    @Override
    public void writeRow(int y, WritableRaster destination) {
        destination.setDataElements(0, y, this.raster.getWidth(), 1, this.pixels);
    }
}

