/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;

public class FnCompare
extends Function {
    private static Collection<SeqType> _expected_args = null;

    public FnCompare() {
        super(new QName("compare"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) {
        return FnCompare.compare(args, ec.getDynamicContext());
    }

    public static ResultSequence compare(Collection<ResultSequence> args, DynamicContext context) throws DynamicError {
        XSString xstr2;
        XSString xstr1;
        BigInteger result;
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnCompare.expected_args());
        Iterator<ResultSequence> argiter = cargs.iterator();
        ResultSequence arg1 = argiter.next();
        ResultSequence arg2 = argiter.next();
        String collationUri = context.getCollationProvider().getDefaultCollation();
        if (argiter.hasNext()) {
            ResultSequence collArg = argiter.next();
            collationUri = collArg.first().getStringValue();
        }
        if ((result = FnCompare.compare_string(collationUri, xstr1 = arg1.empty() ? null : (XSString)arg1.first(), xstr2 = arg2.empty() ? null : (XSString)arg2.first(), context)) != null) {
            return ResultSequenceFactory.create_new(new XSInteger(result));
        }
        return ResultSequenceFactory.create_new();
    }

    public static BigInteger compare_string(String collationUri, XSString xstr1, XSString xstr2, DynamicContext context) throws DynamicError {
        Comparator<String> collator = context.getCollationProvider().getCollation(collationUri);
        if (collator == null) {
            throw DynamicError.unsupported_collation(collationUri);
        }
        if (xstr1 == null || xstr2 == null) {
            return null;
        }
        int ret = collator.compare(xstr1.value(), xstr2.value());
        if (ret == 0) {
            return BigInteger.ZERO;
        }
        if (ret < 0) {
            return BigInteger.valueOf(-1L);
        }
        return BigInteger.ONE;
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

