/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AutoCompleteComboBoxEditor
implements ComboBoxEditor {
    final ComboBoxEditor wrapped;
    final ObjectToStringConverter stringConverter;
    private Object oldItem;

    public AutoCompleteComboBoxEditor(ComboBoxEditor wrapped, ObjectToStringConverter stringConverter) {
        this.wrapped = wrapped;
        this.stringConverter = stringConverter;
    }

    @Override
    public Component getEditorComponent() {
        return this.wrapped.getEditorComponent();
    }

    @Override
    public void setItem(Object anObject) {
        this.oldItem = anObject;
        if (this.getEditorComponent() instanceof JTextComponent) {
            Document c = ((JTextComponent)this.getEditorComponent()).getDocument();
            if (c instanceof AutoCompleteDocument) {
                AutoCompleteDocument ac = (AutoCompleteDocument)c;
                this.wrapped.setItem(this.stringConverter.getPreferredStringForItem(anObject));
                ac.setSelectedItem(anObject, this.stringConverter.getPreferredStringForItem(anObject));
            }
        } else {
            this.wrapped.setItem(this.stringConverter.getPreferredStringForItem(anObject));
        }
    }

    @Override
    public Object getItem() {
        Object wrappedItem = this.wrapped.getItem();
        String[] oldAsStrings = this.stringConverter.getPossibleStringsForItem(this.oldItem);
        int i = 0;
        int n = oldAsStrings.length;
        while (i < n) {
            String oldAsString = oldAsStrings[i];
            if (oldAsString != null && oldAsString.equals(wrappedItem)) {
                return this.oldItem;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void selectAll() {
        this.wrapped.selectAll();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.wrapped.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.wrapped.removeActionListener(l);
    }
}

