/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;
import org.fife.ui.rsyntaxtextarea.focusabletip.ComponentTipWindow;
import org.fife.ui.rsyntaxtextarea.focusabletip.IFocusableTip;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;

public class FocusableComponentTip
implements IFocusableTip {
    private JComponent component;
    private ComponentTipWindow tipWindow;
    private URL imageBase;
    private final TextAreaListener textAreaListener;
    private final HyperlinkListener hyperlinkListener;
    private String lastText;
    private Dimension maxSize;
    private final Rectangle tipVisibleBounds;
    private static final int X_MARGIN = 18;
    private static final int Y_MARGIN = 12;
    private static final ResourceBundle MSG = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip");

    public FocusableComponentTip(JComponent textArea, HyperlinkListener listener) {
        this.setComponent(textArea);
        this.hyperlinkListener = listener;
        this.textAreaListener = new TextAreaListener();
        this.tipVisibleBounds = new Rectangle();
    }

    private void computeTipVisibleBounds() {
        Rectangle r = this.tipWindow.getBounds();
        Point p = r.getLocation();
        SwingUtilities.convertPointFromScreen(p, this.component);
        r.setLocation(p);
        this.tipVisibleBounds.setBounds(r.x, r.y - 15, r.width, r.height + 30);
    }

    private void createAndShowTipWindow(Point p, String text) {
        Window owner = SwingUtilities.getWindowAncestor(this.component);
        this.tipWindow = new ComponentTipWindow(owner, this, text);
        this.tipWindow.setHyperlinkListener(this.hyperlinkListener);
        PopupWindowDecorator decorator = PopupWindowDecorator.get();
        if (decorator != null) {
            decorator.decorate((JWindow)this.tipWindow);
        }
        SwingUtilities.invokeLater(() -> {
            if (this.tipWindow == null) {
                return;
            }
            this.tipWindow.fixSize();
            ComponentOrientation o = this.component.getComponentOrientation();
            SwingUtilities.convertPointToScreen(p, this.component);
            Rectangle sb = TipUtil.getScreenBoundsForPoint((int)point.x, (int)point.y);
            int y = point.y + 12;
            if (y + this.tipWindow.getHeight() >= sb.y + sb.height) {
                y = point.y - 12 - this.tipWindow.getHeight();
            }
            if (y < 0) {
                y = 100;
            }
            if (y + this.tipWindow.getHeight() >= sb.y + sb.height) {
                this.tipWindow.setSize(new Dimension(this.tipWindow.getWidth(), this.tipWindow.getHeight() - 200 - (y + this.tipWindow.getHeight() - (sb.y + sb.height))));
            }
            int x = point.x - 18;
            if (!o.isLeftToRight()) {
                x = point.x - this.tipWindow.getWidth() + 18;
            }
            if (x < sb.x) {
                x = sb.x;
            } else if (x + this.tipWindow.getWidth() > sb.x + sb.width) {
                x = sb.x + sb.width - this.tipWindow.getWidth();
            }
            this.tipWindow.setLocation(x, y);
            this.tipWindow.setVisible(true);
            this.computeTipVisibleBounds();
            this.textAreaListener.install(this.component);
            this.lastText = text;
        });
    }

    @Override
    public URL getImageBase() {
        return this.imageBase;
    }

    @Override
    public Dimension getMaxSize() {
        return this.maxSize;
    }

    static String getString(String key) {
        return MSG.getString(key);
    }

    @Override
    public void possiblyDisposeOfTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.dispose();
            this.tipWindow = null;
            this.textAreaListener.uninstall();
            this.tipVisibleBounds.setBounds(-1, -1, 0, 0);
            this.lastText = null;
            this.component.requestFocus();
        }
    }

    @Override
    public void removeListeners() {
        this.textAreaListener.uninstall();
    }

    public void setImageBase(URL url) {
        this.imageBase = url;
    }

    public void setMaxSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    private void setComponent(JComponent textArea) {
        this.component = textArea;
        ToolTipManager.sharedInstance().registerComponent(textArea);
    }

    public void toolTipRequested(Point p, String text) {
        if (text == null || text.length() == 0) {
            this.possiblyDisposeOfTipWindow();
            this.lastText = text;
            return;
        }
        if (this.lastText == null || text.length() != this.lastText.length() || !text.equals(this.lastText)) {
            this.possiblyDisposeOfTipWindow();
            this.createAndShowTipWindow(p, text);
        }
    }

    private class TextAreaListener
    extends MouseInputAdapter
    implements CaretListener,
    ComponentListener,
    FocusListener,
    KeyListener {
        private TextAreaListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            Object source = e.getSource();
            if (source == FocusableComponentTip.this.component) {
                FocusableComponentTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.handleComponentEvent(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            boolean tipClicked;
            Component c = e.getOppositeComponent();
            boolean bl = tipClicked = c instanceof ComponentTipWindow || c != null && SwingUtilities.getWindowAncestor(c) instanceof ComponentTipWindow;
            if (!tipClicked) {
                FocusableComponentTip.this.possiblyDisposeOfTipWindow();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
        }

        private void handleComponentEvent(ComponentEvent e) {
            FocusableComponentTip.this.possiblyDisposeOfTipWindow();
        }

        public void install(JComponent textArea) {
            if (textArea instanceof JTextComponent) {
                ((JTextComponent)textArea).addCaretListener(this);
            }
            textArea.addComponentListener(this);
            textArea.addFocusListener(this);
            textArea.addKeyListener(this);
            textArea.addMouseListener(this);
            textArea.addMouseMotionListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                FocusableComponentTip.this.possiblyDisposeOfTipWindow();
            } else if (e.getKeyCode() == 113 && FocusableComponentTip.this.tipWindow != null && !FocusableComponentTip.this.tipWindow.getFocusableWindowState()) {
                FocusableComponentTip.this.tipWindow.actionPerformed(null);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (FocusableComponentTip.this.tipVisibleBounds == null || !FocusableComponentTip.this.tipVisibleBounds.contains(e.getPoint())) {
                FocusableComponentTip.this.possiblyDisposeOfTipWindow();
            }
        }

        public void uninstall() {
            if (FocusableComponentTip.this.component instanceof JTextComponent) {
                ((JTextComponent)FocusableComponentTip.this.component).removeCaretListener(this);
            }
            FocusableComponentTip.this.component.removeComponentListener(this);
            FocusableComponentTip.this.component.removeFocusListener(this);
            FocusableComponentTip.this.component.removeKeyListener(this);
            FocusableComponentTip.this.component.removeMouseListener(this);
            FocusableComponentTip.this.component.removeMouseMotionListener(this);
        }
    }
}

