/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.LowLevelKeyListener;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.RunnerView;
import com.sigge.filerunner.view.editors.TabsDialog;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.tabs.ITabManagerSwitcher;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentEditorListener;
import com.sigge.filerunner.view.tabs.TabRendererSupplier;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.ListModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jdesktop.swingx.JXList;

@Singleton
public class TabManagerSwitcher
implements LowLevelKeyListener.LowLevelKeyEventListener,
WindowFocusListener,
WindowStateListener,
ITabManagerSwitcher {
    private int state = 0;
    private final TabsDialog td;
    private DefaultListModel lm;
    private final LowLevelKeyListener lk;
    private final CardHolder<TabContent> holder;
    private final IEditorManager manager;

    @Inject
    public TabManagerSwitcher(@Named(value="mainTab") DnDTabbedPane jt, CardHolder<TabContent> holder, RunnerView view, @Named(value="mainFrame") JFrame mainFrame, final IEditorManager manager) {
        this.holder = holder;
        this.lk = new LowLevelKeyListener();
        this.lk.addListener(this);
        this.manager = manager;
        mainFrame.addWindowFocusListener(this);
        mainFrame.addWindowStateListener(this);
        this.register(new Component[]{view.getPanel().getCheckBoxTree(), jt, view.getPanel().getDatabaseCombobox(), view.getPanel().getRecentList(), view.getPanel().getFilterRecents()});
        manager.addContentEditorListener(new TabContentEditorListener(){

            @Override
            public void editorAdded(TabContent tc, RSyntaxTextArea rx) {
                TabManagerSwitcher.this.register(new Component[]{manager.getAreaForContent(tc)});
            }
        });
        this.td = new TabsDialog(mainFrame, true);
        this.td.getPreview().getDocument().putProperty("multiByte", Boolean.TRUE);
        this.td.getTabList().setSelectionMode(0);
        this.td.getTabList().addKeyListener((KeyListener)this.lk);
        this.td.setFocusTraversalKeysEnabled(false);
        this.td.getTabList().setFocusTraversalKeysEnabled(false);
        this.td.addKeyListener(this.lk);
        this.td.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                TabManagerSwitcher.this.cleanUpWindow();
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
    }

    @Override
    public void register(Component ... comp) {
        Component[] componentArray = comp;
        int n = comp.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.addKeyListener(this.lk);
            ++n2;
        }
    }

    @Override
    public void unregister(Component comp) {
        comp.removeKeyListener(this.lk);
    }

    @Override
    public boolean released(LowLevelKeyListener.ILowLevelKeyReleasedEvent event) {
        if (!event.isCtrlPressed() && this.state > 0) {
            if (this.td.isVisible() && this.state > 1) {
                TabContent tc = (TabContent)this.td.getTabList().getSelectedValue();
                this.cleanUpWindow();
                if (tc != null) {
                    this.holder.current(tc);
                }
            }
            this.state = 0;
            this.cleanUpWindow();
            return false;
        }
        return false;
    }

    @Override
    public boolean pressed(LowLevelKeyListener.ILowLevelKeyPressedEvent event) {
        switch (this.state) {
            case 0: {
                if (!this.isCtrl(event.keyPressed())) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!this.isTab(event.keyPressed())) break;
                List<TabContent> view = this.holder.historyView();
                if (view.size() == 0) {
                    this.state = 0;
                    return true;
                }
                this.td.getTabList().setCellRenderer(TabRendererSupplier.get());
                this.lm = new DefaultListModel();
                view.stream().forEachOrdered(this.lm::addElement);
                this.td.getTabList().setModel((ListModel)this.lm);
                this.td.getTabList().setSelectedValue((Object)this.holder.getNextInCycle(), true);
                this.state = 2;
                this.updatePreview();
                this.td.setVisible(true);
                return false;
            }
            case 2: {
                if (!event.isTabPressed()) break;
                if (event.isShiftPressed()) {
                    this.prevLine();
                } else {
                    this.nextLine();
                }
                return false;
            }
        }
        return false;
    }

    private void prevLine() {
        JXList tabList = this.td.getTabList();
        int idx = tabList.getSelectedIndex();
        if (--idx < 0) {
            idx = this.lm.size() - 1;
        }
        tabList.setSelectedIndex(idx);
        tabList.ensureIndexIsVisible(idx);
        this.updatePreview();
    }

    private void nextLine() {
        JXList tabList = this.td.getTabList();
        int idx = tabList.getSelectedIndex();
        if (++idx == this.lm.getSize()) {
            idx = 0;
        }
        tabList.setSelectedIndex(idx);
        tabList.ensureIndexIsVisible(idx);
        this.updatePreview();
    }

    private void updatePreview() {
        TabContent tc = (TabContent)this.td.getTabList().getSelectedValue();
        RSyntaxTextArea preview = this.td.getPreview();
        TextPaneUtil.configureSyntaxTextArea(preview);
        preview.setHighlightCurrentLine(true);
        preview.setSyntaxEditingStyle(tc.getContentType() != null ? tc.getContentType() : "text/tsql");
        preview.setText(tc.getContent());
        if (preview.getDocument().getLength() <= 0) {
            return;
        }
        int caretPosition = this.manager.getAreaForContent(tc).getCaretPosition();
        if (caretPosition < preview.getDocument().getLength()) {
            preview.setCaretPosition(caretPosition);
        } else {
            preview.setCaretPosition(preview.getDocument().getLength() - 1);
        }
    }

    private boolean isTab(String key) {
        return "Tab".equals(key);
    }

    private boolean isCtrl(String key) {
        return "Ctrl".equals(key);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.cleanUpWindow();
    }

    private void cleanUpWindow() {
        this.state = 0;
        if (this.td.isVisible()) {
            this.td.setVisible(false);
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.state != 2) {
            this.cleanUpWindow();
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e) {
        this.cleanUpWindow();
    }
}

