/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.runners;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.Server;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IQueryActionHolder;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.MainPanel;
import com.sigge.filerunner.view.RunnerView;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.InlineResultView;
import com.sigge.filerunner.view.results.ResultSetData;
import com.sigge.filerunner.view.results.ResultTableHandler;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.ITabManagerSwitcher;
import com.sigge.filerunner.view.tabs.TabContent;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Toolkit;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SQLScriptReporter
implements IRunningState {
    private SQLScriptState fileRunState;
    private boolean resultShown = false;
    private boolean resultShownFile = false;
    private boolean fileViewToggled = false;
    private final Action viewOutputAction;
    private final RunnerView view;
    private final Map<TabContent, SQLScriptState> state = new HashMap<TabContent, SQLScriptState>();
    private final IQueryActionHolder runnerPresenter;
    private TabContent currentContent = null;
    private final ITabManagerSwitcher switcher;
    private final ResultTableHandler resultHandler;
    private final JFrame mainFrame;
    private final JLabel loading = new JLabel(IconUtils.getSmallAnimatedIcon("loader3.gif"));
    private final JLabel finished = new JLabel(IconUtils.getSmallIcon("check.png"));
    private final JLabel errored = new JLabel(IconUtils.getSmallIcon("error.png"));
    private final Map<String, IResultSetTable> repository;
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLScriptReporter.class);
    private final IEditorManager editorManager;
    private final SQLManager sqlManager;

    @Inject
    public SQLScriptReporter(RunnerView view, IQueryActionHolder runnerPresenter, ITabManagerSwitcher switcher, ResultTableHandler resultHandler, @Named(value="mainFrame") JFrame mainFrame, @Named(value="model_repository") Map<String, IResultSetTable> repository, IEditorManager manager, SQLManager sqlManager) {
        this.view = view;
        this.runnerPresenter = runnerPresenter;
        this.switcher = switcher;
        this.resultHandler = resultHandler;
        this.mainFrame = mainFrame;
        this.repository = repository;
        this.editorManager = manager;
        this.sqlManager = sqlManager;
        this.viewOutputAction = ActionUtils.createAction("View output", "column.png", true, () -> this.toggle(this.fileViewToggled ? !this.resultShownFile : !this.resultShown), KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void exportData() {
        this.getCurrentState().ifPresent(cs -> cs.getResultSetPresenter().exportData());
    }

    @Override
    public void exportDataWithOptions() {
        this.getCurrentState().ifPresent(cs -> cs.getResultSetPresenter().exportDataWithOptions());
    }

    void reportStarted(SQLScriptState sqlState) {
        sqlState.setRunning(true);
        if (!sqlState.isToggled()) {
            this.reToggle(true, false);
        }
        sqlState.getResultSetPresenter().started();
        this.repaint(sqlState.getTabContent(), sqlState);
    }

    void reportScriptStarted(SQLScriptState scriptState, String command, SQLOptions options, Statement statement) {
        if (!scriptState.isRunning()) {
            return;
        }
        scriptState.setStatement(statement);
        if (scriptState.isCancelling()) {
            options.cancel();
            try {
                if (!statement.isClosed()) {
                    statement.cancel();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void reportFinished(SQLScriptState scriptState) {
        if (Objects.equals(this.currentContent, scriptState.getTabContent())) {
            this.runnerPresenter.setSQLAction(null);
            this.runnerPresenter.getValidateSQLAction().setEnabled(true);
        }
        scriptState.setRunning(false);
        this.repaint(scriptState.getTabContent(), scriptState);
    }

    void reportScriptFailure(SQLScriptState scriptState, String command, Statement statement, Exception exception, boolean result) {
        if (!scriptState.isRunning()) {
            return;
        }
        scriptState.getResultSetPresenter().present(statement, scriptState.getRunContext(), exception, result);
        scriptState.setLastErrorErrors(true);
        this.repaint(scriptState.getTabContent(), scriptState);
    }

    public void reportServerStarted(SQLScriptState scriptState) {
        if (!scriptState.isRunning()) {
            return;
        }
        scriptState.getResultSetPresenter().serverStarted(scriptState.getRunContext());
    }

    public void reportServerFinished(SQLScriptState scriptState) {
        if (!scriptState.isRunning()) {
            return;
        }
        scriptState.getResultSetPresenter().serverFinished(scriptState.getRunContext());
    }

    public void reportCancelled(SQLScriptState scriptState) {
        if (!scriptState.isRunning()) {
            return;
        }
        scriptState.getResultSetPresenter().executionAborted(scriptState.getRunContext());
        scriptState.setLastErrorErrors(true);
    }

    void reportScriptFinished(SQLScriptState scriptState, String command, Statement statement, boolean result) {
        if (!scriptState.isRunning()) {
            return;
        }
        try {
            try {
                ResultSetData rd = scriptState.getResultSetPresenter().present(statement, scriptState.getRunContext(), null, result);
                scriptState.setLastRunResultsSets(scriptState.getLastRunResultsSets() + rd.getNumberOfResultSets());
                scriptState.setLastRunRows(scriptState.getLastRunRows() + rd.getNumberOfRows());
                scriptState.setLastErrorErrors(rd.isHadExceptions());
                if (scriptState.getTabContent() != null) {
                    scriptState.getTabContent().setStateValue("Finished", true);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occured while rendering results", (Throwable)e);
                this.repaint(scriptState.getTabContent(), scriptState);
            }
        }
        finally {
            this.repaint(scriptState.getTabContent(), scriptState);
        }
    }

    private void repaint(TabContent ctx, SQLScriptState sqlState) {
        SwingUtilities.invokeLater(() -> this.repaintInner(ctx, sqlState));
    }

    public JPanel getCurrentResultView() {
        return this.getCurrentState().map(l -> l.getResultSetPresenter().getView()).orElse(new InlineResultView());
    }

    public void repaintInner(TabContent content, SQLScriptState sqlState) {
        boolean currentWindow;
        boolean bl = currentWindow = this.fileViewToggled && sqlState == this.fileRunState ? true : content.equals(this.currentContent);
        if (currentWindow) {
            this.view.clearPreviousExecution();
        }
        if (sqlState == null) {
            if (currentWindow) {
                this.setRunningState(sqlState, false);
            }
            return;
        }
        if (sqlState.getTabContent() != null) {
            this.editorManager.setRunning(sqlState.getTabContent(), sqlState.isRunning());
        }
        if (!currentWindow) {
            return;
        }
        if (sqlState.isHasRun() || sqlState.isRunning()) {
            this.view.setResultsInfo(sqlState.getLastRunRows(), sqlState.getLastRunResultsSets(), this.getSessionId(sqlState));
            this.view.setRunningLabel(sqlState.getTimerLabel());
            this.view.setRunningIcon(sqlState.isRunning() ? this.loading : (sqlState.isLastErrorErrors() ? this.errored : this.finished));
            new BackgroundRunner(() -> sqlState.getScriptRunner() != null && !sqlState.isRunning() ? sqlState.getScriptRunner().openTransactions() : 0, transactions -> SwingUtilities.invokeLater(() -> {
                if (this.fileViewToggled && sqlState == this.fileRunState || content.equals(this.currentContent)) {
                    this.view.setResultsInfo(sqlState.getLastRunRows(), sqlState.getLastRunResultsSets(), this.getSessionId(sqlState), (int)transactions);
                }
            })).execute();
        }
        this.setRunningState(sqlState, sqlState.isRunning() || sqlState.getRecurringState() != null);
    }

    private void setRunningState(SQLScriptState sqlState, boolean isRunning) {
        this.runnerPresenter.setSQLAction(isRunning ? (sqlState.isRunning() ? sqlState.getCancelAction() : sqlState.getCancelRecurringAction()) : null);
        this.runnerPresenter.getValidateSQLAction().setEnabled(!isRunning);
        this.runnerPresenter.getRecurringActionDropDown().setEnabled(!isRunning);
        this.runnerPresenter.getEstimatedQueryPlanAction().setEnabled(!isRunning);
    }

    public String getSessionId(SQLScriptState sqlState) {
        try {
            return sqlState.getScriptRunner().getSessionId();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isRunning(TabContent content) {
        SQLScriptState scriptState = this.state.get(content);
        return scriptState != null && scriptState.isRunning();
    }

    @Override
    public void newActive(TabContent tc) {
        this.currentContent = tc;
        SQLScriptState sqlState = this.state.get(this.currentContent);
        if (sqlState != null) {
            boolean toggled2 = sqlState.isToggled();
            this.viewOutputAction.putValue("SwingSelectedKey", toggled2);
            this.resultShown = toggled2;
            if (sqlState.isClosed()) {
                sqlState.setClosed(false);
                if (toggled2) {
                    this.toggle(true);
                }
            }
        } else {
            this.viewOutputAction.putValue("SwingSelectedKey", false);
            this.resultShown = false;
        }
        SwingUtilities.invokeLater(() -> {
            boolean bl = this.editorManager.getCurrentTab().requestFocusInWindow();
        });
        this.repaint(this.currentContent, sqlState);
    }

    @Override
    public Optional<SQLScriptState> getCurrentState() {
        return Optional.ofNullable(this.fileViewToggled ? this.fileRunState : this.state.get(this.currentContent));
    }

    @Override
    public void editorRemoved(TabContent tc) {
        SQLScriptState x = this.getCurrentState(tc);
        if (x != null) {
            x.setClosed(true);
        }
    }

    @Override
    public void editorAdded(TabContent tc) {
        if (!ConfigHandler.getConfig().isStickyServer()) {
            return;
        }
        SQLScriptState ss = this.getOrCreateState(tc);
        List<? extends ServerDatabase> cc = this.sqlManager.getCurrents();
        if (cc != null && cc.size() > 0) {
            ss.setServers(cc.stream().filter(s -> s != null && s.getDatabase() != null).map(Server::new).collect(Collectors.toList()));
        }
    }

    @Override
    public SQLScriptState getCurrentState(TabContent content) {
        return this.state.get(content);
    }

    @Override
    public SQLScriptState getOrCreateState(TabContent tc) {
        if (this.currentContent == null) {
            this.currentContent = tc;
        }
        return this.state.computeIfAbsent(tc, x -> new SQLScriptState(this, (TabContent)x, this.resultHandler, this.mainFrame, this.repository));
    }

    @Override
    public SQLScriptState getOrCreateRunFilesState() {
        if (this.fileRunState == null) {
            this.fileRunState = new SQLScriptState(this, null, this.resultHandler, this.mainFrame, this.repository);
        }
        return this.fileRunState;
    }

    @Override
    public void toggle(boolean show) {
        JPanel toToggle;
        this.getCurrentState().ifPresent(l -> l.setToggled(show));
        JPanel jPanel = toToggle = this.fileViewToggled ? this.view.getPanel().getInnerFilePanel() : this.editorManager.getContentPanelForContent(this.currentContent);
        if (show) {
            ComponentUtils.wrapPanelsIntoASplitPane(toToggle, this.getCurrentResultView(), "mainwindow", true);
        } else {
            Container parentComponent = toToggle.getParent();
            if (parentComponent instanceof JSplitPane) {
                ComponentUtils.unwrapPanelsFromASplitPane(toToggle);
            }
        }
        this.viewOutputAction.putValue("SwingSelectedKey", show);
        if (this.fileViewToggled) {
            this.resultShownFile = show;
        } else {
            this.resultShown = show;
        }
        if (!show) {
            this.editorManager.getCurrentTab().requestFocusInWindow();
        }
    }

    public void reToggle(boolean show, boolean previousState) {
        JPanel toToggle;
        JPanel jPanel = toToggle = this.fileViewToggled ? this.view.getPanel().getInnerFilePanel() : this.editorManager.getContentPanelForContent(this.currentContent);
        if (previousState) {
            ComponentUtils.unwrapPanelsFromASplitPane(toToggle);
        }
        this.toggle(show);
    }

    @Override
    public void toggleFileScriptButton() {
        MainPanel panel = this.view.getPanel();
        ((CardLayout)panel.getJPanel4().getLayout()).next(panel.getJPanel4());
        if (!this.fileViewToggled) {
            this.viewOutputAction.putValue("SwingSelectedKey", this.resultShownFile);
        } else {
            this.viewOutputAction.putValue("SwingSelectedKey", this.resultShown);
        }
        this.fileViewToggled = !this.fileViewToggled;
        this.repaint(this.currentContent, this.fileViewToggled ? this.fileRunState : this.getCurrentState(this.currentContent));
    }

    @Override
    public Action getViewOutputAction() {
        return this.viewOutputAction;
    }

    @Override
    public boolean isFileViewToggled() {
        return this.fileViewToggled;
    }

    @Override
    public boolean isToggled() {
        return this.getCurrentState().map(SQLScriptState::isToggled).orElse(false);
    }

    public ITabManagerSwitcher getSwitcher() {
        return this.switcher;
    }

    @Override
    public void removedFromResurrection(TabContent tc) {
        IScriptRunner runner;
        SQLScriptState ss = this.state.remove(tc);
        if (ss != null && (runner = ss.getScriptRunner()) != null) {
            runner.closeConnection();
        }
    }
}

