/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers;

import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextSplitter;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import java.util.List;
import java.util.Optional;

public class ValuesWithColumnsTransformer
implements ICSVTransformer {
    @Override
    public String transform(String csv, Optional<IResultSetTable> table, TransformContext context) {
        boolean preview = context.isPreview();
        Optional<DatabaseContext> currentContext = context.getCurrentContext();
        TextSplitter ts = new TextSplitter(this, csv, table, context, true);
        StringBuilder sb = new StringBuilder(100);
        sb.append("(\n\tVALUES");
        int row = 0;
        int col = 0;
        for (List<String> str : ts.getRows()) {
            sb.append("");
            if (row != 0) {
                sb.append("\t,\t(");
            } else {
                sb.append("\t(");
            }
            ++row;
            col = 0;
            int len = 0;
            while (len < ts.getColumnCount()) {
                if (col > 0) {
                    sb.append(", ");
                }
                if (str.size() > len) {
                    String object = str.get(len);
                    if (object == null || object.equalsIgnoreCase("NULL") || object.length() == 0 && !table.isPresent() && !ts.getStringColumns().containsKey(col)) {
                        sb.append("NULL");
                    } else {
                        if (ts.getStringColumns().containsKey(col)) {
                            sb.append("N'");
                        }
                        sb.append(object.replace("'", "''"));
                        if (ts.getStringColumns().containsKey(col)) {
                            sb.append("'");
                        }
                    }
                } else if (ts.getStringColumns().containsKey(col)) {
                    sb.append("''");
                } else {
                    sb.append("NULL");
                }
                ++col;
                ++len;
            }
            sb.append(")\n");
            if (preview && row > 100) break;
        }
        sb.append(") t (");
        int z = 0;
        while (z < ts.getColumnCount()) {
            if (z > 0) {
                sb.append(",");
            }
            sb.append(this.getSafeColumnName(ts.getColumnNames().get(z), currentContext));
            ++z;
        }
        sb.append(")\n");
        return sb.toString();
    }

    @Override
    public int supports(String csv, Optional<IResultSetTable> table, int lines, int cols) {
        if (lines < 1) {
            return 0;
        }
        return cols / lines > 0 && (cols % lines == 0 || cols % (lines + 1) == 0) ? 3 : 1;
    }

    @Override
    public String getLabel() {
        return "Values";
    }
}

