/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextStyle;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import com.siggemannen.core.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TextSplitter {
    private final List<List<String>> rows = new ArrayList<List<String>>();
    private final Map<Integer, Boolean> stringColumns = new HashMap<Integer, Boolean>();
    private final List<String> columnNames = new ArrayList<String>();
    private final int columnCount;

    public TextSplitter(ICSVTransformer transformer, String csv, Optional<IResultSetTable> table, TransformContext context, boolean firstRowHasHeaders) {
        TextStyle ts = context.getStyle();
        int maxCols = 0;
        if (!table.isPresent()) {
            List<String> stringRows = Arrays.asList(csv.split("[\n\r]"));
            for (String str : stringRows) {
                if (str.length() == 0 || ListUtils.in((Object)ts, (Object[])new TextStyle[]{TextStyle.SPACE_SEPARATED}) && str.matches("[ +-]+") || ts == TextStyle.PIPE_SEPARATED && str.matches("[ +|-]+")) continue;
                ArrayList<String> values = new ArrayList<String>();
                this.rows.add(values);
                List<String> rowData = this.splitString(str, ts);
                int colIndex = 0;
                for (String row : rowData) {
                    if (!(firstRowHasHeaders && this.rows.size() == 1 || this.stringColumns.containsKey(colIndex) || !transformer.isString(row))) {
                        this.stringColumns.put(colIndex, true);
                    }
                    values.add(row);
                    if (maxCols >= ++colIndex) continue;
                    maxCols = colIndex;
                }
            }
            if (firstRowHasHeaders) {
                List<String> headers = this.rows.remove(0);
                int z = 0;
                while (z < maxCols) {
                    String defaultHeader = "col" + (z + 1);
                    String headerColumnName = headers.size() > z ? StringUtils.isBlank(headers.get(z), defaultHeader) : defaultHeader;
                    this.columnNames.add(headerColumnName);
                    ++z;
                }
            } else {
                int z = 0;
                while (z < maxCols) {
                    String colHeader = "col" + (z + 1);
                    this.columnNames.add(colHeader);
                    ++z;
                }
            }
        } else {
            IResultSetTable model = table.get();
            int i = 0;
            while (i < model.getColumnCount()) {
                if (transformer.isString(model, i)) {
                    this.stringColumns.put(i, true);
                }
                this.columnNames.add(model.getColumnName(i));
                ++i;
            }
            i = 0;
            while (i < model.getRowCount()) {
                ArrayList<String> obs = new ArrayList<String>();
                int j = 0;
                while (j < model.getColumnCount()) {
                    obs.add(model.getValueForDisplay(i, j));
                    ++j;
                }
                this.rows.add(obs);
                ++i;
            }
            maxCols = model.getColumnCount();
        }
        this.columnCount = maxCols;
    }

    private List<String> splitString(String str, TextStyle ts) {
        switch (ts) {
            case PIPE_SEPARATED: {
                List<String> splitList = Arrays.asList(str.split(" *\\| *"));
                if (splitList.size() > 0 && splitList.get(0).length() == 0) {
                    splitList = new ArrayList<String>(splitList);
                    splitList.remove(0);
                }
                return splitList;
            }
            case TAB_SEPARATED: {
                return Arrays.asList(str.split(" *\t *"));
            }
            case SPACE_SEPARATED: {
                return Arrays.asList(str.split(" +"));
            }
            case COMMA_SEPARATED: {
                return Arrays.asList(str.split(" *, *"));
            }
        }
        return null;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Map<Integer, Boolean> getStringColumns() {
        return this.stringColumns;
    }
}

