/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertBreakActionWithNewLines
extends RSyntaxTextAreaEditorKit.InsertBreakAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertBreakActionWithNewLines.class);

    protected void handleInsertBreak(RSyntaxTextArea textArea, boolean noSelection) {
        if (noSelection && textArea.isAutoIndentEnabled()) {
            this.insertNewlineWithAutoIndent(textArea);
        } else {
            TextPaneUtil.fixDotAndMarks((RTextArea)textArea);
            textArea.replaceSelection(System.lineSeparator());
            if (noSelection) {
                this.possiblyCloseCurlyBrace(textArea, null, System.lineSeparator());
            }
        }
    }

    private void insertNewlineWithAutoIndent(RSyntaxTextArea sta) {
        try {
            int caretPos = sta.getCaretPosition();
            Document doc = sta.getDocument();
            Element map = doc.getDefaultRootElement();
            int lineNum = map.getElementIndex(caretPos);
            Element line = map.getElement(lineNum);
            int start = line.getStartOffset();
            int end = line.getEndOffset();
            String newLineIsh = doc.getText(start, end - start);
            String newLine = TextPaneUtil.getNewLineFromString(newLineIsh);
            if (newLine != null) {
                end -= newLine.length();
            }
            int len = end - start;
            String s = doc.getText(start, len);
            String newLineToUse = TextPaneUtil.getNewLineToUse(doc, doc.getText(start, line.getEndOffset() - start), lineNum);
            String leadingWS = RSyntaxUtilities.getLeadingWhitespace((String)s);
            StringBuilder sb = new StringBuilder(newLineToUse);
            sb.append(leadingWS);
            int offset = 0;
            int nonWhitespacePos = InsertBreakActionWithNewLines.atEndOfLine(caretPos - start, s, len);
            if (nonWhitespacePos == -1) {
                if (leadingWS.length() == len && sta.isClearWhitespaceLinesEnabled()) {
                    sta.setSelectionStart(start);
                    sta.setSelectionEnd(end);
                } else {
                    Caret c = sta.getCaret();
                    int currentCursorPosition = Math.max(c.getDot(), c.getMark());
                    if (newLine != null && newLine.length() == 2 && currentCursorPosition == end + 1) {
                        if (c.getMark() == c.getDot()) {
                            sta.setSelectionStart(currentCursorPosition - 1);
                        }
                        sta.setSelectionEnd(currentCursorPosition - 1);
                    }
                }
                sta.replaceSelection(sb.toString());
            } else {
                if (end > doc.getLength()) {
                    sb.append(s.substring(0, s.length() - 1).substring(nonWhitespacePos));
                    --end;
                    ++offset;
                } else {
                    sb.append(s.substring(nonWhitespacePos));
                    if (newLineToUse.length() == 2) {
                        ++offset;
                    }
                }
                sta.replaceRange(sb.toString(), caretPos, end);
                int position = caretPos + leadingWS.length() + 1 + offset;
                if (position > doc.getLength()) {
                    LOGGER.error("For some reason we are passed the string, newLineIsh={}, position={}, length={}, leadingWS={}, offset={}", new Object[]{newLineIsh, position, doc.getLength(), leadingWS, offset});
                    sta.setCaretPosition(doc.getLength() - 1);
                } else {
                    sta.setCaretPosition(position);
                }
            }
            if (sta.getShouldIndentNextLine(lineNum)) {
                sta.replaceSelection("\t");
            }
            this.possiblyCloseCurlyBrace(sta, leadingWS, newLineToUse);
        }
        catch (BadLocationException ble) {
            sta.replaceSelection(System.lineSeparator());
            LOGGER.error("Failed to set newline correctly, shouldn't happen", (Throwable)ble);
        }
    }

    private void possiblyCloseCurlyBrace(RSyntaxTextArea textArea, String leadingWS, String newLineToUse) {
        RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
        if (textArea.getCloseCurlyBraces()) {
            int languageIndex;
            int line = textArea.getCaretLineNumber();
            Token t = doc.getTokenListForLine(line - 1);
            if (t == null) {
                return;
            }
            if ((t = t.getLastNonCommentNonWhitespaceToken()) != null && t.isLeftCurly() && doc.getCurlyBracesDenoteCodeBlocks(languageIndex = t.getLanguageIndex()) && InsertBreakActionWithNewLines.getOpenBraceCount(doc, languageIndex) > 0) {
                StringBuilder sb = new StringBuilder();
                if (line == textArea.getLineCount() - 1) {
                    sb.append(newLineToUse);
                }
                if (leadingWS != null) {
                    sb.append(leadingWS);
                }
                sb.append("}").append(newLineToUse);
                int dot = textArea.getCaretPosition();
                int end = textArea.getLineEndOffsetOfCurrentLine();
                textArea.insert(sb.toString(), end);
                textArea.setCaretPosition(dot);
            }
        }
    }

    private static int atEndOfLine(int pos, String s, int sLen) {
        int i = pos;
        while (i < sLen) {
            if (!RSyntaxUtilities.isWhitespace((char)s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int getOpenBraceCount(RSyntaxDocument doc, int languageIndex) {
        int openCount = 0;
        for (Token t : doc) {
            if (t.getType() != 22 || t.length() != 1 || t.getLanguageIndex() != languageIndex) continue;
            char ch = t.charAt(0);
            if (ch == '{') {
                ++openCount;
                continue;
            }
            if (ch != '}') continue;
            --openCount;
        }
        return openCount;
    }
}

