/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.core.ProcessUtils;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.RTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPopup
extends JWindow {
    private final RTextArea textArea;
    private final ChoiceList list;
    private transient Listener listener;
    private boolean prevCaretAlwaysVisible;
    private final Rectangle tipVisibleBounds;
    private boolean isInBounds;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericPopup.class);
    private static final int VERTICAL_SPACE = ProcessUtils.isOnMac() ? -25 : -5;
    private final Runnable onDispose;

    GenericPopup(Window parent, RTextArea textArea, String windowTitle, Runnable onDispose) {
        super(parent);
        this.textArea = textArea;
        this.onDispose = onDispose;
        this.tipVisibleBounds = new Rectangle();
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(BorderFactory.createCompoundBorder(TipUtil.getToolTipBorder(), BorderFactory.createEmptyBorder(2, 5, 5, 5)));
        cp.setBackground(TipUtil.getToolTipBackground());
        this.setContentPane(cp);
        JLabel title = new JLabel(windowTitle);
        cp.add((Component)title, "North");
        this.list = new ChoiceList();
        JScrollPane sp = new JScrollPane(this.list);
        sp.setHorizontalScrollBarPolicy(31);
        cp.add(sp);
        this.installKeyBindings();
        this.listener = new Listener();
        this.setLocation();
        cp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GenericPopup.this.isInBounds = true;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                GenericPopup.this.isInBounds = true;
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size != null) {
            size.width = Math.min(size.width, 300);
            size.width = Math.max(size.width, 200);
        }
        return size;
    }

    private void performSelectedItem() {
        Object lvp = this.list.getSelectedValue();
        this.performOnSelectedItem(lvp);
    }

    private void performOnSelectedItem(Object lvp) {
        if (lvp != null) {
            this.listener.uninstallAndHide();
            IPopupAction text = ((LabelValuePair)lvp).action;
            text.getAction().run();
        }
    }

    private void installKeyBindings() {
        InputMap im = this.getRootPane().getInputMap(1);
        ActionMap am = this.getRootPane().getActionMap();
        KeyStroke escapeKS = KeyStroke.getKeyStroke(27, 0);
        im.put(escapeKS, "onEscape");
        am.put("onEscape", new EscapeAction());
        this.list.getInputMap().remove(escapeKS);
        this.list.getActionMap().put("copy", (Action)RTextArea.getAction((int)0));
        this.list.getActionMap().put("cut", (Action)RTextArea.getAction((int)1));
        this.list.getActionMap().put("paste", (Action)RTextArea.getAction((int)3));
    }

    public void setContents(List<IPopupAction> contents) {
        this.list.setContents(contents);
        this.pack();
    }

    private void setLocation() {
        Rectangle r = null;
        try {
            r = this.textArea.getMousePosition() == null ? this.textArea.modelToView(this.textArea.getCaretPosition()) : this.textArea.modelToView(this.textArea.viewToModel(this.textArea.getMousePosition()));
        }
        catch (Exception e) {
            LOGGER.error("Couldn't set popup location", (Throwable)e);
            return;
        }
        Point p = r.getLocation();
        SwingUtilities.convertPointToScreen(p, (Component)this.textArea);
        r.x = p.x;
        r.y = p.y;
        Rectangle screenBounds = TipUtil.getScreenBoundsForPoint((int)r.x, (int)r.y);
        int totalH = this.getHeight();
        int y = r.y + r.height + VERTICAL_SPACE;
        if (y + totalH > screenBounds.height) {
            y = r.y - VERTICAL_SPACE - this.getHeight();
        }
        int x = r.x;
        if (!this.textArea.getComponentOrientation().isLeftToRight()) {
            x -= this.getWidth();
        }
        if (x < screenBounds.x) {
            x = screenBounds.x;
        } else if (x + this.getWidth() > screenBounds.x + screenBounds.width) {
            x = screenBounds.x + screenBounds.width - this.getWidth();
        }
        this.setLocation(x, y);
        this.tipVisibleBounds.setBounds(r.x, r.y - 15, r.width, r.height + 30);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.list.getModel().getSize() == 0) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)this.textArea);
            return;
        }
        super.setVisible(visible);
        this.updateTextAreaCaret(visible);
        if (visible) {
            SwingUtilities.invokeLater(() -> {
                this.requestFocus();
                if (this.list.getModel().getSize() > 0) {
                    this.list.setSelectedIndex(0);
                }
                this.list.requestFocusInWindow();
            });
        }
    }

    private void updateTextAreaCaret(boolean visible) {
        Caret caret = this.textArea.getCaret();
        if (caret instanceof ConfigurableCaret) {
            ConfigurableCaret cc = (ConfigurableCaret)caret;
            if (visible) {
                this.prevCaretAlwaysVisible = cc.isAlwaysVisible();
                cc.setAlwaysVisible(true);
            } else {
                cc.setAlwaysVisible(this.prevCaretAlwaysVisible);
            }
        }
    }

    public void addKeyboardReleaseListener(KeyListener kl) {
        this.list.addKeyListener(kl);
    }

    public Rectangle getTipVisibleBounds() {
        return this.tipVisibleBounds;
    }

    public boolean isInBounds() {
        return this.isInBounds;
    }

    public void setInBounds(boolean isInBounds) {
        this.isInBounds = isInBounds;
    }

    private static final class ChoiceList
    extends JList {
        private ChoiceList() {
            super(new DefaultListModel());
            this.setSelectionMode(0);
            this.installKeyboardActions();
            this.installMouseListener();
        }

        private void installMouseListener() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    ((ChoiceList)e.getSource()).setCursor(new Cursor(0));
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ((ChoiceList)e.getSource()).setCursor(new Cursor(12));
                }
            });
        }

        private void installKeyboardActions() {
            InputMap im = this.getInputMap();
            ActionMap am = this.getActionMap();
            im.put(KeyStroke.getKeyStroke(40, 0), "onDown");
            am.put("onDown", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = (this.getSelectedIndex() + 1) % this.getModel().getSize();
                    this.ensureIndexIsVisible(index);
                    this.setSelectedIndex(index);
                }
            });
            im.put(KeyStroke.getKeyStroke(38, 0), "onUp");
            am.put("onUp", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = this.getSelectedIndex() - 1;
                    if (index < 0) {
                        index += this.getModel().getSize();
                    }
                    this.ensureIndexIsVisible(index);
                    this.setSelectedIndex(index);
                }
            });
        }

        private void setContents(List<IPopupAction> contents) {
            DefaultListModel model = (DefaultListModel)this.getModel();
            model.clear();
            for (IPopupAction str : contents) {
                model.addElement(new LabelValuePair(str));
            }
            this.setVisibleRowCount(Math.min(model.getSize(), 8));
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GenericPopup.this.listener.uninstallAndHide();
        }
    }

    private static class LabelValuePair {
        private String label;
        private final IPopupAction action;
        private static final int LABEL_MAX_LENGTH = 50;

        LabelValuePair(IPopupAction value) {
            this.label = value.getName();
            this.action = value;
            int newline = this.label.indexOf(10);
            boolean multiLine = false;
            if (newline > -1) {
                this.label = this.label.substring(0, newline);
                multiLine = true;
            }
            if (this.label.length() > 50) {
                this.label = String.valueOf(this.label.substring(0, 50)) + "...";
            } else if (multiLine) {
                int toRemove = 3 - (50 - this.label.length());
                if (toRemove > 0) {
                    this.label = this.label.substring(0, this.label.length() - toRemove);
                }
                this.label = String.valueOf(this.label) + "...";
            }
        }

        public String toString() {
            return this.label;
        }
    }

    private class Listener
    extends WindowAdapter
    implements ComponentListener {
        Listener() {
            GenericPopup.this.addWindowFocusListener(this);
            GenericPopup.this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int index = GenericPopup.this.list.locationToIndex(e.getPoint());
                    if (index > -1) {
                        GenericPopup.this.performOnSelectedItem(GenericPopup.this.list.getModel().getElementAt(index));
                        e.consume();
                    }
                }
            });
            GenericPopup.this.list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "onEnter");
            GenericPopup.this.list.getActionMap().put("onEnter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenericPopup.this.performSelectedItem();
                }
            });
            Window parent = (Window)GenericPopup.this.getParent();
            parent.addWindowFocusListener(this);
            parent.addWindowListener(this);
            parent.addComponentListener(this);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.uninstallAndHide();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.uninstallAndHide();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.uninstallAndHide();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.uninstallAndHide();
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.checkForParentWindowEvent(e);
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            if (e.getSource() == GenericPopup.this) {
                this.uninstallAndHide();
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.checkForParentWindowEvent(e);
        }

        private boolean checkForParentWindowEvent(WindowEvent e) {
            if (e.getSource() == GenericPopup.this.getParent()) {
                this.uninstallAndHide();
                return true;
            }
            return false;
        }

        private void uninstallAndHide() {
            Window parent = (Window)GenericPopup.this.getParent();
            parent.removeWindowFocusListener(this);
            parent.removeWindowListener(this);
            parent.removeComponentListener(this);
            GenericPopup.this.removeWindowFocusListener(this);
            if (GenericPopup.this.onDispose != null) {
                GenericPopup.this.onDispose.run();
            } else {
                GenericPopup.this.setVisible(false);
                GenericPopup.this.dispose();
            }
        }
    }
}

