/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.algorithm.jgit.HistogramDiff;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import com.sigge.filerunner.view.rsyntaxtextarea.ILineDetectionChangeTracker;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLineDetectionChangeTracker
implements ILineDetectionChangeTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLineDetectionChangeTracker.class);

    @Override
    public Tuple<Integer, Integer> getPositionAfterChange(char[] before, char[] after, Tuple<Integer, Integer> currentLineAndPosition) {
        if (before == null) {
            throw new IllegalArgumentException("Before cannot be null");
        }
        if (after == null) {
            throw new IllegalArgumentException("After cannot be null");
        }
        if (currentLineAndPosition == null) {
            throw new IllegalArgumentException("lineAndLinePosition cannot be null");
        }
        List<SegmentedChars> beforeList = this.getSegmentedChars(before);
        List<SegmentedChars> afterList = this.getSegmentedChars(after);
        try {
            Patch results = DiffUtils.diff(beforeList, afterList, (DiffAlgorithmI)new HistogramDiff(), null);
            int line = (Integer)currentLineAndPosition.first();
            if (results.getDeltas().size() == 0) {
                return currentLineAndPosition;
            }
            int lineDelta = 0;
            boolean colDelta = false;
            for (AbstractDelta delta : results.getDeltas()) {
                Chunk source = delta.getSource();
                Chunk target = delta.getTarget();
                if (source.getPosition() > line) break;
                if (source.getPosition() + source.size() - 1 < line) {
                    lineDelta += target.size() - source.size();
                    continue;
                }
                Patch p = new Patch();
                Chunk<String> sSource = DefaultLineDetectionChangeTracker.toStringChunk((Chunk<SegmentedChars>)source);
                Chunk<String> sTarget = DefaultLineDetectionChangeTracker.toStringChunk((Chunk<SegmentedChars>)target);
                ChangeDelta deltaForce = null;
                switch (delta.getType()) {
                    case CHANGE: {
                        deltaForce = new ChangeDelta(sSource, sTarget);
                        break;
                    }
                    case DELETE: {
                        deltaForce = new DeleteDelta(sSource, sTarget);
                        break;
                    }
                    case INSERT: {
                        deltaForce = new InsertDelta(sSource, sTarget);
                        break;
                    }
                    case EQUAL: {
                        break;
                    }
                }
                p.addDelta(deltaForce);
                String lineToFind = (String)sSource.getLines().get(line - source.getPosition());
                List sss = DiffRowGenerator.create().showInlineDiffs(true).mergeOriginalRevised(true).reportLinesUnchanged(true).ignoreWhiteSpaces(false).build().generateDiffRows(sSource.getLines(), p);
                int i = this.findDiffRowWithOldLine(sss, lineToFind);
                if (i >= target.size()) {
                    i = target.size() - (i + 1);
                }
                lineDelta += i;
            }
            return new Tuple((Object)((Integer)currentLineAndPosition.first() + lineDelta), (Object)((Integer)currentLineAndPosition.second()));
        }
        catch (DiffException e) {
            LOGGER.error("Diffing failed due to", (Throwable)e);
            return null;
        }
    }

    private int findDiffRowWithOldLine(List<DiffRow> rows, String oldLine) {
        int i = 0;
        while (i < rows.size()) {
            DiffRow diff = rows.get(i);
            if (oldLine.equals(diff.getOldLine())) {
                return i;
            }
            if (diff.getOldLine().replaceAll("<span class=\"editOldInline\">(?<capture1>.*?)</span>", "${capture1}").replaceAll("<span class=\"editNewInline\">.*?</span>", "").equals(oldLine)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static Chunk<String> toStringChunk(Chunk<SegmentedChars> source) {
        return new Chunk(0, source.getLines().stream().map(l -> l.convertToString()).collect(Collectors.toList()));
    }

    private List<SegmentedChars> getSegmentedChars(char[] s) {
        ArrayList<SegmentedChars> l = new ArrayList<SegmentedChars>();
        int prevStart = 0;
        boolean prevWasR = false;
        int i = 0;
        while (i < s.length) {
            int codepoint = Character.codePointAt(s, i, s.length);
            int charCount = Character.charCount(codepoint);
            if (codepoint == 13) {
                prevWasR = true;
            } else if (codepoint == 10 || prevWasR) {
                l.add(new SegmentedChars(s, prevStart, prevWasR ? i - 2 : i - 1));
                prevStart = i + charCount;
                prevWasR = false;
            }
            i += charCount;
        }
        if (prevStart < s.length - 1) {
            l.add(new SegmentedChars(s, prevStart, s.length - 1));
        }
        return l;
    }

    class SegmentedChars {
        private final char[] array;
        private final int begin;
        private final int end;

        SegmentedChars(char[] array, int begin, int end) {
            this.array = array;
            this.begin = begin;
            this.end = end;
        }

        public String convertToString() {
            return this.end < this.begin ? "" : new String(this.array, this.begin, this.end - this.begin + 1);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.array);
            return result;
        }

        public String toString() {
            if (this.end < this.begin) {
                return "SegmentedChars[]";
            }
            return "SegmentedChars[" + this.convertToString() + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SegmentedChars)) {
                return false;
            }
            SegmentedChars other = (SegmentedChars)obj;
            if (this.end - this.begin != other.end - other.begin) {
                return false;
            }
            if (this.end < this.begin && other.end < other.begin) {
                return true;
            }
            int i = 0;
            while (i <= this.end - this.begin) {
                if (this.array[i + this.begin] != other.array[i + other.begin]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

