/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.simple;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphParameterUtils;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.GraphSettingValue;
import com.sigge.filerunner.view.results.graph.GraphType;
import com.sigge.filerunner.view.results.graph.GraphUtils;
import com.sigge.filerunner.view.results.graph.GraphView;
import com.sigge.filerunner.view.results.graph.IGraphHandler;
import com.sigge.filerunner.view.results.graph.IGraphSetting;
import com.sigge.filerunner.view.results.graph.ResultSetTableXYWrapper;
import com.sigge.filerunner.view.results.graph.simple.GraphManager;
import com.sigge.filerunner.view.results.graph.simple.ISimpleGraphSetting;
import com.sigge.filerunner.view.results.graph.simple.SimpleGraphSetting;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ChangeListener;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.MapBuilder;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.TableOrder;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;

public class SimpleGraphHandler
implements IGraphHandler {
    private static final String SIMPLE_GRAPH_SHOW_LEGEND = "simpleGraph.showLegend";
    private static final String GRAPH_SHOW_FILTERED = "graph.showFiltered";
    private static final int MAX_LEGENDS = 200;
    private static final Color GRIDLINES = Color.GRAY;
    static final String XAXIS = "XAXIS";
    static final String YAXIS = "YAXIS";
    static final String IDENTIFIER = "IDENTIFIER";
    public static final String COLUMN_TYPE = "COLUMN";
    public static final String ID = "ID";
    public static final String LABEL = "LABEL";
    private static final GraphManager STORER = new GraphManager();

    @Override
    public void present(GraphView view, GraphType graphType, List<GraphResult> results, GraphResult resultSetChosen, boolean draw) {
        Optional<ISimpleGraphSetting> prev;
        JPanel container = view.getSettingsPane();
        container.removeAll();
        view.getGraphpanel().removeAll();
        List<TextListItem<Integer>> columns = this.getColumns(resultSetChosen.getResultSet());
        Binder.Presenter<TextListItem<Integer>> x = ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.RING}) ? Binder.defaultValue(IGraphSetting.EMPTY_VALUE) : GraphParameterUtils.addColumnCombo(container, "x-axis", columns, ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.PIE, GraphType.BAR, GraphType.STACKED, GraphType.STACKEDAREA}));
        Binder.Presenter<TextListItem<Integer>> y = GraphParameterUtils.addColumnCombo(container, "y-axis", columns, false);
        Binder.Presenter<TextListItem<Integer>> identifier = GraphParameterUtils.addColumnCombo(container, "Identifier", columns, ListUtils.in((Object)graphType, (Object[])new GraphType[]{GraphType.LINE, GraphType.POINTS}));
        JPanel buttons = new JPanel(new FlowLayout(0));
        JButton drawGraph = new JButton("Display graph", IconUtils.getSmallIcon("location.png"));
        JButton fullscreen = new JButton("Fullscreen", IconUtils.getSmallIcon("tv.png"));
        JCheckBox ch = new JCheckBox("Show legend");
        JCheckBox filtered = new JCheckBox("Show filtered");
        buttons.add(drawGraph);
        buttons.add(fullscreen);
        buttons.add(ch);
        container.add(buttons);
        GraphControl gc = new GraphControl(ch, filtered, ConfigHandler.getConfig().getBooleanConfigValue(SIMPLE_GRAPH_SHOW_LEGEND, true), ConfigHandler.getConfig().getBooleanConfigValue(GRAPH_SHOW_FILTERED, true));
        fullscreen.addActionListener(l -> {
            final JMemoryFrame jf = new JMemoryFrame("SimpleGraph", "SimpleGraph");
            JPanel gv = new JPanel();
            gv.setLayout(new BorderLayout());
            if (jf.isDefault()) {
                jf.setExtendedState(6);
            }
            jf.getContentPane().setLayout(new BorderLayout());
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                }
            });
            this.drawChartLineOrPoints(gv, resultSetChosen, (TextListItem)x.getValue(), (TextListItem)y.getValue(), (TextListItem)identifier.getValue(), graphType, gc);
            jf.getContentPane().add((Component)gv, "Center");
            jf.setVisible(true);
        });
        container.revalidate();
        Binder.Presenter<TextListItem<Integer>> zz = x;
        drawGraph.addActionListener(l -> SwingUtilities.invokeLater(() -> this.drawChartLineOrPoints(view.getGraphpanel(), resultSetChosen, (TextListItem)zz.getValue(), (TextListItem)y.getValue(), (TextListItem)identifier.getValue(), graphType, gc)));
        if (draw && (prev = STORER.loadPrevious(resultSetChosen, Optional.ofNullable(graphType))).isPresent()) {
            SimpleGraphSetting gs = (SimpleGraphSetting)prev.get();
            if (gs.getX().getValue() > -1) {
                ((JComboBox)x.getBound()).setSelectedItem(gs.getX());
            }
            if (gs.getY().getValue() > -1) {
                ((JComboBox)y.getBound()).setSelectedItem(gs.getY());
            }
            if (gs.getIdentifier().getValue() > -1) {
                ((JComboBox)identifier.getBound()).setSelectedItem(gs.getIdentifier());
            }
        }
        ChangeListener cl = () -> {
            if (this.okToGraph(resultSetChosen)) {
                SwingUtilities.invokeLater(() -> this.drawChartLineOrPoints(view.getGraphpanel(), resultSetChosen, (TextListItem)zz.getValue(), (TextListItem)y.getValue(), (TextListItem)identifier.getValue(), graphType, gc));
            }
        };
        if (x != null) {
            x.getModel().addModelChangeListener(cl);
        }
        y.getModel().addModelChangeListener(cl);
        identifier.getModel().addModelChangeListener(cl);
        filtered.addActionListener(e -> {
            gc.setToggleFilter();
            cl.changed();
        });
        if (draw && this.isValid(resultSetChosen, graphType, (TextListItem)zz.getValue(), (TextListItem)y.getValue(), (TextListItem)x.getValue()) && this.okToGraph(resultSetChosen)) {
            SwingUtilities.invokeLater(() -> this.drawChartLineOrPoints(view.getGraphpanel(), resultSetChosen, (TextListItem)zz.getValue(), (TextListItem)y.getValue(), (TextListItem)identifier.getValue(), graphType, gc));
        }
    }

    public static List<TextListItem<Integer>> getItemFromValue(GraphSettingValue v) {
        if (v == null) {
            return Collections.EMPTY_LIST;
        }
        List<Map<String, Object>> m = v.getValues();
        if (m.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<TextListItem<Integer>> l = new ArrayList<TextListItem<Integer>>();
        for (Map<String, Object> map : m) {
            String label = (String)map.get(LABEL);
            Integer id = ((Number)map.get(ID)).intValue();
            l.add(new TextListItem<Integer>(id, label));
        }
        return l;
    }

    public static GraphSettingValue getValueFromColumn(String name, TextListItem<Integer> column) {
        return SimpleGraphHandler.getValueFromColumn(name, Arrays.asList(column));
    }

    public static GraphSettingValue getValueFromColumn(String name, List<TextListItem<Integer>> columns) {
        GraphSettingValue value = new GraphSettingValue();
        value.setType(COLUMN_TYPE);
        value.setName(name);
        ArrayList<Map<String, Object>> lm = new ArrayList<Map<String, Object>>();
        for (TextListItem<Integer> column : columns) {
            MapBuilder m = new MapBuilder();
            m.append((Object)ID, (Object)column.getValue()).append((Object)LABEL, (Object)column.getLabel()).build();
            lm.add(m.build());
        }
        value.setValues(lm);
        return value;
    }

    private static boolean isNumber(IResultSetTable resultSet, TextListItem<Integer> col) {
        int col1 = col.getValue();
        if (col1 == -1) {
            return false;
        }
        GraphHandler.VALUE_TYPE xType = GraphHandler.VALUE_TYPE.getFromType(resultSet.getFieldType(col1));
        return xType == GraphHandler.VALUE_TYPE.NUMBER;
    }

    private static boolean isDate(IResultSetTable resultSet, TextListItem<Integer> col) {
        int col1 = col.getValue();
        if (col1 == -1) {
            return false;
        }
        GraphHandler.VALUE_TYPE xType = GraphHandler.VALUE_TYPE.getFromType(resultSet.getFieldType(col1));
        return xType == GraphHandler.VALUE_TYPE.DATE;
    }

    private boolean isValid(GraphResult resultSetChosen, GraphType gt, TextListItem<Integer> xName, TextListItem<Integer> yName, TextListItem<Integer> zName) {
        IResultSetTable resultSet = resultSetChosen.getResultSet();
        if (gt == null) {
            return false;
        }
        if (yName.getValue() == -1) {
            return false;
        }
        if (!SimpleGraphHandler.isNumber(resultSet, yName) && !SimpleGraphHandler.isDate(resultSet, yName)) {
            return false;
        }
        return xName.getValue() == -1 || SimpleGraphHandler.isNumber(resultSet, xName) || SimpleGraphHandler.isDate(resultSet, xName);
    }

    private void drawChartLineOrPoints(JPanel graphpanel, GraphResult res, TextListItem<Integer> xName, TextListItem<Integer> yName, TextListItem<Integer> zName, GraphType type, GraphControl control) {
        graphpanel.removeAll();
        graphpanel.revalidate();
        graphpanel.repaint();
        IResultSetTable resultSet = res.getResultSet();
        ValueHolder CHART_CONSUMER = new ValueHolder();
        if (this.isXYTypeOfGraph(type)) {
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(type == GraphType.LINE, true);
            ResultSetTableXYWrapper xy = this.createWrapperFromSettings(xName, yName, zName, resultSet);
            if (!ListUtils.in((Object)((Object)xy.getxType()), (Object[])new GraphHandler.VALUE_TYPE[]{GraphHandler.VALUE_TYPE.NUMBER, GraphHandler.VALUE_TYPE.DATE}) || !ListUtils.in((Object)((Object)xy.getyType()), (Object[])new GraphHandler.VALUE_TYPE[]{GraphHandler.VALUE_TYPE.NUMBER, GraphHandler.VALUE_TYPE.DATE})) {
                this.displayError(graphpanel, "X-axis & y-axis must be a number or a date");
                return;
            }
            if (xy.getxType() == GraphHandler.VALUE_TYPE.NUMBER) {
                this.executeGraphInBackground(() -> ChartFactory.createScatterPlot(null, (String)xName.getLabel(), (String)yName.getLabel(), (XYDataset)xy), CHART_CONSUMER);
                if (CHART_CONSUMER.getValue() == null) {
                    this.displayError(graphpanel, "Error while drawing");
                    return;
                }
                renderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
            } else if (xy.getxType() == GraphHandler.VALUE_TYPE.DATE) {
                this.executeGraphInBackground(() -> ChartFactory.createTimeSeriesChart(null, (String)xName.getLabel(), (String)yName.getLabel(), (XYDataset)xy), CHART_CONSUMER);
                if (CHART_CONSUMER.getValue() == null) {
                    return;
                }
                renderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)GraphUtils.DEFAULT_DATE_FORMAT, (DateFormat)GraphUtils.DEFAULT_DATE_FORMAT));
            }
            ((JFreeChart)CHART_CONSUMER.getValue()).getXYPlot().setRenderer((XYItemRenderer)renderer);
        } else {
            if (zName.getValue() == -1) {
                this.displayError(graphpanel, "Identifier value must be selected");
                return;
            }
            if (yName.getValue() != -1 && GraphHandler.VALUE_TYPE.getFromType(resultSet.getFieldType(yName.getValue())) != GraphHandler.VALUE_TYPE.NUMBER) {
                this.displayError(graphpanel, "Y-value must be a number");
                return;
            }
            if (type == GraphType.BAR) {
                this.executeGraphInBackground(() -> ChartFactory.createBarChart(null, (String)xName.getLabel(), (String)yName.getLabel(), (CategoryDataset)ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue())), CHART_CONSUMER);
            } else if (type == GraphType.AREA) {
                this.executeGraphInBackground(() -> ChartFactory.createAreaChart(null, (String)xName.getLabel(), (String)yName.getLabel(), (CategoryDataset)ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue())), CHART_CONSUMER);
            } else if (type == GraphType.STACKEDAREA) {
                this.executeGraphInBackground(() -> ChartFactory.createStackedAreaChart(null, (String)xName.getLabel(), (String)yName.getLabel(), (CategoryDataset)ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue())), CHART_CONSUMER);
            } else if (type == GraphType.STACKED) {
                this.executeGraphInBackground(() -> ChartFactory.createStackedBarChart(null, (String)xName.getLabel(), (String)yName.getLabel(), (CategoryDataset)ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue())), CHART_CONSUMER);
            } else if (type == GraphType.PIE) {
                if (xName.getValue() == -1) {
                    this.executeGraphInBackground(() -> ChartFactory.createPieChart(null, (PieDataset)new CategoryToPieDataset(ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue()), TableOrder.BY_ROW, 0)), CHART_CONSUMER);
                } else {
                    this.executeGraphInBackground(() -> ChartFactory.createMultiplePieChart(null, (CategoryDataset)ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue()), (TableOrder)TableOrder.BY_ROW, (boolean)true, (boolean)true, (boolean)false), CHART_CONSUMER);
                }
            } else if (type == GraphType.RING) {
                this.executeGraphInBackground(() -> ChartFactory.createRingChart(null, (PieDataset)new CategoryToPieDataset(ResultSetTableXYWrapper.createDataset(resultSet, (Integer)xName.getValue(), (Integer)yName.getValue(), (Integer)zName.getValue()), TableOrder.BY_ROW, 0), (boolean)true, (boolean)true, (boolean)false), CHART_CONSUMER);
            }
        }
        if (CHART_CONSUMER.getValue() == null) {
            graphpanel.revalidate();
            return;
        }
        JFreeChart x = (JFreeChart)CHART_CONSUMER.getValue();
        Plot p = x.getPlot();
        p.setBackgroundPaint((Paint)Color.WHITE);
        LegendItemCollection coll = p.getLegendItems();
        ArrayList<LegendItem> items = new ArrayList<LegendItem>();
        boolean d = true;
        int ix = 0;
        while (ix < Math.min(200, coll.getItemCount())) {
            LegendItem e = coll.get(ix);
            try {
                this.getDoubleFromString(e);
            }
            catch (Exception ex) {
                d = false;
            }
            if ("-".equals(e.getLabel())) {
                e = new LegendItem("-", "-".equals(e.getDescription()) ? "-" : e.getDescription(), "-".equals(e.getToolTipText()) ? "-" : e.getToolTipText(), e.getURLText(), e.getShape(), e.getFillPaint(), e.getOutlineStroke(), e.getOutlinePaint());
            }
            items.add(e);
            ++ix;
        }
        if (d) {
            Collections.sort(items, Comparator.comparing(this::getDoubleFromString));
        } else {
            Collections.sort(items, Comparator.comparing(this::getFromString));
        }
        if (coll.getItemCount() >= 200) {
            items.add(new LegendItem("..."));
        }
        LegendItemCollection lex = new LegendItemCollection();
        items.forEach(arg_0 -> ((LegendItemCollection)lex).add(arg_0));
        if (p instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)p;
            xyPlot.setDomainGridlinePaint((Paint)GRIDLINES);
            xyPlot.setRangeGridlinePaint((Paint)GRIDLINES);
            xyPlot.setFixedLegendItems(lex);
        } else if (p instanceof CategoryPlot) {
            CategoryPlot cp = (CategoryPlot)p;
            cp.setDomainGridlinePaint((Paint)GRIDLINES);
            cp.setRangeGridlinePaint((Paint)GRIDLINES);
            cp.setFixedLegendItems(lex);
        }
        ISimpleGraphSetting gs = this.createGraphSetting(xName, yName, zName, type, res);
        STORER.store(gs);
        x.getLegend().setVisible(control.initialLegend);
        control.setToggleVisibility(() -> x.getLegend().setVisible(!x.getLegend().isVisible()));
        ChartPanel panel = new ChartPanel(x, true);
        JScrollPane js = new JScrollPane((Component)panel);
        panel.setPreferredSize(new Dimension(100, 200));
        js.setPreferredSize(new Dimension(300, 400));
        graphpanel.add((Component)js, "Center");
        graphpanel.revalidate();
    }

    private ISimpleGraphSetting createGraphSetting(TextListItem<Integer> xName, TextListItem<Integer> yName, TextListItem<Integer> zName, GraphType type, GraphResult res) {
        SimpleGraphSetting gs = new SimpleGraphSetting();
        gs.setResultSet(res);
        gs.setGraphType(type);
        if (xName.getValue() != -1) {
            gs.setX(xName);
        }
        if (yName.getValue() != -1) {
            gs.setY(yName);
        }
        if (zName.getValue() != -1) {
            gs.setIdentifier(zName);
        }
        return gs;
    }

    private <T> void executeGraphInBackground(ThrowingSupplier<T> supplier, ThrowingConsumer<T> consumer) {
        UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(supplier, consumer).title("Generating graph", "The graph is being generated", "Cancel generation")).build()));
    }

    private Double getDoubleFromString(LegendItem s) {
        String legend = s.getLabel();
        return Double.valueOf(legend);
    }

    private String getFromString(LegendItem s) {
        return s.getLabel().toLowerCase();
    }

    private ResultSetTableXYWrapper createWrapperFromSettings(TextListItem<Integer> xName, TextListItem<Integer> yName, TextListItem<Integer> zName, IResultSetTable resultSet) {
        ResultSetTableXYWrapper xy = null;
        xy = zName.getValue() == -1 ? new ResultSetTableXYWrapper(resultSet, xName.getValue(), yName.getValue()) : new ResultSetTableXYWrapper(resultSet, xName.getValue(), yName.getValue(), zName.getValue());
        return xy;
    }

    private boolean isXYTypeOfGraph(GraphType type) {
        return ListUtils.in((Object)type, (Object[])new GraphType[]{GraphType.LINE, GraphType.POINTS});
    }

    @Override
    public void close() throws IOException {
    }

    private class GraphControl {
        private final JCheckBox legend;
        private final boolean initialLegend;
        private boolean actualLegend;
        private final JCheckBox filtered;
        private final boolean initialFilter;
        private boolean actualFilter;

        GraphControl(JCheckBox showLegend, JCheckBox filtered, boolean initialValue, boolean initialFilter) {
            this.legend = showLegend;
            this.filtered = filtered;
            this.actualLegend = this.initialLegend = initialValue;
            this.actualFilter = this.initialFilter = initialFilter;
            showLegend.setSelected(initialValue);
            filtered.setSelected(initialFilter);
        }

        private void setToggleVisibility(Runnable r) {
            this.actualLegend = !this.actualLegend;
            this.legend.addActionListener(a -> {
                r.run();
                ConfigHandler.getConfig().setConfigValue(SimpleGraphHandler.SIMPLE_GRAPH_SHOW_LEGEND, this.actualLegend);
            });
        }

        private void setToggleFilter() {
            this.actualFilter = !this.actualFilter;
            this.filtered.addActionListener(a -> ConfigHandler.getConfig().setConfigValue(SimpleGraphHandler.GRAPH_SHOW_FILTERED, this.actualFilter));
        }
    }
}

