/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.microsoft.sqlserver.jdbc.Geometry;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.graph.ColorPalette;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.PaletteManager;
import com.sigge.filerunner.view.results.graph.geo.ColorUtils;
import com.sigge.filerunner.view.results.graph.geo.FixedColorPalette;
import com.sigge.filerunner.view.results.graph.geo.FromToWaypoint;
import com.sigge.filerunner.view.results.graph.geo.GeoDisplaySettings;
import com.sigge.filerunner.view.results.graph.geo.GeoWaypoint;
import com.sigge.filerunner.view.results.graph.geo.IGeoManager;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.sigge.filerunner.view.results.graph.geo.options.AGeoHandler;
import com.sigge.filerunner.view.results.graph.geo.options.AGeoWaypointModel;
import com.sigge.filerunner.view.results.graph.geo.options.FromToGeo;
import com.sigge.filerunner.view.results.graph.geo.options.FromToGeoView;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoTypeHandler;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import java.awt.Color;
import java.awt.Container;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.RowSorter;
import org.geotools.geometry.jts.WKTReader2;
import org.jxmapviewer.viewer.Waypoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class TripHandler
extends AGeoHandler
implements IGeoTypeHandler<IGeoSetting> {
    @Override
    public IGeoSetting create(IGeoManager manager, Container container, List<GraphResult> results, GraphResult lastResult, Optional<IGeoSetting> geo, Runnable listener, String id) {
        return this.createInner(manager, null, geo, container, results, lastResult, listener);
    }

    private FromToGeo createInner(IGeoManager manager, FromToGeoView prevView, Optional<IGeoSetting> optgeo, Container container, final List<GraphResult> results, GraphResult lastResult, final Runnable listener) {
        if (prevView != null) {
            container.remove(prevView);
        }
        WaypointModel model = new WaypointModel();
        FromToGeo geo = optgeo.orElse(null);
        if (geo == null) {
            geo = new FromToGeo();
            geo.setType(GeoType.TRIP);
        }
        FromToGeoView view = new FromToGeoView();
        container.add(view);
        List<TextListItem<Integer>> columnsEmpty = this.getColumns(lastResult.getResultSet(), true, new GraphHandler.VALUE_TYPE[0]);
        final List<TextListItem<Integer>> columnsNumbers = this.getColumns(lastResult.getResultSet(), false, GraphHandler.VALUE_TYPE.NUMBER);
        final List<TextListItem<Integer>> columnsGeos = this.getColumns(lastResult.getResultSet(), false, GraphHandler.VALUE_TYPE.GEO);
        final List<TextListItem<Integer>> labels = columnsEmpty;
        final AtomicBoolean suspend = new AtomicBoolean(true);
        APresenter<FromToGeo, WaypointModel, FromToGeoView> presenter = new APresenter<FromToGeo, WaypointModel, FromToGeoView>(model, view){

            protected void initBindings() {
                this.bind(((FromToGeoView)this.view).resultsCombo).to(results, ((WaypointModel)this.model).resultSet);
                this.bind(((FromToGeoView)this.view).latitudeCombo).to(columnsNumbers, ((WaypointModel)this.model).latitude);
                this.bind(((FromToGeoView)this.view).longitudeCombo).to(columnsNumbers, ((WaypointModel)this.model).longitude);
                this.bind(((FromToGeoView)this.view).geometryCombo).to(columnsGeos, ((WaypointModel)this.model).geometry);
                ((FromToGeoView)this.view).latitudeCombo.setEnabled(columnsNumbers.size() > 1);
                ((FromToGeoView)this.view).longitudeCombo.setEnabled(columnsNumbers.size() > 1);
                ((FromToGeoView)this.view).latLonRadio.setEnabled(columnsNumbers.size() > 1);
                ((FromToGeoView)this.view).geometryCombo.setEnabled(columnsGeos.size() > 1);
                ((FromToGeoView)this.view).geoRadio.setEnabled(columnsGeos.size() > 0 && (Integer)((TextListItem)columnsGeos.get(0)).getValue() != -1);
                this.bind(((FromToGeoView)this.view).labelCombo).to(labels, ((WaypointModel)this.model).labelToDisplay);
                this.bind(((FromToGeoView)this.view).labelComboAlt).to(labels, ((WaypointModel)this.model).labelToDisplay);
                TripHandler.this.adjustCombo(((FromToGeoView)this.view).latitudeCombo, ((FromToGeoView)this.view).longitudeCombo, ((FromToGeoView)this.view).labelCombo, ((FromToGeoView)this.view).labelComboAlt, ((FromToGeoView)this.view).geometryCombo, ((FromToGeoView)this.view).resultsCombo);
                this.bind(((FromToGeoView)this.view).displayStyleCombo).to(Arrays.asList(PointVisualizer.values()), ((WaypointModel)this.model).pointIcon);
                ((FromToGeoView)this.view).geoRadio.addActionListener(l -> {
                    if (((Boolean)((WaypointModel)this.model).latLonChosen.getValue()).booleanValue()) {
                        ((FromToGeoView)this.view).changeGeoView();
                        ((WaypointModel)this.model).latLonChosen.setValue((Object)false);
                        ((FromToGeoView)this.view).labelComboAlt.setSelectedItem(((FromToGeoView)this.view).labelCombo.getSelectedItem());
                    }
                });
                ((FromToGeoView)this.view).latLonRadio.addActionListener(l -> {
                    if (!((Boolean)((WaypointModel)this.model).latLonChosen.getValue()).booleanValue()) {
                        ((FromToGeoView)this.view).changeGeoView();
                        ((WaypointModel)this.model).latLonChosen.setValue((Object)true);
                        ((FromToGeoView)this.view).labelCombo.setSelectedItem(((FromToGeoView)this.view).labelComboAlt.getSelectedItem());
                    }
                });
                this.bind(((FromToGeoView)this.view).latitudeCombo1).to(columnsNumbers, ((WaypointModel)this.model).latitudeTo);
                this.bind(((FromToGeoView)this.view).longitudeCombo1).to(columnsNumbers, ((WaypointModel)this.model).longitudeTo);
                this.bind(((FromToGeoView)this.view).geometryCombo1).to(columnsGeos, ((WaypointModel)this.model).geometryTo);
                ((FromToGeoView)this.view).latitudeCombo1.setEnabled(columnsNumbers.size() > 1);
                ((FromToGeoView)this.view).longitudeCombo1.setEnabled(columnsNumbers.size() > 1);
                ((FromToGeoView)this.view).latLonRadio1.setEnabled(columnsNumbers.size() > 1);
                ((FromToGeoView)this.view).geometryCombo1.setEnabled(columnsGeos.size() > 1);
                ((FromToGeoView)this.view).geoRadio1.setEnabled(columnsGeos.size() > 0 && (Integer)((TextListItem)columnsGeos.get(0)).getValue() != -1);
                this.bind(((FromToGeoView)this.view).labelCombo1).to(labels, ((WaypointModel)this.model).labelToDisplayTo);
                this.bind(((FromToGeoView)this.view).labelComboAlt1).to(labels, ((WaypointModel)this.model).labelToDisplayTo);
                TripHandler.this.adjustCombo(((FromToGeoView)this.view).latitudeCombo1, ((FromToGeoView)this.view).longitudeCombo1, ((FromToGeoView)this.view).labelCombo1, ((FromToGeoView)this.view).labelComboAlt1, ((FromToGeoView)this.view).geometryCombo1);
                this.bind(((FromToGeoView)this.view).displayStyleCombo1).to(Arrays.asList(PointVisualizer.values()), ((WaypointModel)this.model).pointIconTo);
                ((FromToGeoView)this.view).geoRadio1.addActionListener(l -> {
                    if (((Boolean)((WaypointModel)this.model).latLonChosenTo.getValue()).booleanValue()) {
                        ((FromToGeoView)this.view).changeGeoViewTo();
                        ((WaypointModel)this.model).latLonChosenTo.setValue((Object)false);
                        ((FromToGeoView)this.view).labelComboAlt1.setSelectedItem(((FromToGeoView)this.view).labelCombo1.getSelectedItem());
                    }
                });
                ((FromToGeoView)this.view).latLonRadio1.addActionListener(l -> {
                    if (!((Boolean)((WaypointModel)this.model).latLonChosenTo.getValue()).booleanValue()) {
                        ((FromToGeoView)this.view).changeGeoViewTo();
                        ((WaypointModel)this.model).latLonChosenTo.setValue((Object)true);
                        ((FromToGeoView)this.view).labelCombo1.setSelectedItem(((FromToGeoView)this.view).labelComboAlt1.getSelectedItem());
                    }
                });
                this.addListenersToProperties(() -> {
                    if (!suspend.get()) {
                        listener.run();
                    }
                }, new IProperty[]{((WaypointModel)this.model).geometry, ((WaypointModel)this.model).labelToDisplay, ((WaypointModel)this.model).latLonChosen, ((WaypointModel)this.model).latitude, ((WaypointModel)this.model).longitude, ((WaypointModel)this.model).pointIcon, ((WaypointModel)this.model).geometryTo, ((WaypointModel)this.model).labelToDisplayTo, ((WaypointModel)this.model).latLonChosenTo, ((WaypointModel)this.model).latitudeTo, ((WaypointModel)this.model).longitudeTo, ((WaypointModel)this.model).pointIconTo});
            }
        };
        presenter.setObject((Object)geo);
        this.init(model, lastResult, presenter, columnsNumbers, columnsGeos, labels, view, !optgeo.isPresent());
        suspend.set(false);
        view.resultsCombo.addActionListener(a -> {
            suspend.set(true);
            this.createInner(manager, view, manager.loadPrevious((GraphResult)fromToGeoView.resultsCombo.getSelectedItem(), Optional.of(GeoType.TRIP)), container, results, (GraphResult)fromToGeoView.resultsCombo.getSelectedItem(), listener);
        });
        return geo;
    }

    private void init(WaypointModel model, GraphResult result, APresenter<FromToGeo, WaypointModel, FromToGeoView> presenter, List<TextListItem<Integer>> numbers, List<TextListItem<Integer>> geo, List<TextListItem<Integer>> labels, FromToGeoView view, boolean init) {
        model.resultSet.setValue((Object)result);
        if (init) {
            model.latitude.setValue(numbers.get(0));
            model.longitude.setValue(numbers.get(0));
            model.geometry.setValue(geo.get(0));
            if (numbers.size() > 1) {
                model.longitude.setValue(numbers.get(1));
                model.latLonChosen.setValue((Object)true);
            }
            if (geo.get(0).getValue() != -1 && numbers.size() < 2) {
                model.latLonChosen.setValue((Object)false);
                view.changeGeoView();
                view.geoRadio.doClick();
            }
            if (labels.size() > 0) {
                model.labelToDisplay.setValue(labels.get(0));
            }
            model.latitudeTo.setValue(numbers.get(0));
            model.longitudeTo.setValue(numbers.get(0));
            model.geometryTo.setValue(geo.get(0));
            if (numbers.size() > 1) {
                model.longitudeTo.setValue(numbers.get(1));
                model.latLonChosenTo.setValue((Object)true);
            }
            if (geo.get(0).getValue() != -1 && numbers.size() < 2) {
                model.latLonChosenTo.setValue((Object)false);
                view.changeGeoViewTo();
                view.geoRadio1.doClick();
            }
            if (labels.size() > 0) {
                model.labelToDisplayTo.setValue(labels.get(0));
            }
            FromToGeo previous = (FromToGeo)((WaypointModel)presenter.getModel()).getObject();
            model.pointIcon.setValue((Object)(previous.getPointIcon() != null ? previous.getPointIcon() : PointVisualizer.DOT));
            model.pointIconTo.setValue((Object)(previous.getPointIconTo() != null ? previous.getPointIcon() : PointVisualizer.DOT));
        } else {
            if (((Boolean)model.latLonChosen.getValue()).booleanValue()) {
                if ((Integer)((TextListItem)model.geometry.getValue()).getValue() == -1) {
                    model.geometry.setValue(geo.get(0));
                }
            } else {
                if ((Integer)((TextListItem)model.latitude.getValue()).getValue() == -1) {
                    model.latitude.setValue(numbers.get(0));
                    model.longitude.setValue(numbers.get(numbers.size() > 1 ? 1 : 0));
                }
                view.changeGeoView();
                view.geoRadio.doClick();
            }
            if (((Boolean)model.latLonChosenTo.getValue()).booleanValue()) {
                if ((Integer)((TextListItem)model.geometryTo.getValue()).getValue() == -1) {
                    model.geometryTo.setValue(geo.get(0));
                }
            } else {
                if ((Integer)((TextListItem)model.latitudeTo.getValue()).getValue() == -1) {
                    model.latitudeTo.setValue(numbers.get(0));
                    model.longitudeTo.setValue(numbers.get(numbers.size() > 1 ? 1 : 0));
                }
                view.changeGeoViewTo();
                view.geoRadio1.doClick();
            }
        }
        presenter.setObject((Object)((FromToGeo)((WaypointModel)presenter.getModel()).getObject()));
    }

    @Override
    public WaypointHolder<Waypoint> generateWayPoints(IGeoSetting setting, GeoDisplaySettings displaySettings) {
        HashSet<FromToWaypoint> waypoints = new HashSet<FromToWaypoint>();
        FromToGeo geo = (FromToGeo)setting;
        IResultSetTable resultSet = setting.getChosenResultSet();
        ResultSetTableModel tm = (ResultSetTableModel)resultSet;
        RowSorter rs = tm.getSorter();
        GeoWaypoint wp1 = null;
        HashMap<Object, Color> colorMap = new HashMap<Object, Color>();
        AtomicInteger ai = new AtomicInteger(0);
        ColorPalette cp = new FixedColorPalette(ColorUtils.COLOR_PALETTE5, Color.GREEN);
        int rowCount = this.getCountFromResultSet(resultSet, displaySettings.isFiltered());
        int identifier = geo.getLabelToDisplay().getValue();
        int lat = geo.getLatitude().getValue();
        int lon = geo.getLongitude().getValue();
        int geom = geo.getGeometry().getValue();
        int latTo = geo.getLatitudeTo().getValue();
        int lonTo = geo.getLongitudeTo().getValue();
        int geomTo = geo.getGeometryTo().getValue();
        int id2 = geo.getLabelToDisplayTo().getValue();
        double maxLat = 84.0;
        double minLat = -84.0;
        if (rowCount > 20 && identifier < 0) {
            cp = PaletteManager.create(rowCount, Arrays.asList(Color.BLACK, Color.BLUE, Color.GREEN, Color.YELLOW, Color.RED), Color.GREEN, 255);
        } else if (rowCount > 10) {
            cp = new FixedColorPalette(ColorUtils.COLOR_PALETTE20, Color.GREEN);
        } else if (rowCount > 5) {
            cp = new FixedColorPalette(ColorUtils.COLOR_PALETTE11, Color.GREEN);
        }
        FixedColorPalette cp2 = cp;
        int fromRounds = Math.max(0, displaySettings.getFrom() - 1);
        int toRounds = Math.min(rowCount, displaySettings.getTo());
        if (displaySettings.getLagNumber() > 0) {
            if (displaySettings.isForward()) {
                fromRounds = Math.max(0, fromRounds - displaySettings.getLagNumber());
            } else {
                toRounds = Math.min(rowCount, toRounds + displaySettings.getLagNumber());
            }
        }
        Number n1 = null;
        Number n2 = null;
        org.locationtech.jts.geom.Geometry geometry = null;
        Number n3 = null;
        Number n4 = null;
        org.locationtech.jts.geom.Geometry geometry1 = null;
        int rowX = fromRounds;
        while (rowX < toRounds) {
            block30: {
                Color c;
                Object label2;
                Object label;
                int row;
                block36: {
                    block34: {
                        block35: {
                            block33: {
                                block31: {
                                    block32: {
                                        row = rowX;
                                        if (rs != null && displaySettings.isFiltered()) {
                                            row = rs.convertRowIndexToModel(row);
                                        }
                                        if (!geo.isLatLonChosen()) break block31;
                                        n1 = (Number)resultSet.getValueAt(row, lat);
                                        n2 = (Number)resultSet.getValueAt(row, lon);
                                        if (n1 == null || n2 == null) break block30;
                                        if (n1.doubleValue() > maxLat) {
                                            n1 = maxLat;
                                        } else if (n1.doubleValue() < minLat) {
                                            n1 = minLat;
                                        }
                                        if (!(n2.doubleValue() > 1000.0)) break block32;
                                        n2 = 1000.0;
                                        break block33;
                                    }
                                    if (!(n2.doubleValue() < -1000.0)) break block33;
                                    n2 = -1000.0;
                                    break block33;
                                }
                                Geometry gg = (Geometry)resultSet.getValueAt(row, geom);
                                if (gg != null) {
                                    int sridGeos = gg.getSrid();
                                    if (sridGeos == 0) {
                                        sridGeos = 4326;
                                    }
                                    try {
                                        WKTReader2 reader = (WKTReader2)TripHandler.getReaderFromSRID(sridGeos).second();
                                        geometry = reader.read(gg.STAsText());
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        break block30;
                                    }
                                }
                                break block30;
                            }
                            label = null;
                            label2 = null;
                            c = Color.GRAY;
                            if (identifier >= 0) {
                                label = resultSet.getValueAt(row, identifier);
                                if (label != null) {
                                    c = colorMap.computeIfAbsent(label, o -> cp2.getColor(Double.valueOf(ai.getAndIncrement())));
                                }
                            } else {
                                c = cp2.getColor(Double.valueOf(ai.getAndIncrement()));
                            }
                            if (!geo.isLatLonChosenTo()) break block34;
                            n3 = (Number)resultSet.getValueAt(row, latTo);
                            n4 = (Number)resultSet.getValueAt(row, lonTo);
                            if (n3 == null || n4 == null) break block30;
                            if (n3.doubleValue() > 84.0) {
                                n3 = 84.0;
                            } else if (n3.doubleValue() < -84.0) {
                                n3 = -84.0;
                            }
                            if (!(n4.doubleValue() > 1000.0)) break block35;
                            n4 = 1000.0;
                            break block36;
                        }
                        if (!(n4.doubleValue() < -1000.0)) break block36;
                        n4 = -1000.0;
                        break block36;
                    }
                    Geometry gg = (Geometry)resultSet.getValueAt(row, geomTo);
                    if (gg != null) {
                        int sridGeos = gg.getSrid();
                        if (sridGeos == 0) {
                            sridGeos = 4326;
                        }
                        try {
                            WKTReader2 reader = (WKTReader2)TripHandler.getReaderFromSRID(sridGeos).second();
                            geometry1 = reader.read(gg.STAsText());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break block30;
                        }
                    }
                    break block30;
                }
                if (id2 >= 0 && (label2 = resultSet.getValueAt(row, id2)) != null) {
                    c = colorMap.computeIfAbsent(label2, o -> cp2.getColor(Double.valueOf(ai.getAndIncrement())));
                }
                if (geo.isLatLonChosen()) {
                    geometry = ((GeometryFactory)TripHandler.getReaderFromSRID(4326).first()).createPoint(new Coordinate(n2.doubleValue(), n1.doubleValue()));
                }
                if (geo.isLatLonChosenTo()) {
                    geometry1 = ((GeometryFactory)TripHandler.getReaderFromSRID(4326).first()).createPoint(new Coordinate(n4.doubleValue(), n3.doubleValue()));
                }
                wp1 = new GeoWaypoint(label == null ? null : label.toString(), c, geometry);
                GeoWaypoint wp2 = new GeoWaypoint(label2 == null ? null : label2.toString(), c, geometry1);
                waypoints.add(new FromToWaypoint(wp1, wp2));
            }
            ++rowX;
        }
        return new WaypointHolder<Waypoint>(waypoints);
    }

    private static class WaypointModel
    extends AGeoWaypointModel<FromToGeo> {
        private final IProperty<TextListItem<Integer>> latitudeTo = this.getProperty("latitudeTo");
        private final IProperty<TextListItem<Integer>> longitudeTo = this.getProperty("longitudeTo");
        private final IProperty<TextListItem<Integer>> geometryTo = this.getProperty("geometryTo");
        private final IProperty<TextListItem<Integer>> labelToDisplayTo = this.getProperty("labelToDisplayTo");
        private final IProperty<PointVisualizer> pointIconTo = this.getProperty("pointIconTo");
        private final IProperty<Boolean> latLonChosenTo = this.getProperty("latLonChosenTo");

        private WaypointModel() {
        }
    }
}

