/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.MathBuilder;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.ResultColumnMapper;
import com.sigge.filerunner.view.results.graph.geo.GeoGraphHandler2;
import com.sigge.filerunner.view.results.graph.geo.options.ColorSetting;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import com.siggemannen.binding.SoftCopy;
import com.siggemannen.core.Tuple;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

@SoftCopy
public class SingleGeo
implements IGeoSetting<SingleGeo> {
    private transient GraphResult resultSet;
    private List<String> columns = new ArrayList<String>();
    private TextListItem<Integer> latitude;
    private TextListItem<Integer> longitude;
    private TextListItem<Integer> geometry;
    private TextListItem<Integer> labelToDisplay;
    private TextListItem<Integer> identifier;
    private PointVisualizer pointIcon;
    private boolean latLonChosen;
    private GeoType type;
    private final transient MathBuilder mb = new MathBuilder();
    private transient ColorSetting colorSetting = ColorSetting.COLORIZED_1;
    private transient String font = null;
    private transient Integer fontSize = null;
    private transient Color fontColor = null;
    private transient String id = null;

    public SingleGeo() {
    }

    public SingleGeo(SingleGeo copy) {
        this.resultSet = copy.resultSet;
        this.columns = new ArrayList<String>(copy.columns);
        this.latitude = copy.latitude;
        this.longitude = copy.longitude;
        this.geometry = copy.geometry;
        this.identifier = copy.identifier;
        this.labelToDisplay = copy.labelToDisplay;
        this.pointIcon = copy.pointIcon;
        this.latLonChosen = copy.latLonChosen;
        this.type = copy.type;
        this.colorSetting = copy.colorSetting != null ? copy.colorSetting : ColorSetting.COLORIZED_1;
        this.font = copy.font;
        this.fontSize = copy.fontSize;
        this.fontColor = copy.fontColor;
    }

    @Override
    public IResultSetTable getChosenResultSet() {
        return this.resultSet.getResultSet();
    }

    public final GraphResult getResultSet() {
        return this.resultSet;
    }

    public final void setResultSet(GraphResult resultSet) {
        this.resultSet = resultSet;
    }

    public final TextListItem<Integer> getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(TextListItem<Integer> latitude) {
        this.latitude = latitude;
    }

    public final TextListItem<Integer> getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(TextListItem<Integer> longitude) {
        this.longitude = longitude;
    }

    public final TextListItem<Integer> getGeometry() {
        return this.geometry;
    }

    public final void setGeometry(TextListItem<Integer> geometry) {
        this.geometry = geometry;
    }

    public final TextListItem<Integer> getLabelToDisplay() {
        return this.labelToDisplay;
    }

    public final void setLabelToDisplay(TextListItem<Integer> labelToDisplay) {
        this.labelToDisplay = labelToDisplay;
    }

    public final PointVisualizer getPointIcon() {
        return this.pointIcon;
    }

    public final void setPointIcon(PointVisualizer pointIcon) {
        this.pointIcon = pointIcon;
    }

    @Override
    public boolean isValid() {
        if (this.type == GeoType.HEATMAP) {
            return this.isNumber(this.latitude) && this.isNumber(this.longitude) && this.isNumber(this.labelToDisplay) && !this.latitude.getValue().equals(this.longitude.getValue()) && !this.labelToDisplay.getValue().equals(this.latitude.getValue());
        }
        if (this.latLonChosen) {
            return this.isNumber(this.latitude) && this.isNumber(this.longitude) && !this.latitude.getValue().equals(this.longitude.getValue());
        }
        return GeoGraphHandler2.isGeo(this.getChosenResultSet(), this.geometry.getValue());
    }

    public boolean isLatLonChosen() {
        return this.latLonChosen;
    }

    public void setLatLonChosen(boolean latLonChosen) {
        this.latLonChosen = latLonChosen;
    }

    @Override
    public GeoType getType() {
        return this.type;
    }

    public void setType(GeoType type) {
        this.type = type;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public ColorSetting getColorSetting() {
        return this.colorSetting;
    }

    public void setColorSetting(ColorSetting colorSetting) {
        this.colorSetting = colorSetting;
    }

    public TextListItem<Integer> getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(TextListItem<Integer> identifier) {
        this.identifier = identifier;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public Optional<MathBuilder> getMathBuilder() {
        return Optional.of(this.mb);
    }

    @Override
    public Optional<SingleGeo> resolveFromStorage(ResultColumnMapper resultSet) {
        Optional<SingleGeo> emp = Optional.empty();
        try {
            Optional<Object> identifier;
            Optional<Tuple<Integer, String>> label;
            Optional<Tuple<Integer, String>> lat = this.resolve(resultSet, this.latitude, this.columns, this.latLonChosen, GraphHandler.VALUE_TYPE.NUMBER);
            Optional<Tuple<Integer, String>> lon = this.resolve(resultSet, this.longitude, this.columns, this.latLonChosen, GraphHandler.VALUE_TYPE.NUMBER);
            Optional<Tuple<Integer, String>> geo = this.resolve(resultSet, this.geometry, this.columns, !this.latLonChosen, GraphHandler.VALUE_TYPE.GEO);
            if (this.getType() == GeoType.WAYPOINT) {
                label = this.resolve(resultSet, this.labelToDisplay, this.columns, new GraphHandler.VALUE_TYPE[0]);
                identifier = this.resolve(resultSet, this.identifier, this.columns, new GraphHandler.VALUE_TYPE[0]);
            } else {
                label = this.resolve(resultSet, this.labelToDisplay, this.columns, true, GraphHandler.VALUE_TYPE.NUMBER);
                identifier = Optional.empty();
            }
            SingleGeo sg = new SingleGeo(this);
            sg.columns = new ArrayList<String>();
            sg.geometry = geo.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.labelToDisplay = label.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.identifier = identifier.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.latitude = lat.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.longitude = lon.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.resultSet = resultSet.getResult();
            return Optional.of(sg);
        }
        catch (Exception ex) {
            return emp;
        }
    }

    @Override
    public SingleGeo toStorage() {
        SingleGeo storage = new SingleGeo(this);
        int i = 0;
        while (i < this.resultSet.getResultSet().getColumnCount()) {
            storage.columns.add(this.resultSet.getResultSet().getColumnName(i));
            ++i;
        }
        storage.resultSet = null;
        return storage;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.type).append(this.latitude).append(this.longitude).append((Object)"geo=").append(this.geometry).append((Object)"label=").append(this.labelToDisplay).build();
    }

    @Override
    public IGeoSetting copy() {
        return new SingleGeo(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

