/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.MathBuilder;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.ResultColumnMapper;
import com.sigge.filerunner.view.results.graph.geo.GeoGraphHandler2;
import com.sigge.filerunner.view.results.graph.geo.options.GeoType;
import com.sigge.filerunner.view.results.graph.geo.options.IGeoSetting;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import com.siggemannen.binding.SoftCopy;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

@SoftCopy
public class FromToGeo
implements IGeoSetting<FromToGeo> {
    private transient GraphResult resultSet;
    private TextListItem<Integer> latitude;
    private TextListItem<Integer> longitude;
    private TextListItem<Integer> geometry;
    private TextListItem<Integer> labelToDisplay;
    private PointVisualizer pointIcon;
    private boolean latLonChosen;
    private transient GraphResult resultSetTo;
    private TextListItem<Integer> latitudeTo;
    private TextListItem<Integer> longitudeTo;
    private TextListItem<Integer> geometryTo;
    private TextListItem<Integer> labelToDisplayTo;
    private PointVisualizer pointIconTo;
    private boolean latLonChosenTo;
    private List<String> columns = new ArrayList<String>();
    private GeoType type;
    private final transient MathBuilder mb = new MathBuilder();

    public FromToGeo() {
    }

    public FromToGeo(FromToGeo copy) {
        this.resultSet = copy.resultSet;
        this.columns = new ArrayList<String>(copy.columns);
        this.latitude = copy.latitude;
        this.longitude = copy.longitude;
        this.geometry = copy.geometry;
        this.labelToDisplay = copy.labelToDisplay;
        this.pointIcon = copy.pointIcon;
        this.latLonChosen = copy.latLonChosen;
        this.resultSetTo = copy.resultSetTo;
        this.latitudeTo = copy.latitudeTo;
        this.longitudeTo = copy.longitudeTo;
        this.geometryTo = copy.geometryTo;
        this.labelToDisplayTo = copy.labelToDisplayTo;
        this.pointIconTo = copy.pointIconTo;
        this.latLonChosenTo = copy.latLonChosenTo;
        this.type = copy.type;
    }

    @Override
    public IResultSetTable getChosenResultSet() {
        return this.resultSet.getResultSet();
    }

    public final GraphResult getResultSet() {
        return this.resultSet;
    }

    public final void setResultSet(GraphResult resultSet) {
        this.resultSet = resultSet;
    }

    public final TextListItem<Integer> getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(TextListItem<Integer> latitude) {
        this.latitude = latitude;
    }

    public final TextListItem<Integer> getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(TextListItem<Integer> longitude) {
        this.longitude = longitude;
    }

    public final TextListItem<Integer> getGeometry() {
        return this.geometry;
    }

    public final void setGeometry(TextListItem<Integer> geometry) {
        this.geometry = geometry;
    }

    public final TextListItem<Integer> getLabelToDisplay() {
        return this.labelToDisplay;
    }

    public final void setLabelToDisplay(TextListItem<Integer> labelToDisplay) {
        this.labelToDisplay = labelToDisplay;
    }

    public final PointVisualizer getPointIcon() {
        return this.pointIcon;
    }

    public final void setPointIcon(PointVisualizer pointIcon) {
        this.pointIcon = pointIcon;
    }

    @Override
    public boolean isValid() {
        boolean test1 = this.latLonChosen ? this.isNumber(this.latitude) && this.isNumber(this.longitude) && !this.latitude.getValue().equals(this.longitude.getValue()) : GeoGraphHandler2.isGeo(this.getChosenResultSet(), this.geometry.getValue());
        if (!test1) {
            return false;
        }
        test1 = this.latLonChosenTo ? this.isNumber(this.latitudeTo) && this.isNumber(this.longitudeTo) && !this.latitudeTo.getValue().equals(this.longitudeTo.getValue()) : GeoGraphHandler2.isGeo(this.getChosenResultSet(), this.geometryTo.getValue());
        return test1;
    }

    public boolean isLatLonChosen() {
        return this.latLonChosen;
    }

    public void setLatLonChosen(boolean latLonChosen) {
        this.latLonChosen = latLonChosen;
    }

    @Override
    public GeoType getType() {
        return this.type;
    }

    public void setType(GeoType type) {
        this.type = type;
    }

    @Override
    public Optional<MathBuilder> getMathBuilder() {
        return Optional.of(this.mb);
    }

    public final GraphResult getResultSetTo() {
        return this.resultSetTo;
    }

    public final void setResultSetTo(GraphResult resultSetTo) {
        this.resultSetTo = resultSetTo;
    }

    public final TextListItem<Integer> getLatitudeTo() {
        return this.latitudeTo;
    }

    public final void setLatitudeTo(TextListItem<Integer> latitudeTo) {
        this.latitudeTo = latitudeTo;
    }

    public final TextListItem<Integer> getLongitudeTo() {
        return this.longitudeTo;
    }

    public final void setLongitudeTo(TextListItem<Integer> longitudeTo) {
        this.longitudeTo = longitudeTo;
    }

    public final TextListItem<Integer> getGeometryTo() {
        return this.geometryTo;
    }

    public final void setGeometryTo(TextListItem<Integer> geometryTo) {
        this.geometryTo = geometryTo;
    }

    public final TextListItem<Integer> getLabelToDisplayTo() {
        return this.labelToDisplayTo;
    }

    public final void setLabelToDisplayTo(TextListItem<Integer> labelToDisplayTo) {
        this.labelToDisplayTo = labelToDisplayTo;
    }

    public final PointVisualizer getPointIconTo() {
        return this.pointIconTo;
    }

    public final void setPointIconTo(PointVisualizer pointIconTo) {
        this.pointIconTo = pointIconTo;
    }

    public final boolean isLatLonChosenTo() {
        return this.latLonChosenTo;
    }

    public final void setLatLonChosenTo(boolean latLonChosenTo) {
        this.latLonChosenTo = latLonChosenTo;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public Optional<FromToGeo> resolveFromStorage(ResultColumnMapper resultSet) {
        Optional<FromToGeo> emp = Optional.empty();
        try {
            Optional<Tuple<Integer, String>> lat = this.resolve(resultSet, this.latitude, this.columns, this.latLonChosen, GraphHandler.VALUE_TYPE.NUMBER);
            Optional<Tuple<Integer, String>> lon = this.resolve(resultSet, this.longitude, this.columns, this.latLonChosen, GraphHandler.VALUE_TYPE.NUMBER);
            Optional<Tuple<Integer, String>> geo = this.resolve(resultSet, this.geometry, this.columns, !this.latLonChosen, GraphHandler.VALUE_TYPE.GEO);
            Optional<Tuple<Integer, String>> label = this.resolve(resultSet, this.labelToDisplay, this.columns, new GraphHandler.VALUE_TYPE[0]);
            FromToGeo sg = new FromToGeo(this);
            sg.columns = new ArrayList<String>();
            sg.geometry = geo.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.labelToDisplay = label.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.latitude = lat.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.longitude = lon.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.resultSet = resultSet.getResult();
            Optional<Tuple<Integer, String>> latTo = this.resolve(resultSet, this.latitudeTo, this.columns, this.latLonChosenTo, GraphHandler.VALUE_TYPE.NUMBER);
            Optional<Tuple<Integer, String>> lonTo = this.resolve(resultSet, this.longitudeTo, this.columns, this.latLonChosenTo, GraphHandler.VALUE_TYPE.NUMBER);
            Optional<Tuple<Integer, String>> geoTo = this.resolve(resultSet, this.geometryTo, this.columns, !this.latLonChosenTo, GraphHandler.VALUE_TYPE.GEO);
            Optional<Tuple<Integer, String>> labelTo = this.resolve(resultSet, this.labelToDisplayTo, this.columns, new GraphHandler.VALUE_TYPE[0]);
            sg.geometryTo = geoTo.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.labelToDisplayTo = labelTo.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.latitudeTo = latTo.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.longitudeTo = lonTo.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.resultSetTo = resultSet.getResult();
            return Optional.of(sg);
        }
        catch (Exception ex) {
            return emp;
        }
    }

    @Override
    public FromToGeo toStorage() {
        FromToGeo storage = new FromToGeo(this);
        int i = 0;
        while (i < this.resultSet.getResultSet().getColumnCount()) {
            storage.columns.add(this.resultSet.getResultSet().getColumnName(i));
            ++i;
        }
        storage.resultSet = null;
        storage.resultSetTo = null;
        return storage;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.type).append(this.latitude).append(this.longitude).append(this.geometry).append((Object)"label=").append(this.labelToDisplay).append((Object)"to:").append(this.latitudeTo).append(this.longitudeTo).append(this.geometryTo).append((Object)"label=").append(this.labelToDisplayTo).build();
    }

    @Override
    public IGeoSetting copy() {
        return new FromToGeo(this);
    }
}

