/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.view.JMemoryFrame;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.VirtualEarthTileFactoryInfo;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;

public class SelectionAdapter
extends MouseAdapter {
    private boolean dragging;
    private final JXMapViewer viewer;
    private final Point2D startPos = new Point2D.Double();
    private final Point2D endPos = new Point2D.Double();
    private final Consumer<Point2D> currentPoint;
    private final PositionMeasurer measurer = new PositionMeasurer();

    public SelectionAdapter(JXMapViewer viewer, Consumer<Point2D> current) {
        this.viewer = viewer;
        this.currentPoint = current;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.currentPoint.accept(this.convertGUIPointToCoordinate(e.getPoint()));
    }

    private Point convertGUIPointToCoordinate(Point p) {
        Rectangle viewportBounds = this.viewer.getViewportBounds();
        int wx = viewportBounds.x + p.x;
        int wy = viewportBounds.y + p.y;
        return new Point(wx, wy);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        this.startPos.setLocation(e.getX(), e.getY());
        this.endPos.setLocation(e.getX(), e.getY());
        this.dragging = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.endPos.setLocation(e.getX(), e.getY());
        this.viewer.repaint();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void mouseReleased(MouseEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl60 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl60 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Tuple<Rectangle, List<GeoPosition>> getRectangle() {
        if (this.dragging) {
            int x1 = (int)Math.min(this.startPos.getX(), this.endPos.getX());
            int y1 = (int)Math.min(this.startPos.getY(), this.endPos.getY());
            int x2 = (int)Math.max(this.startPos.getX(), this.endPos.getX());
            int y2 = (int)Math.max(this.startPos.getY(), this.endPos.getY());
            return Tuple.of((Object)new Rectangle(x1, y1, x2 - x1, y2 - y1), this.measurer.positions);
        }
        return Tuple.of(null, this.measurer.positions);
    }

    private int positionSize() {
        return this.measurer.positions.size();
    }

    private static double haversineDistance(GeoPosition geo, GeoPosition geo2) {
        return SelectionAdapter.haversineDistance(geo.getLatitude(), geo.getLongitude(), geo2.getLatitude(), geo2.getLongitude());
    }

    private static double haversineDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6371.0088;
        Double latDistance = Math.toRadians(lat2 - lat1);
        Double lonDistance = Math.toRadians(lon2 - lon1);
        Double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371.0088 * c;
    }

    private static double toNm(double kms) {
        return kms / 1.852;
    }

    private static double toMiles(double kms) {
        return kms / 1.609;
    }

    private /* synthetic */ void lambda$0(MouseEvent mouseEvent) {
        ClipboardUtils.setStringDataToClipboard(this.viewer.getTileFactory().pixelToGeo((Point2D)this.convertGUIPointToCoordinate(mouseEvent.getPoint()), this.viewer.getZoom()).toString());
    }

    private /* synthetic */ void lambda$1(MouseEvent mouseEvent) {
        this.measurer.addPosition(mouseEvent);
        this.viewer.repaint();
    }

    private /* synthetic */ void lambda$2(MouseEvent mouseEvent) {
        if (this.positionSize() == 1) {
            this.measurer.addPosition(mouseEvent);
        }
        this.viewer.repaint();
        this.measurer.display();
    }

    private /* synthetic */ void lambda$3() {
        this.measurer.positions.add(this.measurer.positions.get(0));
        this.viewer.repaint();
        this.measurer.display();
    }

    private /* synthetic */ void lambda$4(MouseEvent mouseEvent) {
        this.measurer.addPosition(mouseEvent);
        this.viewer.repaint();
        this.measurer.display();
    }

    private /* synthetic */ void lambda$5() {
        this.measurer.reset();
        this.viewer.repaint();
    }

    private /* synthetic */ void lambda$6() {
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        this.viewer.setTileFactory((TileFactory)tileFactory);
    }

    private /* synthetic */ void lambda$7() {
        VirtualEarthTileFactoryInfo info = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID);
        DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
        this.viewer.setTileFactory((TileFactory)tileFactory);
    }

    private class PositionMeasurer {
        List<GeoPosition> positions = new ArrayList<GeoPosition>();

        private PositionMeasurer() {
        }

        public void addPosition(MouseEvent e) {
            this.positions.add(SelectionAdapter.this.viewer.getTileFactory().pixelToGeo((Point2D)SelectionAdapter.this.convertGUIPointToCoordinate(e.getPoint()), SelectionAdapter.this.viewer.getZoom()));
        }

        public void reset() {
            this.positions.clear();
        }

        public void display() {
            JMemoryFrame memory = new JMemoryFrame("Voyage trip", "voyageTrip");
            if (memory.isDefault()) {
                memory.setSize(640, 480);
            }
            JTextArea ja = new JTextArea();
            JScrollPane pane = new JScrollPane(ja);
            memory.add(pane);
            Window z = SwingUtilities.windowForComponent((Component)SelectionAdapter.this.viewer);
            memory.setLocationRelativeTo(z != null ? new JFrame(z.getGraphicsConfiguration()) : new JFrame());
            memory.setDefaultCloseOperation(2);
            double kms = 0.0;
            GeoPosition prev = null;
            StringBuilder sb = new StringBuilder();
            sb.append("Positions:");
            for (GeoPosition geo : this.positions) {
                sb.append(System.lineSeparator()).append("[").append(geo.getLatitude()).append(" ").append(geo.getLongitude()).append("]");
                if (prev != null) {
                    kms += SelectionAdapter.haversineDistance(prev, geo);
                }
                prev = geo;
            }
            double miles = SelectionAdapter.toMiles(kms);
            double nm = SelectionAdapter.toNm(kms);
            sb.append(System.lineSeparator()).append("Distances:").append(System.lineSeparator()).append("Kilometers: ").append(kms).append(System.lineSeparator()).append("Miles: ").append(miles).append(System.lineSeparator()).append("Nautical Miles: ").append(nm);
            ja.setText(sb.toString());
            memory.setVisible(true);
        }
    }
}

