/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.GraphType;
import com.sigge.filerunner.view.results.graph.GraphView;
import com.sigge.filerunner.view.results.graph.IGraphHandler;
import com.sigge.filerunner.view.results.graph.geo.GeoGraphHandler2;
import com.sigge.filerunner.view.results.graph.simple.SimpleGraphHandler;
import com.siggemannen.binding.Binder;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.MapBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GraphHandler {
    private final GraphView view = new GraphView();
    private final List<GraphResult> results = new ArrayList<GraphResult>();
    private Binder.Presenter<GraphResult> resultSetPresenter;
    private final Binder.Presenter<GraphType> chartTypePresenter;
    private final Map<GraphType, IGraphHandler> handlers;
    private static GraphType lastChosenGraph;
    private static final List<GraphType> CHART_TYPES;

    static {
        CHART_TYPES = Arrays.asList(GraphType.POINTS, GraphType.LINE, GraphType.PIE, GraphType.RING, GraphType.AREA, GraphType.STACKEDAREA, GraphType.BAR, GraphType.STACKED, GraphType.GEOMETRYV2);
    }

    public GraphHandler() {
        this.resultSetPresenter = Binder.bindToCombo(this.view.resultSetCombo, this.results);
        this.chartTypePresenter = Binder.bindToCombo(this.view.chartTypeCombo, CHART_TYPES);
        this.view.resultSetCombo.setEnabled(false);
        this.view.chartTypeCombo.setEnabled(false);
        this.view.resultSetCombo.setRenderer(new LabelledCellRenderer());
        this.view.chartTypeCombo.setRenderer(new LabelledCellRenderer());
        this.resultSetPresenter.getModel().addModelChangeListener(this::generateGraph);
        SimpleGraphHandler sh = new SimpleGraphHandler();
        GeoGraphHandler2 gg = new GeoGraphHandler2();
        this.handlers = new MapBuilder((Object)GraphType.POINTS, (Object)sh).append((Object)GraphType.LINE, (Object)sh).append((Object)GraphType.STACKED, (Object)sh).append((Object)GraphType.AREA, (Object)sh).append((Object)GraphType.STACKEDAREA, (Object)sh).append((Object)GraphType.BAR, (Object)sh).append((Object)GraphType.PIE, (Object)sh).append((Object)GraphType.RING, (Object)sh).append((Object)GraphType.GEOMETRYV2, (Object)gg).build();
        String lastGraph = ConfigHandler.getConfig().getStringConfigValue("graphHandler.chosenGraph", null);
        try {
            lastChosenGraph = lastGraph != null ? GraphType.valueOf(lastGraph) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateGraph() {
        this.generateGraph(false);
    }

    public void generateGraph(boolean draw) {
        IGraphHandler gh;
        GraphResult resultSetChosen = (GraphResult)this.resultSetPresenter.getValue();
        if (resultSetChosen == null) {
            return;
        }
        GraphType graphType = (GraphType)this.chartTypePresenter.getValue();
        if (draw) {
            lastChosenGraph = graphType;
            ConfigHandler.getConfig().setConfigValue("graphHandler.chosenGraph", lastChosenGraph.name());
        }
        if ((gh = this.handlers.get(graphType)) == null || !gh.canHandle(resultSetChosen)) {
            return;
        }
        gh.present(this.view, graphType, this.results, resultSetChosen, draw);
        this.view.jSplitPane1.setDividerLocation(-1);
    }

    public GraphView getView() {
        return this.view;
    }

    public void dispose() {
        for (IGraphHandler handler : this.handlers.values()) {
            try {
                handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.results.clear();
        this.view.removeAll();
        this.resultSetPresenter = null;
    }

    public void handle(GraphResult gr) {
        if (gr.getResultSet().getRowCount() > 0) {
            this.view.resultSetCombo.setEnabled(true);
            this.view.chartTypeCombo.setEnabled(true);
            this.results.add(gr);
            if (this.resultSetPresenter.getValue() == null) {
                GraphType temp = lastChosenGraph;
                this.view.resultSetCombo.setSelectedIndex(0);
                if (temp != null) {
                    this.view.chartTypeCombo.setSelectedIndex(CHART_TYPES.indexOf(temp));
                }
                this.chartTypePresenter.getModel().addModelChangeListener(() -> this.generateGraph(true));
            }
            this.resultSetPresenter = Binder.bindToCombo(this.view.resultSetCombo, this.results);
            this.resultSetPresenter.getModel().addModelChangeListener(() -> this.generateGraph(true));
        }
    }

    public static enum VALUE_TYPE {
        NUMBER,
        DATE,
        STRING,
        GEO;


        public static VALUE_TYPE getFromType(FieldType fieldType) {
            if (ListUtils.in((Object)((Object)fieldType), (Object[])new FieldType[]{FieldType.SQLDATE, FieldType.SQLDATEWITHZONE})) {
                return DATE;
            }
            if (ListUtils.in((Object)((Object)fieldType), (Object[])new FieldType[]{FieldType.SQLFLOAT, FieldType.SQLINTEGER, FieldType.SQLBOOLEAN, FieldType.SQLLONG})) {
                return NUMBER;
            }
            if (ListUtils.in((Object)((Object)fieldType), (Object[])new FieldType[]{FieldType.SQLSTRING, FieldType.SQLXMLSTRING})) {
                return STRING;
            }
            if (fieldType == FieldType.SQLGEOMETRY || fieldType == FieldType.SQLGEOGRAPHY) {
                return GEO;
            }
            return null;
        }
    }
}

