/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.export.scripter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sigge.dbrunner.table.ScriptOptions;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.export.inserts.IScripter;
import com.sigge.filerunner.sql.OutputBuilder;
import com.sigge.filerunner.sql.OutputFormat;
import com.sigge.filerunner.view.core.DialogView;
import com.sigge.filerunner.view.core.OKCancelPanel;
import com.sigge.filerunner.view.results.export.scripter.IScriptOutputPresenter;
import com.sigge.filerunner.view.results.export.scripter.ScriptDialog;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IProperty;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileNameExtensionFilter;

@Singleton
public class ScriptOutputPresenter
implements IScriptOutputPresenter {
    private final IScripter scripter;

    @Inject
    ScriptOutputPresenter(IScripter scripter) {
        this.scripter = scripter;
    }

    @Override
    public OutputBuilder.ScriptOutput present(final JFrame mainFrame, final boolean fileOnly) {
        DialogView dv = new DialogView(mainFrame, true);
        dv.setTitle("Scripting settings");
        ScriptDialog jp = new ScriptDialog();
        OKCancelPanel buttons = dv.setContent(jp, true);
        dv.centerOnCorrectScreen(mainFrame);
        final ScriptOutputSettingsModel md = new ScriptOutputSettingsModel();
        APresenter<ScriptOutputSettings, AModel<ScriptOutputSettings>, ScriptDialog> presenter = new APresenter<ScriptOutputSettings, AModel<ScriptOutputSettings>, ScriptDialog>((AModel)md, jp){

            protected void initBindings() {
                this.bind(new JRadioButton[]{((ScriptDialog)this.view).outFile, ((ScriptDialog)this.view).outWindow, ((ScriptDialog)this.view).outClipboard}).to(md.output, (Object[])new OutputFormat[]{OutputFormat.FILE, OutputFormat.NEW_WINDOW, OutputFormat.CLIPBOARD});
                this.bind(new JRadioButton[]{((ScriptDialog)this.view).tableFromQuery, ((ScriptDialog)this.view).tableSpecific}).to(md.tableOutput, (Object[])new TableOutput[]{TableOutput.FROM_QUERY, TableOutput.SPECIFIC});
                this.bind(((ScriptDialog)this.view).tableName).to(md.tableName);
                this.bind(((ScriptDialog)this.view).filePath).to(md.filename);
                ((ScriptDialog)this.view).browseButton.addActionListener(al -> {
                    File f = FileUtils.saveFile(mainFrame, null, new FileNameExtensionFilter("SQL files (*.sql)", "sql"));
                    if (f != null) {
                        scriptOutputSettingsModel.filename.setValue((Object)f.getAbsolutePath());
                    }
                });
                ((ScriptDialog)this.view).outWindow.addActionListener(al -> ((ScriptDialog)this.view).filePath.setEditable(false));
                ((ScriptDialog)this.view).outClipboard.addActionListener(al -> ((ScriptDialog)this.view).filePath.setEditable(false));
                ((ScriptDialog)this.view).outFile.addActionListener(al -> ((ScriptDialog)this.view).filePath.setEditable(true));
                if (fileOnly) {
                    ((ScriptDialog)this.view).outWindow.setVisible(false);
                    ((ScriptDialog)this.view).outClipboard.setVisible(false);
                }
            }
        };
        ScriptOutputSettings object = new ScriptOutputSettings();
        object.output = OutputFormat.FILE;
        object.tableOutput = TableOutput.FROM_QUERY;
        md.addModelChangeListener(() -> buttons.getOkButton().setEnabled(!(object.output == OutputFormat.FILE && StringUtils.isEmpty(object.fileName) || object.tableOutput == TableOutput.SPECIFIC && StringUtils.isEmpty(object.tableName))));
        presenter.setObject((Object)object);
        dv.setVisible(true);
        if (dv.getReturnStatus() == 1) {
            ScriptOptions so = new ScriptOptions();
            so.setTableName(object.tableName);
            switch (object.output) {
                case FILE: {
                    return OutputBuilder.toScriptOutput(this.scripter, OutputBuilder.toFile(null, new File(object.fileName), null), so);
                }
                case CLIPBOARD: {
                    return OutputBuilder.toScriptOutput(this.scripter, OutputBuilder.toClipboard(), so);
                }
                case NEW_WINDOW: {
                    return OutputBuilder.toScriptOutput(this.scripter, OutputBuilder.toNewWindow(), so);
                }
            }
        }
        return null;
    }

    public class ScriptOutputSettings {
        private OutputFormat output;
        private String fileName;
        private TableOutput tableOutput;
        private String tableName;

        public OutputFormat getOutput() {
            return this.output;
        }

        public void setOutput(OutputFormat output) {
            this.output = output;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public TableOutput getTableOutput() {
            return this.tableOutput;
        }

        public void setTableOutput(TableOutput tableOutput) {
            this.tableOutput = tableOutput;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }
    }

    public class ScriptOutputSettingsModel
    extends AModel<ScriptOutputSettings> {
        IProperty<String> filename = this.getProperty("fileName");
        IProperty<TableOutput> tableOutput = this.getProperty("tableOutput");
        IProperty<OutputFormat> output = this.getProperty("output");
        IProperty<String> tableName = this.getProperty("tableName");
    }

    public static enum TableOutput {
        SPECIFIC,
        FROM_QUERY;

    }
}

