/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.results.AColumnHandler;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;

public class StringColumnHandler
extends AColumnHandler<String> {
    private final transient Map<String, Integer> stringMap = new WeakHashMap<String, Integer>();
    private byte[] BYTE_STRING_DATA = new byte[12];
    private byte[] EXTENDED_DATA;
    private int[] INDEX_DATA = new int[12];
    private int offset = 0;
    private long cachehits = 0L;
    private String previousString = null;
    private boolean lastStringWasCache;
    private boolean lastRepeatWasCache;

    StringColumnHandler() {
        this.EXTENDED_DATA = new byte[12];
        this.INDEX_DATA[0] = 2;
        this.INDEX_DATA[1] = 2;
        this.BYTE_STRING_DATA[0] = 0;
        this.BYTE_STRING_DATA[1] = 0;
        this.EXTENDED_DATA[0] = 0;
        this.EXTENDED_DATA[1] = 0;
        this.offset = 2;
    }

    public void addRow(String row) {
        int counter2 = this.counter + 2;
        this.INDEX_DATA = StringColumnHandler.grow(this.INDEX_DATA, counter2 + 1);
        this.EXTENDED_DATA = StringColumnHandler.grow(this.EXTENDED_DATA, counter2 + 1);
        if (row == null) {
            ++this.nullcounter;
            this.INDEX_DATA[counter2] = this.offset;
            this.EXTENDED_DATA[counter2] = 0;
            this.lastStringWasCache = false;
            this.lastRepeatWasCache = false;
        } else if (row.length() == 0) {
            this.INDEX_DATA[counter2] = this.offset;
            this.EXTENDED_DATA[counter2] = 1;
            this.lastStringWasCache = false;
            this.lastRepeatWasCache = false;
        } else if (row.length() < 100 && this.previousString != null && this.previousString.equals(row)) {
            int prev = this.INDEX_DATA[counter2 - 1];
            int prevPrev = this.INDEX_DATA[counter2 - 2];
            int prevPrevPrev = this.INDEX_DATA[counter2 - 3];
            this.EXTENDED_DATA[counter2] = (byte)(this.lastStringWasCache || this.lastRepeatWasCache ? 5 : 2);
            this.INDEX_DATA[counter2] = prev == this.offset ? (prevPrevPrev > prevPrev && prevPrevPrev != this.offset ? prevPrevPrev : prevPrev) : this.offset;
            this.lastRepeatWasCache = this.lastStringWasCache || this.lastRepeatWasCache;
            this.lastStringWasCache = false;
        } else if (row.length() < 30 && row.length() > 2) {
            Integer rowIndex = this.stringMap.get(row);
            if (rowIndex == null) {
                this.stringMap.put(row, this.counter);
                this.addStringToArray(row);
            } else {
                byte[] b = StringColumnHandler.toByteArray(rowIndex);
                this.BYTE_STRING_DATA = StringColumnHandler.grow(this.BYTE_STRING_DATA, this.offset + b.length);
                System.arraycopy(b, 0, this.BYTE_STRING_DATA, this.offset, b.length);
                this.offset += b.length;
                this.INDEX_DATA[counter2] = this.offset;
                this.EXTENDED_DATA[counter2] = 4;
                ++this.cachehits;
                this.lastStringWasCache = true;
                this.lastRepeatWasCache = false;
            }
        } else {
            this.addStringToArray(row);
        }
        this.previousString = row;
        ++this.counter;
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private void addStringToArray(String row) {
        byte[] b = row.getBytes(StandardCharsets.UTF_8);
        this.BYTE_STRING_DATA = StringColumnHandler.grow(this.BYTE_STRING_DATA, this.offset + b.length);
        System.arraycopy(b, 0, this.BYTE_STRING_DATA, this.offset, b.length);
        this.INDEX_DATA[this.counter + 2] = this.offset += b.length;
        this.EXTENDED_DATA[this.counter + 2] = 3;
        this.lastStringWasCache = false;
        this.lastRepeatWasCache = false;
    }

    @Override
    public String getRowValue(int index) {
        if (this.INDEX_DATA == null) {
            return null;
        }
        byte extra = this.EXTENDED_DATA[index += 2];
        if (extra == 0) {
            return null;
        }
        if (extra == 1) {
            return "";
        }
        int ix = this.INDEX_DATA[index];
        int prevPrev = this.INDEX_DATA[index - 2];
        int prev = this.INDEX_DATA[index - 1];
        if (prevPrev > prev && ix > prevPrev) {
            prev = prevPrev;
        }
        int from = Math.min(prev, ix);
        if (extra == 2 || extra == 3) {
            int to = Math.abs(ix - prev);
            return new String(this.BYTE_STRING_DATA, from, to, StandardCharsets.UTF_8);
        }
        int cachedRow = StringColumnHandler.fromByteArray(this.BYTE_STRING_DATA, from);
        return this.getRowValue(cachedRow);
    }

    private static int fromByteArray(byte[] bytes, int start) {
        return bytes[start] << 24 | (bytes[start + 1] & 0xFF) << 16 | (bytes[start + 2] & 0xFF) << 8 | bytes[start + 3] & 0xFF;
    }

    @Override
    public void trimToSize() {
        if (this.nullcounter == this.counter) {
            this.clearData();
            return;
        }
        this.BYTE_STRING_DATA = Arrays.copyOf(this.BYTE_STRING_DATA, this.offset);
        this.INDEX_DATA = Arrays.copyOf(this.INDEX_DATA, this.counter + 2);
        this.EXTENDED_DATA = Arrays.copyOf(this.EXTENDED_DATA, this.counter + 2);
        this.stringMap.clear();
        this.previousString = null;
        this.fixNulls();
    }

    @Override
    public void clearData() {
        super.clearData();
        this.stringMap.clear();
        this.BYTE_STRING_DATA = null;
        this.INDEX_DATA = null;
        this.EXTENDED_DATA = null;
        this.previousString = null;
    }

    void printIndexes() {
        int i = 2;
        while (i < this.INDEX_DATA.length) {
            System.out.println("#" + (i - 2) + ":" + this.INDEX_DATA[i]);
            ++i;
        }
    }

    public long getCachehits() {
        return this.cachehits;
    }

    @Override
    public long getByteSize() {
        long size = 0L;
        if (this.INDEX_DATA != null) {
            size += (long)((this.INDEX_DATA.length - 2) * 4);
        }
        if (this.BYTE_STRING_DATA != null) {
            size += (long)(this.BYTE_STRING_DATA.length - 2);
        }
        return size;
    }
}

