/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.ResultTableHandler;
import com.siggemannen.functional.throwing.ThrowingRunnable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public final class SelectedResultSetTable
implements IResultSetTable {
    List<Integer> rows;
    List<Integer> cols;
    private transient BiFunction<Integer, Integer, Object> convertedVector;
    private transient BiFunction<Integer, Integer, String> stringWector;
    List<Class<?>> columnClazz = new ArrayList();
    List<FieldType> columnTypes = new ArrayList<FieldType>();
    List<String> realNames = new ArrayList<String>();
    List<String> types = new ArrayList<String>();
    List<Integer> sizes = new ArrayList<Integer>();
    private final String identifier;
    private final transient List<DecimalFormat> formats = new ArrayList<DecimalFormat>();
    private final List<Integer> scales = new ArrayList<Integer>();
    private transient Runnable addRef;
    private transient Runnable release;
    private transient ThrowingRunnable close;

    SelectedResultSetTable(ResultSetTableModel model) {
        this.rows = ResultTableHandler.getSelectedRows(model);
        this.cols = ResultTableHandler.getSelectedColumns(model);
        this.convertedVector = model::getValueAt;
        this.stringWector = model::getValueForDisplay;
        int i = 0;
        while (i < this.cols.size()) {
            Integer columnIndex = this.cols.get(i);
            this.columnClazz.add(model.getColumnClass(columnIndex));
            this.realNames.add(model.getColumnName(columnIndex));
            this.columnTypes.add(model.getFieldType(columnIndex));
            this.scales.add(model.getScale(columnIndex));
            this.formats.add(model.getFormatForColumn(columnIndex));
            this.types.add(model.getColumnType(columnIndex));
            this.sizes.add(model.getSize(columnIndex));
            ++i;
        }
        this.identifier = model.getIdentifier();
        this.addRef = model::AddRef;
        this.release = model::Release;
        this.close = model::close;
    }

    public void reconstruct(IResultSetTable rs) {
        this.convertedVector = rs::getValueAt;
        this.stringWector = rs::getValueForDisplay;
        this.addRef = rs::AddRef;
        this.release = rs::Release;
        this.close = rs::close;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.realNames.get(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.cols.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClazz.get(columnIndex);
    }

    @Override
    public FieldType getFieldType(int column) {
        return this.columnTypes.get(column);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Integer getScale(int column) {
        return this.scales.get(column);
    }

    @Override
    public DecimalFormat getFormatForColumn(int column) {
        return this.formats.get(column);
    }

    @Override
    public IResultSetTable getSelectedSnapshot() {
        return this;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.convertedVector.apply(this.rows.get(row), this.cols.get(column));
    }

    @Override
    public String getValueForDisplay(int row, int column) {
        return this.stringWector.apply(this.rows.get(row), this.cols.get(column));
    }

    @Override
    public void close() throws IOException {
        if (this.close != null) {
            this.close.run();
        }
    }

    @Override
    public void AddRef() {
        if (this.addRef != null) {
            this.addRef.run();
        }
    }

    @Override
    public void Release() {
        if (this.release != null) {
            this.release.run();
        }
    }

    @Override
    public String getColumnType(int column) {
        return this.types.get(column);
    }

    @Override
    public int getSize(int column) {
        return this.sizes.get(column);
    }
}

