/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.sigge.dbrunner.SQLRunnerException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class ResultSetPresenterHelper {
    public static String getExceptionTraceFromException(Exception exception) {
        if (exception instanceof SQLServerException) {
            SQLServerException error = (SQLServerException)exception;
            String exceptionError = "State: " + error.getSQLState() + ", error code: " + error.getErrorCode();
            if (error.getSQLServerError() != null) {
                exceptionError = String.valueOf(exceptionError) + ", Line: " + error.getSQLServerError().getLineNumber() + ", ProcName:" + error.getSQLServerError().getProcedureName();
            }
            exceptionError = String.valueOf(exceptionError) + "\n" + error.getMessage();
            return exceptionError;
        }
        if (exception instanceof SQLRunnerException) {
            SQLRunnerException error = (SQLRunnerException)exception;
            String exceptionError = "State: " + error.getSQLState() + ", error code: " + error.getErrorCode();
            if (error.getErrorSeverity() > 0) {
                exceptionError = String.valueOf(exceptionError) + ", Line: " + error.getLineNumber() + ", ProcName:" + error.getProcedureName();
            }
            exceptionError = String.valueOf(exceptionError) + "\n" + error.getMessage();
            return exceptionError;
        }
        if (exception instanceof SQLException) {
            SQLException error = (SQLException)exception;
            return String.valueOf(error.getMessage()) + "\nState: " + error.getSQLState() + ", error code: " + error.getErrorCode();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter sw = new PrintWriter(stringWriter);
        exception.printStackTrace(sw);
        return stringWriter.toString();
    }
}

