/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.editors.FontUtils;
import com.sigge.filerunner.view.results.EditableResultSetTableModel;
import com.sigge.filerunner.view.results.ResultSetTableRenderer;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ResultSetEditableTableRenderer
extends ResultSetTableRenderer {
    private final EditableResultSetTableModel editableModel;

    public ResultSetEditableTableRenderer(EditableResultSetTableModel model) {
        super(model);
        this.editableModel = model;
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel jl = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int modelColumn = table.convertColumnIndexToModel(column);
        if (modelColumn >= 0) {
            int modelRow = row >= 0 ? table.convertRowIndexToModel(row) : -1;
            Boolean nullable = this.editableModel.isNullable(column);
            if ((nullable == null || !nullable.booleanValue()) && this.editableModel.isCellEditable(modelRow, modelColumn) && value == null) {
                jl.setBorder(BorderFactory.createLineBorder(Color.RED));
            }
            if (!this.editableModel.isCellEditable(modelRow, modelColumn)) {
                jl.setFont(FontUtils.getInactiveFont(jl));
                if (!isSelected) {
                    jl.setBackground(table.getTableHeader().getBackground());
                }
            }
        }
        return jl;
    }
}

