/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.sort.DefaultSortController;
import org.jdesktop.swingx.sort.SortUtils;
import org.jdesktop.swingx.util.Contract;

public abstract class MergeSortController<M extends TableModel>
extends DefaultSortController<M> {
    private boolean sortsOnUpdates;
    private Row[] viewToModel;
    private static final int INSERTIONSORT_THRESHOLD = 7;
    private int[] modelToView;
    private Comparator[] comparators;
    private boolean[] isSortable;
    private RowSorter.SortKey[] cachedSortKeys;
    private Comparator[] sortComparators;
    private RowFilter<? super M, ? super Integer> filter;
    private FilterEntry filterEntry;
    private List<RowSorter.SortKey> sortKeys;
    private boolean[] useToString;
    private List<SortOrder> sortCycle;
    private boolean sorted;
    private int maxSortKeys;
    private int modelRowCount;
    private M tableModel;
    private boolean useMergeSort;

    public MergeSortController() {
        this(true);
    }

    public MergeSortController(boolean useMergeSort) {
        this.useMergeSort = useMergeSort;
        this.sortKeys = Collections.emptyList();
        this.maxSortKeys = 3;
    }

    public void setModel(M model) {
        this.tableModel = model;
        this.setModelWrapper(new TableRowSorterModelWrapper());
    }

    public void setSortable(int column, boolean sortable) {
        this.checkColumn(column);
        if (this.isSortable == null) {
            this.isSortable = new boolean[this.getModelWrapper().getColumnCount()];
            int i = this.isSortable.length - 1;
            while (i >= 0) {
                this.isSortable[i] = true;
                --i;
            }
        }
        this.isSortable[column] = sortable;
    }

    public boolean isSortable(int column) {
        this.checkColumn(column);
        return this.isSortable == null ? true : this.isSortable[column];
    }

    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        List<RowSorter.SortKey> old = this.sortKeys;
        if (sortKeys != null && sortKeys.size() > 0) {
            int max = this.getModelWrapper().getColumnCount();
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < max) continue;
                throw new IllegalArgumentException("Invalid SortKey");
            }
            this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(sortKeys));
        } else {
            this.sortKeys = Collections.emptyList();
        }
        if (!this.sortKeys.equals(old)) {
            this.fireSortOrderChanged();
            if (this.viewToModel == null) {
                this.sort();
            } else {
                this.sortExistingData();
            }
        }
    }

    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    public void setMaxSortKeys(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Invalid max");
        }
        this.maxSortKeys = max;
    }

    public int getMaxSortKeys() {
        return this.maxSortKeys;
    }

    public int convertRowIndexToView(int index) {
        if (this.modelToView == null) {
            if (index < 0 || index >= this.getModelWrapper().getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid index");
            }
            return index;
        }
        return this.modelToView[index];
    }

    public int convertRowIndexToModel(int index) {
        if (this.viewToModel == null) {
            if (index < 0 || index >= this.getModelWrapper().getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid index");
            }
            return index;
        }
        return this.viewToModel[index].modelIndex;
    }

    public void setSortsOnUpdates(boolean sortsOnUpdates) {
        this.sortsOnUpdates = sortsOnUpdates;
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setRowFilter(RowFilter<? super M, ? super Integer> filter) {
        this.filter = filter;
        this.sort();
    }

    public RowFilter<? super M, ? super Integer> getRowFilter() {
        return this.filter;
    }

    public void toggleSortOrder(int column) {
        RowSorter.SortKey sortKey;
        this.checkColumn(column);
        if (!this.isSortable(column)) {
            return;
        }
        SortOrder firstInCycle = this.getFirstInCycle();
        if (firstInCycle == null) {
            return;
        }
        List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        if (keys.indexOf(sortKey = SortUtils.getFirstSortKeyForColumn(keys, (int)column)) == 0) {
            keys.set(0, new RowSorter.SortKey(column, this.getNextInCycle(sortKey.getSortOrder())));
        } else {
            keys.remove(sortKey);
            keys.add(0, new RowSorter.SortKey(column, this.getFirstInCycle()));
        }
        if (keys.size() > this.getMaxSortKeys()) {
            keys = keys.subList(0, this.getMaxSortKeys());
        }
        this.setSortKeys(keys);
    }

    private SortOrder getNextInCycle(SortOrder current) {
        int pos = this.sortCycle.indexOf((Object)current);
        if (pos < 0) {
            return this.getFirstInCycle();
        }
        if (++pos >= this.sortCycle.size()) {
            pos = 0;
        }
        return this.sortCycle.get(pos);
    }

    private SortOrder getFirstInCycle() {
        return this.sortCycle.size() > 0 ? this.sortCycle.get(0) : null;
    }

    public void setSortOrder(int column, SortOrder sortOrder) {
        if (!this.isSortable(column)) {
            return;
        }
        RowSorter.SortKey replace = new RowSorter.SortKey(column, sortOrder);
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        SortUtils.removeFirstSortKeyForColumn(keys, (int)column);
        keys.add(0, replace);
        this.setSortKeys(keys);
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey key) {
        if (key.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
        }
        return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
    }

    private boolean isUnsorted() {
        List<RowSorter.SortKey> keys = this.getSortKeys();
        int keySize = keys.size();
        return keySize == 0 || keys.get(0).getSortOrder() == SortOrder.UNSORTED;
    }

    private void sortExistingData() {
        int[] lastViewToModel = this.getViewToModelAsInts(this.viewToModel);
        this.updateUseToString();
        this.cacheSortKeys(this.getSortKeys());
        if (this.isUnsorted()) {
            if (this.getRowFilter() == null) {
                this.viewToModel = null;
                this.modelToView = null;
            } else {
                int included = 0;
                int i = 0;
                while (i < this.modelToView.length) {
                    if (this.modelToView[i] != -1) {
                        this.viewToModel[included].modelIndex = i;
                        this.modelToView[i] = included++;
                    }
                    ++i;
                }
            }
        } else {
            if (this.useMergeSort) {
                MergeSortController.legacyMergeSort(this.viewToModel);
            } else {
                Arrays.sort(this.viewToModel);
            }
            this.setModelToViewFromViewToModel(false);
        }
        this.fireRowSorterChanged(lastViewToModel);
    }

    private static void legacyMergeSort(Object[] a) {
        Object[] aux = (Object[])a.clone();
        MergeSortController.mergeSort(aux, a, 0, a.length, 0);
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 7) {
            int i = low;
            while (i < high) {
                int j = i;
                while (j > low && ((Comparable)dest[j - 1]).compareTo(dest[j]) > 0) {
                    MergeSortController.swap(dest, j, j - 1);
                    --j;
                }
                ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        MergeSortController.mergeSort(dest, src, low, mid, -off);
        MergeSortController.mergeSort(dest, src, mid, high, -off);
        if (((Comparable)src[mid - 1]).compareTo(src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && ((Comparable)src[p]).compareTo(src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sort() {
        this.sorted = true;
        int[] lastViewToModel = this.getViewToModelAsInts(this.viewToModel);
        this.updateUseToString();
        if (this.isUnsorted()) {
            this.cachedSortKeys = new RowSorter.SortKey[0];
            if (this.getRowFilter() == null) {
                if (this.viewToModel == null) return;
                this.viewToModel = null;
                this.modelToView = null;
            } else {
                this.initializeFilteredMapping();
            }
        } else {
            this.cacheSortKeys(this.getSortKeys());
            if (this.getRowFilter() != null) {
                this.initializeFilteredMapping();
            } else {
                this.createModelToView(this.getModelWrapper().getRowCount());
                this.createViewToModel(this.getModelWrapper().getRowCount());
            }
            if (this.useMergeSort) {
                MergeSortController.legacyMergeSort(this.viewToModel);
            } else {
                Arrays.sort(this.viewToModel);
            }
            this.setModelToViewFromViewToModel(false);
        }
        this.fireRowSorterChanged(lastViewToModel);
    }

    private void updateUseToString() {
        int i = this.getModelWrapper().getColumnCount();
        if (this.useToString == null || this.useToString.length != i) {
            this.useToString = new boolean[i];
        }
        --i;
        while (i >= 0) {
            this.useToString[i] = this.useToString(i);
            --i;
        }
    }

    public SortOrder getSortOrder(int column) {
        RowSorter.SortKey key = SortUtils.getFirstSortKeyForColumn(this.getSortKeys(), (int)column);
        return key != null ? key.getSortOrder() : SortOrder.UNSORTED;
    }

    public void resetSortOrders() {
        if (!this.isSortable()) {
            return;
        }
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        int i = keys.size() - 1;
        while (i >= 0) {
            RowSorter.SortKey sortKey = (RowSorter.SortKey)keys.get(i);
            if (this.isSortable(sortKey.getColumn())) {
                keys.remove(sortKey);
            }
            --i;
        }
        this.setSortKeys(keys);
    }

    public SortOrder[] getSortOrderCycle() {
        return this.sortCycle.toArray(new SortOrder[0]);
    }

    public void setSortOrderCycle(SortOrder ... cycle) {
        Contract.asNotNull((Object)cycle, (String)"Elements of SortOrderCycle must not be null");
        this.sortCycle = Arrays.asList(cycle);
    }

    private void initializeFilteredMapping() {
        int rowCount = this.getModelWrapper().getRowCount();
        int excludedCount = 0;
        this.createModelToView(rowCount);
        int i = 0;
        while (i < rowCount) {
            if (this.include(i)) {
                this.modelToView[i] = i - excludedCount;
            } else {
                this.modelToView[i] = -1;
                ++excludedCount;
            }
            ++i;
        }
        this.createViewToModel(rowCount - excludedCount);
        i = 0;
        int j = 0;
        while (i < rowCount) {
            if (this.modelToView[i] != -1) {
                this.viewToModel[j++].modelIndex = i;
            }
            ++i;
        }
    }

    private void createModelToView(int rowCount) {
        if (this.modelToView == null || this.modelToView.length != rowCount) {
            this.modelToView = new int[rowCount];
        }
    }

    private void createViewToModel(int rowCount) {
        int recreateFrom = 0;
        if (this.viewToModel != null) {
            recreateFrom = Math.min(rowCount, this.viewToModel.length);
            if (this.viewToModel.length != rowCount) {
                Row[] oldViewToModel = this.viewToModel;
                this.viewToModel = new Row[rowCount];
                System.arraycopy(oldViewToModel, 0, this.viewToModel, 0, recreateFrom);
            }
        } else {
            this.viewToModel = new Row[rowCount];
        }
        int i = 0;
        while (i < recreateFrom) {
            this.viewToModel[i].modelIndex = i;
            ++i;
        }
        i = recreateFrom;
        while (i < rowCount) {
            this.viewToModel[i] = new Row(this, i);
            ++i;
        }
    }

    private void cacheSortKeys(List<? extends RowSorter.SortKey> keys) {
        int keySize = keys.size();
        this.sortComparators = new Comparator[keySize];
        int i = 0;
        while (i < keySize) {
            this.sortComparators[i] = this.getComparator0(keys.get(i).getColumn());
            ++i;
        }
        this.cachedSortKeys = keys.toArray(new RowSorter.SortKey[keySize]);
    }

    protected boolean useToString(int column) {
        return this.getComparator(column) == null;
    }

    private void setModelToViewFromViewToModel(boolean unsetFirst) {
        int i;
        if (unsetFirst) {
            i = this.modelToView.length - 1;
            while (i >= 0) {
                this.modelToView[i] = -1;
                --i;
            }
        }
        i = this.viewToModel.length - 1;
        while (i >= 0) {
            this.modelToView[this.viewToModel[i].modelIndex] = i;
            --i;
        }
    }

    private int[] getViewToModelAsInts(Row[] viewToModel) {
        if (viewToModel != null) {
            int[] viewToModelI = new int[viewToModel.length];
            int i = viewToModel.length - 1;
            while (i >= 0) {
                viewToModelI[i] = viewToModel[i].modelIndex;
                --i;
            }
            return viewToModelI;
        }
        return new int[0];
    }

    public void setComparator(int column, Comparator<?> comparator) {
        this.checkColumn(column);
        if (this.comparators == null) {
            this.comparators = new Comparator[this.getModelWrapper().getColumnCount()];
        }
        this.comparators[column] = comparator;
    }

    public Comparator<?> getComparator(int column) {
        this.checkColumn(column);
        if (this.comparators != null) {
            return this.comparators[column];
        }
        return null;
    }

    private Comparator getComparator0(int column) {
        Comparator<?> comparator = this.getComparator(column);
        if (comparator != null) {
            return comparator;
        }
        return Collator.getInstance();
    }

    private RowFilter.Entry<M, Integer> getFilterEntry(int modelIndex) {
        if (this.filterEntry == null) {
            this.filterEntry = new FilterEntry();
        }
        this.filterEntry.modelIndex = modelIndex;
        return this.filterEntry;
    }

    public int getViewRowCount() {
        if (this.viewToModel != null) {
            return this.viewToModel.length;
        }
        return this.getModelWrapper().getRowCount();
    }

    public int getModelRowCount() {
        return this.getModelWrapper().getRowCount();
    }

    private void allChanged() {
        this.modelToView = null;
        this.viewToModel = null;
        this.comparators = null;
        this.isSortable = null;
        if (this.isUnsorted()) {
            this.sort();
        } else {
            this.setSortKeys(null);
        }
    }

    public void modelStructureChanged() {
        this.allChanged();
        this.modelRowCount = this.getModelWrapper().getRowCount();
    }

    public void allRowsChanged() {
        this.modelRowCount = this.getModelWrapper().getRowCount();
        this.sort();
    }

    public void rowsInserted(int firstRow, int endRow) {
        this.checkAgainstModel(firstRow, endRow);
        int newModelRowCount = this.getModelWrapper().getRowCount();
        if (endRow >= newModelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        this.modelRowCount = newModelRowCount;
        if (this.shouldOptimizeChange(firstRow, endRow)) {
            this.rowsInserted0(firstRow, endRow);
        }
    }

    public void rowsDeleted(int firstRow, int endRow) {
        this.checkAgainstModel(firstRow, endRow);
        if (firstRow >= this.modelRowCount || endRow >= this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        this.modelRowCount = this.getModelWrapper().getRowCount();
        if (this.shouldOptimizeChange(firstRow, endRow)) {
            this.rowsDeleted0(firstRow, endRow);
        }
    }

    public void rowsUpdated(int firstRow, int endRow) {
        this.checkAgainstModel(firstRow, endRow);
        if (firstRow >= this.modelRowCount || endRow >= this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        if (this.getSortsOnUpdates()) {
            if (this.shouldOptimizeChange(firstRow, endRow)) {
                this.rowsUpdated0(firstRow, endRow);
            }
        } else {
            this.sorted = false;
        }
    }

    public void rowsUpdated(int firstRow, int endRow, int column) {
        this.checkColumn(column);
        this.rowsUpdated(firstRow, endRow);
    }

    private void checkAgainstModel(int firstRow, int endRow) {
        if (firstRow > endRow || firstRow < 0 || endRow < 0 || firstRow > this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
    }

    private boolean include(int row) {
        RowFilter<M, Integer> filter = this.getRowFilter();
        if (filter != null) {
            return filter.include(this.getFilterEntry(row));
        }
        return true;
    }

    private int compare(int model1, int model2) {
        int counter = 0;
        while (counter < this.cachedSortKeys.length) {
            int result;
            int column = this.cachedSortKeys[counter].getColumn();
            SortOrder sortOrder = this.cachedSortKeys[counter].getSortOrder();
            if (sortOrder == SortOrder.UNSORTED) {
                result = model1 - model2;
            } else {
                Object v2;
                Object v1;
                if (this.useToString[column]) {
                    v1 = this.getModelWrapper().getStringValueAt(model1, column);
                    v2 = this.getModelWrapper().getStringValueAt(model2, column);
                } else {
                    v1 = this.getModelWrapper().getValueAt(model1, column);
                    v2 = this.getModelWrapper().getValueAt(model2, column);
                }
                result = v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : this.sortComparators[counter].compare(v1, v2));
                if (sortOrder == SortOrder.DESCENDING) {
                    result *= -1;
                }
            }
            if (result != 0) {
                return result;
            }
            ++counter;
        }
        return model1 - model2;
    }

    private boolean isTransformed() {
        return this.viewToModel != null;
    }

    private void insertInOrder(List<Row> toAdd, Row[] current) {
        int last = 0;
        int max = toAdd.size();
        int i = 0;
        while (i < max) {
            int index = Arrays.binarySearch(current, toAdd.get(i));
            if (index < 0) {
                index = -1 - index;
            }
            System.arraycopy(current, last, this.viewToModel, last + i, index - last);
            this.viewToModel[index + i] = toAdd.get(i);
            last = index;
            ++i;
        }
        System.arraycopy(current, last, this.viewToModel, last + max, current.length - last);
    }

    private boolean shouldOptimizeChange(int firstRow, int lastRow) {
        if (!this.isTransformed()) {
            return false;
        }
        if (!this.sorted || lastRow - firstRow > this.viewToModel.length / 10) {
            this.sort();
            return false;
        }
        return true;
    }

    private void rowsInserted0(int firstRow, int lastRow) {
        int[] oldViewToModel = this.getViewToModelAsInts(this.viewToModel);
        int delta = lastRow - firstRow + 1;
        ArrayList<Row> added = new ArrayList<Row>(delta);
        int i = firstRow;
        while (i <= lastRow) {
            if (this.include(i)) {
                added.add(new Row(this, i));
            }
            ++i;
        }
        i = this.modelToView.length - 1;
        while (i >= firstRow) {
            int viewIndex = this.modelToView[i];
            if (viewIndex != -1) {
                this.viewToModel[viewIndex].modelIndex += delta;
            }
            --i;
        }
        if (added.size() > 0) {
            Collections.sort(added);
            Row[] lastViewToModel = this.viewToModel;
            this.viewToModel = new Row[this.viewToModel.length + added.size()];
            this.insertInOrder(added, lastViewToModel);
        }
        this.createModelToView(this.getModelWrapper().getRowCount());
        this.setModelToViewFromViewToModel(true);
        this.fireRowSorterChanged(oldViewToModel);
    }

    private void rowsDeleted0(int firstRow, int lastRow) {
        int viewIndex;
        int[] oldViewToModel = this.getViewToModelAsInts(this.viewToModel);
        int removedFromView = 0;
        int i = firstRow;
        while (i <= lastRow) {
            viewIndex = this.modelToView[i];
            if (viewIndex != -1) {
                ++removedFromView;
                this.viewToModel[viewIndex] = null;
            }
            ++i;
        }
        int delta = lastRow - firstRow + 1;
        i = this.modelToView.length - 1;
        while (i > lastRow) {
            viewIndex = this.modelToView[i];
            if (viewIndex != -1) {
                this.viewToModel[viewIndex].modelIndex -= delta;
            }
            --i;
        }
        if (removedFromView > 0) {
            Row[] newViewToModel = new Row[this.viewToModel.length - removedFromView];
            int newIndex = 0;
            int last = 0;
            i = 0;
            while (i < this.viewToModel.length) {
                if (this.viewToModel[i] == null) {
                    System.arraycopy(this.viewToModel, last, newViewToModel, newIndex, i - last);
                    newIndex += i - last;
                    last = i + 1;
                }
                ++i;
            }
            System.arraycopy(this.viewToModel, last, newViewToModel, newIndex, this.viewToModel.length - last);
            this.viewToModel = newViewToModel;
        }
        this.createModelToView(this.getModelWrapper().getRowCount());
        this.setModelToViewFromViewToModel(true);
        this.fireRowSorterChanged(oldViewToModel);
    }

    private void rowsUpdated0(int firstRow, int lastRow) {
        int[] oldViewToModel = this.getViewToModelAsInts(this.viewToModel);
        int delta = lastRow - firstRow + 1;
        if (this.getRowFilter() == null) {
            Object[] updated = new Row[delta];
            int j = 0;
            int i = firstRow;
            while (i <= lastRow) {
                updated[j] = this.viewToModel[this.modelToView[i]];
                ++i;
                ++j;
            }
            if (this.useMergeSort) {
                MergeSortController.legacyMergeSort(updated);
            } else {
                Arrays.sort(updated);
            }
            Row[] intermediary = new Row[this.viewToModel.length - delta];
            i = 0;
            j = 0;
            while (i < this.viewToModel.length) {
                int modelIndex = this.viewToModel[i].modelIndex;
                if (modelIndex < firstRow || modelIndex > lastRow) {
                    intermediary[j++] = this.viewToModel[i];
                }
                ++i;
            }
            this.insertInOrder(Arrays.asList(updated), intermediary);
            this.setModelToViewFromViewToModel(false);
        } else {
            ArrayList<Row> updated = new ArrayList<Row>(delta);
            int newlyVisible = 0;
            int newlyHidden = 0;
            int effected = 0;
            int i = firstRow;
            while (i <= lastRow) {
                if (this.modelToView[i] == -1) {
                    if (this.include(i)) {
                        updated.add(new Row(this, i));
                        ++newlyVisible;
                    }
                } else {
                    if (!this.include(i)) {
                        ++newlyHidden;
                    } else {
                        updated.add(this.viewToModel[this.modelToView[i]]);
                    }
                    this.modelToView[i] = -2;
                    ++effected;
                }
                ++i;
            }
            Collections.sort(updated);
            Row[] intermediary = new Row[this.viewToModel.length - effected];
            i = 0;
            int j = 0;
            while (i < this.viewToModel.length) {
                int modelIndex = this.viewToModel[i].modelIndex;
                if (this.modelToView[modelIndex] != -2) {
                    intermediary[j++] = this.viewToModel[i];
                }
                ++i;
            }
            if (newlyVisible != newlyHidden) {
                this.viewToModel = new Row[this.viewToModel.length + newlyVisible - newlyHidden];
            }
            this.insertInOrder(updated, intermediary);
            this.setModelToViewFromViewToModel(true);
        }
        this.fireRowSorterChanged(oldViewToModel);
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    private class FilterEntry
    extends RowFilter.Entry<M, Integer> {
        int modelIndex;

        private FilterEntry() {
        }

        @Override
        public M getModel() {
            return (TableModel)MergeSortController.this.getModelWrapper().getModel();
        }

        @Override
        public int getValueCount() {
            return MergeSortController.this.getModelWrapper().getColumnCount();
        }

        @Override
        public Object getValue(int index) {
            return MergeSortController.this.getModelWrapper().getValueAt(this.modelIndex, index);
        }

        @Override
        public String getStringValue(int index) {
            return MergeSortController.this.getModelWrapper().getStringValueAt(this.modelIndex, index);
        }

        @Override
        public Integer getIdentifier() {
            return (Integer)MergeSortController.this.getModelWrapper().getIdentifier(this.modelIndex);
        }
    }

    private static class Row
    implements Comparable<Row> {
        private final MergeSortController sorter;
        int modelIndex;

        public Row(MergeSortController sorter, int index) {
            this.sorter = sorter;
            this.modelIndex = index;
        }

        @Override
        public int compareTo(Row o) {
            return this.sorter.compare(this.modelIndex, o.modelIndex);
        }
    }

    private class TableRowSorterModelWrapper
    extends DefaultRowSorter.ModelWrapper<M, Integer> {
        private TableRowSorterModelWrapper() {
        }

        @Override
        public M getModel() {
            return MergeSortController.this.tableModel;
        }

        @Override
        public int getColumnCount() {
            return MergeSortController.this.tableModel == null ? 0 : MergeSortController.this.tableModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return MergeSortController.this.tableModel == null ? 0 : MergeSortController.this.tableModel.getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return MergeSortController.this.tableModel.getValueAt(row, column);
        }

        @Override
        public String getStringValueAt(int row, int column) {
            return MergeSortController.this.getStringValueProvider().getStringValue(row, column).getString(this.getValueAt(row, column));
        }

        @Override
        public Integer getIdentifier(int index) {
            return index;
        }
    }
}

