/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.view.core.AdvancedStringEditor;
import com.sigge.filerunner.view.editors.NumericEditor;
import com.sigge.filerunner.view.results.AColumnHandler;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.ResultSetEditableTableRenderer;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.ResultSetTableRenderer;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import microsoft.sql.DateTimeOffset;
import org.jdesktop.swingx.table.DatePickerCellEditor;

public class EditableResultSetTableModel
extends ResultSetTableModel {
    private ResultSet rs;
    private final Map<Integer, Map<Integer, Object>> changedValues = new HashMap<Integer, Map<Integer, Object>>();
    private final Map<Integer, Boolean> nullable = new HashMap<Integer, Boolean>();
    private final Set<Integer> uneditableColumns = new HashSet<Integer>();
    private final boolean useAddRow;
    private final boolean deletable;
    private final int newRowIndex;
    private int maxRowIndex;

    public EditableResultSetTableModel(ResultSet rs, SQLOptions sqlOptions) throws SQLException {
        this(rs, sqlOptions, l -> {});
    }

    public EditableResultSetTableModel(ResultSet rs, SQLOptions sqlOptions, Consumer<Long> rowConsumer) throws SQLException {
        super(rs, sqlOptions, rowConsumer);
        this.useAddRow = true;
        this.deletable = false;
        ResultSetMetaData meta = rs.getMetaData();
        ResultSetEditableTableRenderer rr = new ResultSetEditableTableRenderer(this);
        int column = 0;
        while (column < this.getColumnCount()) {
            int nullable;
            if (meta.isAutoIncrement(column + 1) || meta.isReadOnly(column + 1)) {
                this.uneditableColumns.add(column);
            }
            Boolean nullableColumn = (nullable = meta.isNullable(column + 1)) == 0 ? Boolean.FALSE : (nullable == 1 ? Boolean.TRUE : null);
            this.nullable.put(column, nullableColumn);
            TableColumn tc = this.getTableColumnModel().getColumn(column);
            tc.setCellRenderer(rr);
            FieldType fieldType = this.getFieldType(column);
            switch (fieldType) {
                case SQLINTEGER: 
                case SQLFLOAT: 
                case SQLLONG: 
                case SQLBOOLEAN: {
                    tc.setCellEditor(new NumericEditor((ResultSetTableRenderer)tc.getCellRenderer(), fieldType));
                    break;
                }
                case SQLDATE: {
                    tc.setCellEditor((TableCellEditor)new DatePickerCellEditor());
                    break;
                }
                case SQLDATEWITHZONE: {
                    tc.setCellEditor((TableCellEditor)new DatePickerCellEditor());
                    break;
                }
                case SQLSTRING: 
                case SQLXMLSTRING: {
                    tc.setCellEditor(new AdvancedStringEditor(nullableColumn == null || nullableColumn != false, rr));
                    break;
                }
                default: {
                    this.uneditableColumns.add(column);
                }
            }
            ++column;
        }
        this.maxRowIndex = this.newRowIndex = ((AColumnHandler)this.DATA.get(0)).getRowCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Map<Integer, Object> map = this.changedValues.get(row);
        if (map != null) {
            Object ox = map.get(column);
            if (ox == this) {
                return null;
            }
            if (ox != null) {
                return ox;
            }
        }
        if (row >= this.newRowIndex) {
            return null;
        }
        return super.getValueAt(row, column);
    }

    public boolean isAddRow(int rowIndex) {
        return this.useAddRow && rowIndex == this.maxRowIndex;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return !this.uneditableColumns.contains(column);
    }

    @Override
    protected void postProcessResultSet(ResultSet rs) throws SQLException {
        this.rs = rs;
    }

    private boolean isNewRowReady() {
        int i = 0;
        while (i < this.getColumnCount()) {
            Boolean nullCheck;
            Object value = this.changedValues.get(this.maxRowIndex).get(i);
            if ((value == null || value == this) && (nullCheck = (Boolean)this.nullable.getOrDefault(i, null)) != null && !nullCheck.booleanValue() && this.isCellEditable(this.maxRowIndex, i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addNewRow(int row, int column) {
        ++this.maxRowIndex;
        this.fireTableRowsInserted(this.maxRowIndex, this.maxRowIndex);
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public int getRowCount() {
        return this.maxRowIndex + 1;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        block21: {
            try {
                boolean insertRow = false;
                boolean changedValue = false;
                if (this.isAddRow(row)) {
                    insertRow = true;
                    this.rs.moveToInsertRow();
                } else {
                    this.rs.first();
                    if (row != 0) {
                        this.rs.relative(row);
                    }
                }
                int sqlColumnIndex = column + 1;
                if (aValue == null) {
                    this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, this);
                    this.rs.updateObject(sqlColumnIndex, null);
                    changedValue = true;
                } else {
                    Object prevValue = this.getValueAt(row, column);
                    switch (this.getFieldType(column)) {
                        case SQLBOOLEAN: {
                            int intValue = ((Number)aValue).intValue();
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, intValue);
                            if (Objects.equals(prevValue, intValue)) break;
                            this.rs.updateBoolean(sqlColumnIndex, intValue == 1);
                            changedValue = true;
                            break;
                        }
                        case SQLDATE: {
                            Timestamp x = new Timestamp(((Date)aValue).getTime());
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, x);
                            if (Objects.equals(prevValue, x)) break;
                            this.rs.updateTimestamp(sqlColumnIndex, x);
                            changedValue = true;
                            break;
                        }
                        case SQLDATEWITHZONE: {
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, aValue);
                            if (Objects.equals(prevValue, aValue)) break;
                            ((SQLServerResultSet)this.rs).updateDateTimeOffset(sqlColumnIndex, (DateTimeOffset)aValue);
                            changedValue = true;
                            break;
                        }
                        case SQLINTEGER: {
                            int intValue2 = ((Number)aValue).intValue();
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, intValue2);
                            if (Objects.equals(prevValue, intValue2)) break;
                            this.rs.updateInt(sqlColumnIndex, intValue2);
                            changedValue = true;
                            break;
                        }
                        case SQLFLOAT: {
                            double doubleValue = ((Number)aValue).doubleValue();
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, doubleValue);
                            if (Objects.equals(prevValue, doubleValue)) break;
                            this.rs.updateDouble(sqlColumnIndex, doubleValue);
                            changedValue = true;
                            break;
                        }
                        case SQLLONG: {
                            long longValue = ((Number)aValue).longValue();
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, longValue);
                            if (Objects.equals(prevValue, longValue)) break;
                            this.rs.updateLong(sqlColumnIndex, longValue);
                            changedValue = true;
                            break;
                        }
                        case SQLSTRING: 
                        case SQLXMLSTRING: {
                            this.changedValues.computeIfAbsent(row, e -> new HashMap()).put(column, aValue);
                            if (Objects.equals(prevValue, aValue)) break;
                            this.rs.updateString(sqlColumnIndex, (String)aValue);
                            changedValue = true;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unsupported set");
                        }
                    }
                }
                if (!changedValue) break block21;
                if (!insertRow) {
                    this.rs.updateRow();
                } else if (this.isNewRowReady()) {
                    try {
                        this.rs.insertRow();
                        this.addNewRow(row, column);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Couldn't add row to database due to following error:" + ex.getMessage(), "Error while adding data", 0);
                    }
                }
                this.fireTableCellUpdated(row, column);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error setting field for row: " + row + ", col: " + column + ", rs: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

