/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.MenuAction;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.Runner;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.RunnerPresenter;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.IMenuItem;
import com.sigge.filerunner.view.menu.Menu;
import com.sigge.filerunner.view.menu.MenuItem;
import com.sigge.filerunner.view.menu.MenuItemBuilder;
import com.sigge.filerunner.view.menu.MenuItemGroup;
import com.sigge.filerunner.view.menu.MenuType;
import com.sigge.filerunner.view.tools.ExternalTool;
import com.sigge.filerunner.view.tools.NewSnippetView;
import com.sigge.filerunner.view.tools.SQLTool;
import com.sigge.filerunner.view.tools.ToolHandler;
import com.sigge.filerunner.view.tools.ToolRunner;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

@Singleton
public class ToolsMenu
implements Provider<IMenu> {
    private final RunnerPresenter runnerPresenter;
    private final ToolRunner toolRunner;
    private final JFrame mainFrame;

    @Inject
    ToolsMenu(RunnerPresenter runnerPresenter, ToolRunner toolRunner, @Named(value="mainFrame") JFrame mainFrame) {
        this.runnerPresenter = runnerPresenter;
        this.toolRunner = toolRunner;
        this.mainFrame = mainFrame;
    }

    public IMenu get() {
        Menu menu = new Menu(MenuType.TOOLS);
        this.rebuildToolMenu(menu);
        return menu;
    }

    private void rebuildToolMenu(IMenu menu) {
        menu.clear();
        ArrayList<IMenuItem> mainItems = new ArrayList<IMenuItem>();
        mainItems.add(new MenuItem((JMenuItem)new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("External tools...").action(l -> this.handleExternalTools(menu)).icon(IconUtils.getSmallIcon("gear_run.png")).build()));
        mainItems.add(new MenuItem((JMenuItem)new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("SQL tools...").action(l -> this.handleSQLTools(menu)).icon(IconUtils.getSmallIcon("table_sql_run.png")).build()));
        mainItems.add(new MenuItem((JMenuItem)new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Save snippet...").action(l -> this.addSnippet()).icon(IconUtils.getSmallIcon("heart_add.png")).build()));
        MenuItemGroup group = new MenuItemGroup(mainItems);
        menu.addItemGroup(group, 0);
        Config c = ConfigHandler.getConfig();
        List<ExternalTool> externals = c.getExternalTools();
        List<SQLTool> sqls = c.getSqlTools();
        if (externals.size() == 0 && sqls.size() == 0) {
            menu.triggerReload();
            return;
        }
        ArrayList<IMenuItem> toolItems = new ArrayList<IMenuItem>();
        for (ExternalTool tool : externals) {
            KeyStroke ks = null;
            if (StringUtils.isNotEmpty(tool.getBinding())) {
                ks = KeyStroke.getKeyStroke(tool.getBinding());
            }
            MenuAction mna = new MenuAction(tool.getTitle(), null, null, ks, () -> this.toolRunner.runTool(tool));
            toolItems.add(new MenuItem(new JMenuItem(mna)));
        }
        MenuItemGroup mp = new MenuItemGroup(toolItems);
        ArrayList<IMenuItem> sqlItems = new ArrayList<IMenuItem>();
        for (SQLTool sqltool : sqls) {
            KeyStroke ks = null;
            if (StringUtils.isNotEmpty(sqltool.getBinding())) {
                ks = KeyStroke.getKeyStroke(sqltool.getBinding());
            }
            MenuAction mna = new MenuAction(sqltool.getTitle(), null, null, ks, () -> this.runnerPresenter.runSQLTool(sqltool));
            JMenuItem jm = new JMenuItem(mna);
            jm.setVisible(sqltool.isShowInMenu());
            sqlItems.add(new MenuItem(jm));
        }
        MenuItemGroup sqlToolGroup = new MenuItemGroup(sqlItems);
        if (toolItems.size() > 0) {
            menu.addItemGroup(mp, 1);
        }
        if (sqlItems.size() > 0) {
            menu.addItemGroup(sqlToolGroup, 2);
        }
        menu.triggerReload();
    }

    private void addSnippet() {
        NewSnippetView ns = new NewSnippetView();
        String selectedScript = ((Runner)((RunnerModel)this.runnerPresenter.getModel()).getObject()).getSelectedScript();
        SQLTool sl = ns.addSnippet(this.mainFrame, selectedScript != null && selectedScript.length() > 0 ? selectedScript : ((RSyntaxTextArea)((RunnerModel)this.runnerPresenter.getModel()).getCurrentEditor().getValue()).getText());
        if (sl != null) {
            ToolHandler.addSnippet(sl);
        }
    }

    private void handleExternalTools(IMenu menu) {
        ToolHandler.handleExternalTools(this.mainFrame);
        this.rebuildToolMenu(menu);
    }

    private void handleSQLTools(IMenu menu) {
        ToolHandler.handleSQLTools(this.mainFrame);
        this.rebuildToolMenu(menu);
    }
}

