/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.RunnerPresenter;
import com.sigge.filerunner.view.editors.BindingController;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.Menu;
import com.sigge.filerunner.view.menu.MenuItem;
import com.sigge.filerunner.view.menu.MenuItemBuilder;
import com.sigge.filerunner.view.menu.MenuType;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

@Singleton
public class PreferencesMenu
implements Provider<IMenu> {
    private final RunnerPresenter runnerPresenter;
    private final BindingController bindingController;

    @Inject
    PreferencesMenu(RunnerPresenter runnerPresenter, BindingController bindingController) {
        this.runnerPresenter = runnerPresenter;
        this.bindingController = bindingController;
    }

    public IMenu get() {
        Object gridItem = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Use whole line on copy/paste if empty").configSetting("editing.copy_paste_work_on_whole_line_if_empty", false, false).build();
        Object encryptMenuItem = new MenuItemBuilder<JCheckBoxMenuItem>(JCheckBoxMenuItem::new).caption("Encrypt sensitive config data...").icon(IconUtils.getSmallIcon("lock.png")).action(l -> this.runnerPresenter.reCrypt()).defaultValue(ConfigHandler.getConfig().isEncryptedData(), () -> ConfigHandler.getConfig().isEncryptedData()).build();
        Object bindingItem = new MenuItemBuilder<JMenuItem>(JMenuItem::new).caption("Keyboard bindings...").icon(IconUtils.getSmallIcon("keyboard_key.png")).action(l -> this.bindingController.present()).build();
        Menu m = new Menu(MenuType.PREFERENCES);
        m.addItem(new MenuItem((JMenuItem)gridItem), 0);
        m.addItem(new MenuItem((JMenuItem)encryptMenuItem), 1);
        m.addItem(new MenuItem((JMenuItem)bindingItem), 2);
        return m;
    }
}

