/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.sigge.filerunner.view.editors.DotAndCommaFormatter;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.ResultSetTableRenderer;
import com.siggemannen.core.ListUtils;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class NumericEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final ResultSetTableRenderer renderer;
    private final JFormattedTextField editor;
    private final FieldType fieldType;

    public NumericEditor(ResultSetTableRenderer renderer, FieldType fieldType) {
        DotAndCommaFormatter format = new DotAndCommaFormatter();
        this.fieldType = fieldType;
        if (ListUtils.in((Object)((Object)fieldType), (Object[])new FieldType[]{FieldType.SQLBOOLEAN, FieldType.SQLINTEGER, FieldType.SQLLONG})) {
            format.setMaximumFractionDigits(0);
        } else {
            format.setMaximumFractionDigits(99);
        }
        this.renderer = renderer;
        this.editor = new JFormattedTextField(format);
        this.editor.addActionListener(e -> this.stopCellEditing());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editor.setValue(value);
        return this.editor;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.editor.commitEdit();
        }
        catch (ParseException e) {
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getValue();
    }
}

