/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.HighlightingFilter;
import com.sigge.filerunner.sql.CancellableConsumer;
import com.sigge.filerunner.view.DefaultListView;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.IIcon;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.RowFilterExtension;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.APropertyListModel;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ListModelClass;
import com.siggemannen.binding.SoftCopy;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingFunction;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.sort.ListSortController;

public abstract class ALookupEditor<E> {
    private ThrowingConsumer<E> consumerObject;
    private JFrame mainFrame;
    private RowFilterExtension<E> re;
    private String lastFilter = "";
    private String title;
    private CallbackLookup<List<E>> lookup;
    private boolean modal;

    public ALookupEditor(ThrowingConsumer<E> consumerObject, JFrame mainFrame, String title, CallbackLookup<List<E>> lookup, boolean modal) {
        this.consumerObject = consumerObject;
        this.mainFrame = mainFrame;
        this.title = title;
        this.lookup = lookup;
        this.re = new RowFilterExtension(10000000);
        this.modal = modal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E present(String preFilter) {
        DefaultListView tv;
        if (preFilter.length() > 0) {
            this.lastFilter = preFilter;
        }
        if (!(tv = new DefaultListView((Frame)this.mainFrame, this.modal, this.title, this.getClass().getCanonicalName().replace(".", "-"))).isDefault()) {
            tv.setSize(640, 480);
        }
        TextPaneUtil.configureSyntaxTextArea(tv.getItemDetail());
        BindingHolder t = new BindingHolder();
        final JXList itemList = tv.getItemList();
        itemList.setCellRenderer((ListCellRenderer)new LookupCellRenderer(tv.getSearchField()::getText));
        final BindingModel aModel = new BindingModel();
        itemList.addListSelectionListener(e -> {
            Object so = itemList.getSelectedValue();
            tv.getOpenButton().setEnabled(so != null);
        });
        t.setObjects(Collections.EMPTY_LIST);
        final AtomicBoolean manualChange = new AtomicBoolean(false);
        tv.getSearchField().getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> manualChange.set(true))));
        APresenter<BindingHolder, BindingModel, DefaultListView> presenter = new APresenter<BindingHolder, BindingModel, DefaultListView>(aModel, tv){

            protected void initBindings() {
                this.bind((JList)itemList).to(aModel.objectsModel);
                this.bind((JTextComponent)((DefaultListView)this.view).getItemDetail()).to(aModel.objectDescription);
                aModel.objectDescription.addListener(() -> SwingUtilities.invokeLater(() -> ((DefaultListView)this.view).getItemDetail().setCaretPosition(0)));
                ((DefaultListView)this.view).getItemDetail().setSyntaxEditingStyle("text/tsql");
                itemList.setSortable(true);
                itemList.setRowFilter((RowFilter)ALookupEditor.this.re);
                ((DefaultListView)this.view).getSearchField().setHint("Search for objects...");
                ((DefaultListView)this.view).getSearchField().getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> this.filterText())));
                ((DefaultListView)this.view).getOpenButton().addActionListener(a -> this.openObject());
                JListUtils.bindArrowsToFilter(((DefaultListView)this.view).getSearchField(), (JComponent)((DefaultListView)this.view).getItemList(), this::openObject);
            }

            private void filterText() {
                ALookupEditor.this.lastFilter = ((DefaultListView)this.view).getSearchField().getText();
                String regexFromString = FilterHelper.getRegexFromString2(ALookupEditor.this.lastFilter);
                ALookupEditor.this.re.filterOut(((BindingModel)this.model).objectsModel.getObject().stream().filter(v -> v == null || ALookupEditor.this.lastFilter.length() == 0 || ALookupEditor.this.filterByText(v, ALookupEditor.this.lastFilter)), null);
                itemList.setRowFilter((RowFilter)ALookupEditor.this.re);
                if (itemList.getSelectedValue() == null && itemList.getRowSorter().getViewRowCount() > 0) {
                    itemList.setSelectedIndex(0);
                }
                itemList.ensureIndexIsVisible(itemList.getSelectedIndex());
            }

            protected void afterObjectSet() {
                ListSortController sorter = new ListSortController(((BindingModel)this.model).objectsModel);
                itemList.setRowSorter((RowSorter)sorter);
                if (!manualChange.get()) {
                    ALookupEditor.this.setFilter((DefaultListView)this.view);
                }
                this.filterText();
                ((DefaultListView)this.view).getItemDetail().setCaretPosition(0);
            }

            private void openObject() {
                if (itemList.getRowSorter().getViewRowCount() == 0) {
                    return;
                }
                Object selectedItem = this.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                ALookupEditor.this.re.hit(selectedItem);
                ALookupEditor.this.consumerObject.accept(selectedItem);
                if (ALookupEditor.this.modal) {
                    ((DefaultListView)this.view).setVisible(false);
                    ((DefaultListView)this.view).dispose();
                }
            }

            private E getSelectedItem() {
                return ((BindingModel)this.model).objectsModel.getSelectedItem();
            }
        };
        AtomicBoolean cancelled = new AtomicBoolean(false);
        CancellableConsumer callback = new CancellableConsumer(arg_0 -> ALookupEditor.lambda$3(cancelled, tv, t, (APresenter)presenter, arg_0));
        if (!((Boolean)this.lookup.apply(callback)).booleanValue()) {
            AtomicBoolean atomicBoolean = cancelled;
            synchronized (atomicBoolean) {
                if (!cancelled.get()) {
                    tv.getBusyLabel().setText("Loading objects");
                    tv.getBusyLabel().setVisible(true);
                    tv.getBusyLabel().setBusy(true);
                    this.setFilter(tv);
                }
            }
        } else {
            presenter.setObject((Object)t);
        }
        tv.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                tv.dispose();
            }
        });
        tv.setVisible(true);
        return (E)((BindingModel)presenter.getModel()).objectsModel.getSelectedItem();
    }

    private void setFilter(DefaultListView view) {
        if (!this.lastFilter.matches("(?s).*[\n\r].*")) {
            view.getSearchField().setText(this.lastFilter);
        }
        view.getSearchField().selectAll();
    }

    protected abstract boolean filterByText(E var1, String var2);

    protected abstract String resolveDescription(E var1);

    protected String getStringValue(E object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ILabel) {
            return ((ILabel)object).getLabel();
        }
        return object.toString();
    }

    private static /* synthetic */ void lambda$3(AtomicBoolean atomicBoolean, DefaultListView defaultListView, BindingHolder bindingHolder, APresenter aPresenter, List c) throws Throwable {
        SwingUtilities.invokeLater(() -> {
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            synchronized (atomicBoolean2) {
                atomicBoolean.set(true);
                defaultListView.getBusyLabel().setBusy(false);
                defaultListView.getBusyLabel().setVisible(false);
                bindingHolder.setObjects(c);
                aPresenter.setObject((Object)bindingHolder);
            }
        });
    }

    @SoftCopy
    class BindingHolder
    extends ListModelClass<E> {
        BindingHolder() {
        }
    }

    class BindingModel
    extends AModel<BindingHolder> {
        final IProperty<String> objectDescription = this.getProperty(l -> ALookupEditor.this.resolveDescription(l.getCurrent()));
        final AModel.BoundedListProperty<E> objects = this.getBoundListProperty("objects", "current", new IProperty[]{this.objectDescription});
        final APropertyListModel<E> objectsModel = new APropertyListModel(this.objects);

        BindingModel() {
        }
    }

    public static interface CallbackLookup<E>
    extends ThrowingFunction<ThrowingConsumer<E>, Boolean> {
    }

    class LookupCellRenderer
    extends DefaultListCellRenderer {
        private final Supplier<String> filterSupplier;
        HighlightingFilter prev;
        String prevString;

        public LookupCellRenderer(Supplier<String> filterSupplier) {
            this.filterSupplier = filterSupplier;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String icon;
                boolean filterActive;
                Object sl = value;
                String name = ALookupEditor.this.getStringValue(sl);
                boolean bl = filterActive = ALookupEditor.this.re.getFilteredCount() < 200;
                if (filterActive) {
                    String filter = this.filterSupplier.get();
                    if (!filter.equals(this.prevString)) {
                        this.prev = new HighlightingFilter(filter);
                        this.prevString = filter;
                    }
                    name = this.prev.highlight(name);
                }
                if (filterActive) {
                    label.setText("<html>" + name + "</html>");
                } else {
                    label.setText(name);
                }
                if (sl instanceof IIcon && (icon = ((IIcon)sl).getIcon()) != null) {
                    label.setIcon(IconUtils.getSmallIcon(icon));
                }
            }
            return label;
        }
    }
}

