/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.function.Function;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class WideDropDownComboBox
extends JComboBox {
    private static final long serialVersionUID = -2694382778237570550L;
    private boolean layingOut = false;
    private int dropDownMenuWidth = 0;

    public void adjustDropDownMenuWidth() {
        this.adjustDropDownMenuWidth(f -> f != null ? f.toString() : "");
    }

    public void adjustDropDownMenuWidth(Function<Object, String> stringRepresentationFunction) {
        this.dropDownMenuWidth = this.computeMaxItemWidth(stringRepresentationFunction);
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut) {
            dim.width = Math.max(this.dropDownMenuWidth, dim.width);
        }
        return dim;
    }

    private int computeMaxItemWidth(Function<Object, String> stringRepresentationFunction) {
        int numOfItems = this.getItemCount();
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int widest = this.getSize().width;
        String longest = "";
        int i = 0;
        while (i < numOfItems) {
            String item = stringRepresentationFunction.apply(this.getItemAt(i));
            if (item.length() > longest.length()) {
                longest = item;
            }
            ++i;
        }
        widest = Math.max(metrics.stringWidth(longest), widest);
        int scrollbarWidth = (Integer)UIManager.get("ScrollBar.width");
        return widest + scrollbarWidth;
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }
}

