/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class JListUtils {
    public static void bindArrowsToFilter(JTextComponent jt, final JComponent list, final Runnable onEnter) {
        jt.addKeyListener(new KeyAdapter(){
            private boolean enterArmed = false;
            private int countMisHit = 0;

            @Override
            public void keyReleased(KeyEvent e) {
                if (!this.enterArmed) {
                    return;
                }
                if (e.getKeyCode() != 10 && this.countMisHit++ < 2) {
                    return;
                }
                this.enterArmed = false;
                this.countMisHit = 0;
                if (e.getKeyCode() == 10) {
                    onEnter.run();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                boolean bl = this.enterArmed = e.getKeyCode() == 10;
                if (!this.enterArmed) {
                    this.countMisHit = 0;
                }
                if (e.getKeyCode() == 38) {
                    list.getActionForKeyStroke(KeyStroke.getKeyStroke(38, 0)).actionPerformed(new ActionEvent(list, 0, "selectPreviousRow"));
                } else if (e.getKeyCode() == 40) {
                    list.getActionForKeyStroke(KeyStroke.getKeyStroke(40, 0)).actionPerformed(new ActionEvent(list, 0, "selectNextRow"));
                } else if (e.getKeyCode() == 33) {
                    list.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0)).actionPerformed(new ActionEvent(list, 0, "scrollUp"));
                } else if (e.getKeyCode() == 34) {
                    list.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0)).actionPerformed(new ActionEvent(list, 0, "scrollDown"));
                }
            }
        });
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    int index = -1;
                    if (list instanceof JList) {
                        index = ((JList)list).locationToIndex(e.getPoint());
                    }
                    if (index > -1) {
                        onEnter.run();
                    }
                }
            }
        });
    }
}

