/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ExpandableToolTip
implements KeyListener,
MouseListener,
FocusListener,
HyperlinkListener {
    JFrame popup;
    JPanel toolTip;
    JScrollPane help;
    JEditorPane h;
    JComponent owner;
    PopupFactory factory;
    int x;
    int y;
    boolean helpActive = false;
    Thread t;
    int WIDTH_HTML = 250;
    int WIDTH_SC = 300;
    int HEIGHT_SC = 200;
    int WIDTH_TT = 300;
    int HEIGHT_TT = 50;
    private final Component label;
    private String toolTipText;
    private final Consumer<Boolean> tooltipper;

    public ExpandableToolTip(JComponent owner, Consumer<Boolean> tooltipper) {
        this.owner = owner;
        this.tooltipper = tooltipper;
        if (owner instanceof JComboBox) {
            int i = 0;
            while (i < owner.getComponentCount()) {
                owner.getComponent(i).addMouseListener(this);
                ++i;
            }
        } else {
            owner.addMouseListener(this);
        }
        this.toolTip = new JPanel(new GridLayout(3, 1));
        this.toolTip.setPreferredSize(new Dimension(this.WIDTH_TT, this.HEIGHT_TT));
        this.toolTip.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.toolTip.setBackground(Color.getHSBColor(15.0f, 3.0f, 99.0f));
        this.label = this.toolTip.add(new JLabel());
        this.toolTip.add(new JSeparator(0));
        JLabel more = new JLabel("press 'd' for more details");
        more.setForeground(Color.DARK_GRAY);
        more.setFont(new Font(null, 1, 10));
        this.toolTip.add(more);
        JPanel helpContent = new JPanel();
        helpContent.setBackground(Color.WHITE);
        this.h = new JEditorPane();
        this.h.setContentType("text/html");
        this.h.addHyperlinkListener(this);
        this.h.setEditable(true);
        this.h.addHyperlinkListener(this);
        helpContent.add(this.h);
        this.help = new JScrollPane(helpContent);
        this.help.setVerticalScrollBarPolicy(22);
        this.help.setPreferredSize(new Dimension(this.WIDTH_SC, this.HEIGHT_SC));
        this.popup = new JFrame();
        this.popup.setUndecorated(true);
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        if (arg0.getKeyChar() == 'd') {
            this.helpActive = true;
            try {
                this.popup.remove(this.toolTip);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.popup.setLocation(this.x, this.y);
            this.popup.add(this.help);
            this.displayTooltip();
            this.popup.pack();
            this.popup.setVisible(true);
            this.h.requestFocus();
            this.h.addFocusListener(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.tooltipper.accept(true);
        this.toolTipText = this.owner.getToolTipText(arg0);
        this.tooltipper.accept(false);
        Point pos = new Point(arg0.getX(), arg0.getY());
        SwingUtilities.convertPointToScreen(pos, this.owner);
        this.x = (int)pos.getX() + 10;
        this.y = (int)pos.getY() + 10;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)(this.x + this.WIDTH_SC) > screenSize.getWidth()) {
            this.x = this.x - 10 - this.WIDTH_SC;
        }
        if ((double)(this.y + this.HEIGHT_SC) > screenSize.getHeight()) {
            this.y = this.y - 10 - this.HEIGHT_SC;
        }
        this.t = new Thread(() -> {
            boolean cont = true;
            try {
                Thread.sleep(1300L);
            }
            catch (InterruptedException e1) {
                cont = false;
            }
            if (cont && !this.helpActive) {
                try {
                    this.popup.remove(this.help);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.toolTipText == null) {
                    return;
                }
                this.popup.setLocation(this.x, this.y);
                this.popup.add(this.toolTip);
                this.displayTooltip();
                this.popup.pack();
                this.popup.setVisible(true);
            }
        });
        this.t.start();
        this.popup.addKeyListener(this);
    }

    private void displayTooltip() {
        ((JLabel)this.label).setText(this.toolTipText);
        String context = "<html><body><table width='" + this.WIDTH_HTML + "'><tr><td><p><font size=+1>" + this.toolTipText + "</font></p>" + "</td></tr></table></body></html>";
        this.h.setText(context);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        arg0.consume();
        this.t.interrupt();
        if (!this.helpActive) {
            this.popup.setVisible(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.t.interrupt();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.helpActive = false;
        this.popup.setVisible(false);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.h.setPage(event.getURL());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

