/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.view.core.DatabaseUtils;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public class DatabaseCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent jl = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            if (value instanceof DatabaseFromConfig) {
                value = ((DatabaseFromConfig)value).getConfig();
            }
            if (value instanceof RunnerServerConfig) {
                RunnerServerConfig sr = (RunnerServerConfig)value;
                if (!sr.isEnabled()) {
                    jl.setForeground(new Color(153, 153, 153));
                }
                ((JLabel)jl).setText("<html>&nbsp;" + DatabaseUtils.getColorBlob(sr) + (StringUtils.isNotEmpty(sr.getServerLabel()) ? String.valueOf(sr.getServerLabel()) + ": " : "") + sr.toString() + "</html>");
            }
        }
        return jl;
    }
}

