/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.sigge.filerunner.view.core.IWindowState;
import com.siggemannen.sql.antler.TSqlParser;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNDeserializer;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.dfa.DFA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.swing.SwingUtilities2;

@Singleton
public class Cleanuper
extends WindowAdapter
implements IWindowState {
    private boolean hasFocus = true;
    private boolean hadFocusSinceLast1 = true;
    private boolean hadFocusSinceLast2 = true;
    private int misfiresOfGc = 0;
    private int misfiresOfDFAs = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(Cleanuper.class);

    @Inject
    public Cleanuper() {
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleWithFixedDelay(this::cleanUp, 2L, 23L, TimeUnit.MINUTES);
        exec.scheduleWithFixedDelay(this::clearDFAs, 3L, 15L, TimeUnit.MINUTES);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.setHasFocus(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.setHasFocus(true);
        this.hadFocusSinceLast1 = true;
        this.hadFocusSinceLast2 = true;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.setHasFocus(true);
        this.hadFocusSinceLast1 = true;
        this.hadFocusSinceLast2 = true;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.setHasFocus(false);
    }

    private void cleanUp() {
        Field f2;
        if (!this.hadFocusSinceLast1) {
            return;
        }
        try {
            f2 = SwingUtilities2.class.getDeclaredField("charsBuffer");
            f2.setAccessible(true);
            char[] array = (char[])f2.get(null);
            if (array.length > 1000000) {
                f2.set(null, new char[10000]);
            }
        }
        catch (Exception f2) {
            // empty catch block
        }
        try {
            f2 = SQLServerConnection.class.getDeclaredField("parsedSQLCache");
            f2.setAccessible(true);
            Map q = (Map)f2.get(null);
            q.clear();
        }
        catch (Exception e) {
            LOGGER.error("Error while clearing parse cache", (Throwable)e);
        }
        if (!this.isHasFocus()) {
            System.gc();
            this.hadFocusSinceLast1 = false;
        }
    }

    private void clearDFAs() {
        if (this.isHasFocus() || !this.hadFocusSinceLast2) {
            return;
        }
        this.misfiresOfDFAs = 0;
        this.hadFocusSinceLast2 = false;
        try {
            ((ParserATNSimulator)new TSqlParser(null).getInterpreter()).clearDFA();
        }
        catch (Exception e) {
            LOGGER.error("Exception while cleaning DFAs", (Throwable)e);
        }
        try {
            Field f = TSqlParser.class.getDeclaredField("_serializedATN");
            f.setAccessible(true);
            String _serializedATN = (String)f.get(null);
            ATN _ATN = new ATNDeserializer().deserialize(_serializedATN.toCharArray());
            Field f2 = TSqlParser.class.getDeclaredField("_decisionToDFA");
            f2.setAccessible(true);
            DFA[] dfa2 = (DFA[])f2.get(null);
            int i = 0;
            while (i < _ATN.getNumberOfDecisions()) {
                dfa2[i] = new DFA(_ATN.getDecisionState(i), i);
                ++i;
            }
            Field f3 = TSqlParser.class.getDeclaredField("_sharedContextCache");
            f3.setAccessible(true);
            PredictionContextCache cache = (PredictionContextCache)f3.get(null);
            if (cache != null) {
                Field f4 = PredictionContextCache.class.getDeclaredField("cache");
                f4.setAccessible(true);
                Map cacheMap = (Map)f4.get(cache);
                if (cacheMap != null) {
                    cacheMap.clear();
                }
            }
            System.gc();
        }
        catch (Exception exx) {
            LOGGER.error("Exception while cleaning internal fields", (Throwable)exx);
        }
    }

    @Override
    public boolean isHasFocus() {
        return this.hasFocus;
    }

    private void setHasFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }
}

